/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.set;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.matcher.ClassArrayMatcher;
import net.vidageek.mirror.matcher.MatchType;
import net.vidageek.mirror.provider.FieldReflectionProvider;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.set.dsl.FieldSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldSetterByField
implements FieldSetter {
    private final Object target;
    private final Field field;
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public FieldSetterByField(ReflectionProvider provider, Object target, Class<?> clazz, Field field) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (!field.getDeclaringClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("field declaring class (" + field.getDeclaringClass().getName() + ") doesn't match clazz " + clazz.getName());
        }
        this.provider = provider;
        this.target = target;
        this.clazz = clazz;
        this.field = field;
    }

    @Override
    public void withValue(Object value) {
        MatchType match;
        if (this.target == null && !Modifier.isStatic(this.field.getModifiers())) {
            throw new MirrorException("attempt to set instance field " + this.field.getName() + " on class " + this.clazz.getName());
        }
        if (value == null && this.field.getType().isPrimitive()) {
            throw new IllegalArgumentException("cannot set null value on primitive field");
        }
        if (value != null && MatchType.DONT_MATCH.equals((Object)(match = new ClassArrayMatcher(value.getClass()).match(this.field.getType())))) {
            throw new IllegalArgumentException("Value of type " + value.getClass() + " cannot be set on field " + this.field.getName() + " of type " + this.field.getType() + " from class " + this.clazz.getName() + ". Incompatible types");
        }
        FieldReflectionProvider fieldReflectionProvider = this.provider.getFieldReflectionProvider(this.target, this.clazz, this.field);
        fieldReflectionProvider.setAccessible();
        fieldReflectionProvider.setValue(value);
    }
}

