/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.set;

import java.lang.reflect.Field;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.set.FieldSetterByField;
import net.vidageek.mirror.set.dsl.FieldSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldSetterByName
implements FieldSetter {
    private final String fieldName;
    private final Object target;
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public FieldSetterByName(ReflectionProvider provider, String fieldName, Object target, Class<?> clazz) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new IllegalArgumentException("fieldName cannot be null or blank");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.provider = provider;
        this.fieldName = fieldName;
        this.target = target;
        this.clazz = clazz;
    }

    @Override
    public void withValue(Object value) {
        Field field = new Mirror(this.provider).on(this.clazz).reflect().field(this.fieldName);
        if (field == null) {
            throw new MirrorException("could not find field " + this.fieldName + " on class " + this.clazz.getName());
        }
        new FieldSetterByField(this.provider, this.target, this.clazz, field).withValue(value);
    }
}

