/*
 * Decompiled with CFR 0.152.
 */
package net.zetetic.database;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import java.lang.ref.WeakReference;
import net.zetetic.database.CursorWindow;
import net.zetetic.database.DatabaseUtils;
import net.zetetic.database.Logger;

public abstract class AbstractCursor
implements Cursor {
    private static final String TAG = "Cursor";
    protected int mPos = -1;
    protected boolean mClosed;
    protected ContentResolver mContentResolver;
    private Uri mNotifyUri;
    private final Object mSelfObserverLock = new Object();
    private ContentObserver mSelfObserver;
    private boolean mSelfObserverRegistered;
    private final DataSetObservable mDataSetObservable = new DataSetObservable();
    private final ContentObservable mContentObservable = new ContentObservable();
    private Bundle mExtras = Bundle.EMPTY;

    public void fillWindow(int position, CursorWindow window) {
        DatabaseUtils.cursorFillWindow(this, position, window);
    }

    public abstract int getCount();

    public abstract String[] getColumnNames();

    public abstract String getString(int var1);

    public abstract short getShort(int var1);

    public abstract int getInt(int var1);

    public abstract long getLong(int var1);

    public abstract float getFloat(int var1);

    public abstract double getDouble(int var1);

    public abstract boolean isNull(int var1);

    public abstract int getType(int var1);

    public byte[] getBlob(int column) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    public void deactivate() {
        this.onDeactivateOrClose();
    }

    protected void onDeactivateOrClose() {
        if (this.mSelfObserver != null) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    public boolean requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.onDeactivateOrClose();
    }

    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        String result = this.getString(columnIndex);
        if (result != null) {
            char[] data = buffer.data;
            if (data == null || data.length < result.length()) {
                buffer.data = result.toCharArray();
            } else {
                result.getChars(0, result.length(), data, 0);
            }
            buffer.sizeCopied = result.length();
        } else {
            buffer.sizeCopied = 0;
        }
    }

    public final int getPosition() {
        return this.mPos;
    }

    public final boolean moveToPosition(int position) {
        int count = this.getCount();
        if (position >= count) {
            this.mPos = count;
            return false;
        }
        if (position < 0) {
            this.mPos = -1;
            return false;
        }
        if (position == this.mPos) {
            return true;
        }
        boolean result = this.onMove(this.mPos, position);
        this.mPos = !result ? -1 : position;
        return result;
    }

    public abstract boolean onMove(int var1, int var2);

    public final boolean move(int offset) {
        return this.moveToPosition(this.mPos + offset);
    }

    public final boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    public final boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    public final boolean moveToNext() {
        return this.moveToPosition(this.mPos + 1);
    }

    public final boolean moveToPrevious() {
        return this.moveToPosition(this.mPos - 1);
    }

    public final boolean isFirst() {
        return this.mPos == 0 && this.getCount() != 0;
    }

    public final boolean isLast() {
        int cnt = this.getCount();
        return this.mPos == cnt - 1 && cnt != 0;
    }

    public final boolean isBeforeFirst() {
        return this.getCount() == 0 || this.mPos == -1;
    }

    public final boolean isAfterLast() {
        return this.getCount() == 0 || this.mPos == this.getCount();
    }

    public int getColumnIndex(String columnName) {
        int periodIndex = columnName.lastIndexOf(46);
        if (periodIndex != -1) {
            Exception e = new Exception();
            Logger.e(TAG, "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        String[] columnNames = this.getColumnNames();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getColumnIndexOrThrow(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index < 0) {
            throw new IllegalArgumentException("column '" + columnName + "' does not exist");
        }
        return index;
    }

    public String getColumnName(int columnIndex) {
        return this.getColumnNames()[columnIndex];
    }

    public void registerContentObserver(ContentObserver observer) {
        this.mContentObservable.registerObserver(observer);
    }

    public void unregisterContentObserver(ContentObserver observer) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver((Object)observer);
        }
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChange(boolean selfChange) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mContentObservable.dispatchChange(selfChange, null);
            } else {
                this.mContentObservable.dispatchChange(selfChange);
            }
            if (this.mNotifyUri != null && selfChange) {
                this.mContentResolver.notifyChange(this.mNotifyUri, this.mSelfObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationUri(ContentResolver cr, Uri notifyUri) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = notifyUri;
            this.mContentResolver = cr;
            if (this.mSelfObserver != null) {
                this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            }
            this.mSelfObserver = new SelfContentObserver(this);
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri getNotificationUri() {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            return this.mNotifyUri;
        }
    }

    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    public void setExtras(Bundle extras) {
        this.mExtras = extras == null ? Bundle.EMPTY : extras;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public Bundle respond(Bundle extras) {
        return Bundle.EMPTY;
    }

    protected void checkPosition() {
        if (-1 == this.mPos || this.getCount() == this.mPos) {
            throw new CursorIndexOutOfBoundsException(this.mPos, this.getCount());
        }
    }

    protected void finalize() {
        if (this.mSelfObserver != null && this.mSelfObserverRegistered) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
        }
        try {
            if (!this.mClosed) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class SelfContentObserver
    extends ContentObserver {
        WeakReference<AbstractCursor> mCursor;

        public SelfContentObserver(AbstractCursor cursor) {
            super(null);
            this.mCursor = new WeakReference<AbstractCursor>(cursor);
        }

        public boolean deliverSelfNotifications() {
            return false;
        }

        public void onChange(boolean selfChange) {
            AbstractCursor cursor = (AbstractCursor)this.mCursor.get();
            if (cursor != null) {
                cursor.onChange(false);
            }
        }
    }
}

