/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.GlobalOptions;

public class StandardAdminHandler
implements AdminHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry, GlobalOptions globalOptions) throws IOException {
        File entriesFile;
        File repositoryFile;
        File CVSdir = new File(localDirectory, "CVS");
        CVSdir.mkdirs();
        File rootFile = new File(CVSdir, "Root");
        if (!rootFile.exists()) {
            BufferedWriter w = new BufferedWriter(new FileWriter(rootFile));
            try {
                w.write(globalOptions.getCVSRoot());
            }
            finally {
                ((Writer)w).close();
            }
        }
        if (!(repositoryFile = new File(CVSdir, "Repository")).exists()) {
            BufferedWriter w = new BufferedWriter(new FileWriter(repositoryFile));
            try {
                if (repositoryPath.endsWith("/")) {
                    repositoryPath = repositoryPath.substring(0, repositoryPath.length() - 1);
                }
                if (repositoryPath.length() == 0) {
                    repositoryPath = ".";
                }
                w.write(repositoryPath);
            }
            finally {
                ((Writer)w).close();
            }
        }
        if ((entriesFile = new File(CVSdir, "Entries")).createNewFile()) {
            this.addDirectoryToParentEntriesFile(CVSdir);
            BufferedWriter w = new BufferedWriter(new FileWriter(entriesFile));
            try {
                w.write("D");
            }
            finally {
                ((Writer)w).close();
            }
        }
        if (entry != null) {
            this.updateEntriesFile(entriesFile, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void addDirectoryToParentEntriesFile(File CVSdir) throws IOException {
        block15: {
            parentCVSEntries = new File(CVSdir.getParentFile().getParentFile(), "CVS/Entries");
            if (!parentCVSEntries.exists()) break block15;
            directory = parentCVSEntries.getParentFile();
            tempFile = new File(directory, "Entries.Backup");
            tempFile.createNewFile();
            reader = null;
            writer = null;
            try {
                reader = new BufferedReader(new FileReader(parentCVSEntries));
                writer = new BufferedWriter(new FileWriter(tempFile));
                written = false;
                directoryEntry = new Entry();
                directoryEntry.setName(CVSdir.getParentFile().getName());
                directoryEntry.setDirectory(true);
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("D")) continue;
                    currentEntry = new Entry(line);
                    if (currentEntry.getName() != null && currentEntry.getName().equals(directoryEntry.getName())) {
                        writer.write(directoryEntry.toString());
                        written = true;
                    } else {
                        writer.write(line);
                    }
                    writer.newLine();
                }
                if (!written) {
                    writer.write(directoryEntry.toString());
                    writer.newLine();
                }
                var12_11 = null;
            }
            catch (Throwable var11_15) {
                var12_12 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                throw var11_15;
            }
            try {
                if (writer == null) ** GOTO lbl52
                writer.close();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
lbl52:
            // 2 sources

            temp2 = new File(directory, "Entries.Backup2");
            parentCVSEntries.renameTo(temp2);
            tempFile.renameTo(parentCVSEntries);
            temp2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateEntriesFile(File originalFile, Entry entry) throws IOException {
        directory = originalFile.getParentFile();
        tempFile = new File(directory, "Entries.Backup");
        tempFile.createNewFile();
        reader = null;
        writer = null;
        try {
            reader = new BufferedReader(new FileReader(originalFile));
            writer = new BufferedWriter(new FileWriter(tempFile));
            written = false;
            while ((line = reader.readLine()) != null) {
                currentEntry = new Entry(line);
                if (currentEntry.getName() != null && currentEntry.getName().equals(entry.getName())) {
                    writer.write(entry.toString());
                    written = true;
                } else {
                    writer.write(line);
                }
                writer.newLine();
            }
            if (!written) {
                writer.write(entry.toString());
                writer.newLine();
            }
            var11_10 = null;
        }
        catch (Throwable var10_14) {
            var11_11 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            throw var10_14;
        }
        try {
            if (writer == null) ** GOTO lbl46
            writer.close();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
lbl46:
        // 2 sources

        temp2 = new File(directory, "Entries.Backup2");
        originalFile.renameTo(temp2);
        tempFile.renameTo(originalFile);
        temp2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(File file) throws IOException {
        File entriesFile = new File(file.getParent(), "CVS/Entries");
        if (entriesFile == null || !entriesFile.exists()) {
            return null;
        }
        this.processEntriesDotLog(new File(file.getParent(), "CVS"));
        BufferedReader reader = null;
        Entry entry = null;
        boolean found = false;
        try {
            String line;
            reader = new BufferedReader(new FileReader(entriesFile));
            while (!found && (line = reader.readLine()) != null) {
                entry = new Entry(line);
                if (entry.getName() == null) continue;
                found = entry.getName().equals(file.getName());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!found) {
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getEntriesAsArray(File directory) throws IOException {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        File entriesFile = new File(directory, "CVS/Entries");
        if (entriesFile == null || !entriesFile.exists()) {
            return new Entry[0];
        }
        this.processEntriesDotLog(new File(directory, "CVS"));
        BufferedReader reader = null;
        Entry entry = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(entriesFile));
            while ((line = reader.readLine()) != null) {
                entry = new Entry(line);
                if (entry.getName() == null) continue;
                entries.add(entry);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Entry[] toReturnArray = new Entry[entries.size()];
        toReturnArray = entries.toArray(toReturnArray);
        return toReturnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getEntries(File directory) throws IOException {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        File entriesFile = new File(directory, "CVS/Entries");
        if (entriesFile == null || !entriesFile.exists()) {
            return entries.iterator();
        }
        this.processEntriesDotLog(new File(directory, "CVS"));
        BufferedReader reader = null;
        Entry entry = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(entriesFile));
            while ((line = reader.readLine()) != null) {
                entry = new Entry(line);
                if (entry.getName() == null) continue;
                entries.add(entry);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return entries.iterator();
    }

    public void setEntry(File file, Entry entry) throws IOException {
        String parent = file.getParent();
        File entriesFile = new File(parent, "CVS/Entries");
        this.processEntriesDotLog(new File(parent, "CVS"));
        this.updateEntriesFile(entriesFile, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void removeEntry(File file) throws IOException {
        entriesFile = new File(file.getParent(), "CVS/Entries");
        if (entriesFile == null || !entriesFile.exists()) {
            return;
        }
        this.processEntriesDotLog(new File(file.getParent(), "CVS"));
        directory = file.getParentFile();
        tempFile = new File(directory, "Entries.Backup");
        tempFile.createNewFile();
        reader = null;
        writer = null;
        try {
            reader = new BufferedReader(new FileReader(entriesFile));
            writer = new BufferedWriter(new FileWriter(tempFile));
            directoriesExist = false;
            while ((line = reader.readLine()) != null) {
                currentEntry = new Entry(line);
                if (currentEntry.getName() == null || currentEntry.getName().equals(file.getName())) continue;
                writer.write(currentEntry.toString());
                writer.newLine();
                directoriesExist = directoriesExist != false || currentEntry.isDirectory() != false;
            }
            if (!directoriesExist) {
                writer.write("D");
                writer.newLine();
            }
            var11_10 = null;
        }
        catch (Throwable var10_14) {
            var11_11 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            throw var10_14;
        }
        try {
            if (writer == null) ** GOTO lbl48
            writer.close();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
lbl48:
        // 2 sources

        temp2 = new File(directory, "Entries.Backup2");
        entriesFile.renameTo(temp2);
        tempFile.renameTo(entriesFile);
        temp2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryForDirectory(String directory, String repository) throws IOException {
        File repositoryFile = null;
        String repositoryDirs = "";
        File dirFile = new File(directory);
        while (true) {
            if (dirFile == null || dirFile.getName().length() == 0 || !dirFile.exists()) {
                throw new FileNotFoundException("Repository file not found for directory " + directory);
            }
            repositoryFile = new File(dirFile, "CVS/Repository");
            if (repositoryFile.exists()) break;
            repositoryDirs = '/' + dirFile.getName() + repositoryDirs;
            dirFile = dirFile.getParentFile();
        }
        BufferedReader reader = null;
        String fileRepository = null;
        try {
            reader = new BufferedReader(new FileReader(repositoryFile));
            fileRepository = reader.readLine();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (fileRepository == null) {
            fileRepository = "";
        }
        if ((fileRepository = fileRepository + repositoryDirs).startsWith("/")) {
            return fileRepository;
        }
        return repository + '/' + fileRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntriesDotLog(File directory) throws IOException {
        String line;
        File entriesDotLogFile = new File(directory, "Entries.Log");
        if (!entriesDotLogFile.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(entriesDotLogFile));
        LinkedList<Entry> additionsList = new LinkedList<Entry>();
        HashSet<String> removalSet = new HashSet<String>();
        try {
            while ((line = reader.readLine()) != null) {
                Entry entry;
                if (line.startsWith("A ")) {
                    entry = new Entry(line.substring(2));
                    additionsList.add(entry);
                    continue;
                }
                if (!line.startsWith("R ")) continue;
                entry = new Entry(line.substring(2));
                removalSet.add(entry.getName());
            }
        }
        finally {
            reader.close();
        }
        if (additionsList.size() > 0 || removalSet.size() > 0) {
            File backup = new File(directory, "Entries.Backup");
            BufferedWriter writer = new BufferedWriter(new FileWriter(backup));
            File entriesFile = new File(directory, "Entries");
            reader = new BufferedReader(new FileReader(entriesFile));
            try {
                int directoryCount = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("D")) continue;
                    Entry entry = new Entry(line);
                    if (entry.isDirectory()) {
                        ++directoryCount;
                    }
                    if (removalSet.contains(entry.getName())) continue;
                    writer.write(entry.toString());
                    writer.newLine();
                    if (!entry.isDirectory()) continue;
                    --directoryCount;
                }
                Iterator it = additionsList.iterator();
                while (it.hasNext()) {
                    Entry entry = (Entry)it.next();
                    if (entry.isDirectory()) {
                        ++directoryCount;
                    }
                    writer.write(entry.toString());
                    writer.newLine();
                }
                if (directoryCount == 0) {
                    writer.write("D");
                    writer.newLine();
                }
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    reader.close();
                }
                finally {
                    writer.close();
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            finally {
                writer.close();
            }
            File temp2 = new File(directory, "Entries.Backup2");
            entriesFile.renameTo(temp2);
            backup.renameTo(entriesFile);
            temp2.delete();
        }
        entriesDotLogFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllFiles(File directory) throws IOException {
        TreeSet<File> fileSet = new TreeSet<File>();
        BufferedReader reader = null;
        try {
            String line;
            File entriesFile = new File(directory, "CVS/Entries");
            if (!entriesFile.exists()) {
                TreeSet<File> treeSet = fileSet;
                return treeSet;
            }
            reader = new BufferedReader(new FileReader(entriesFile));
            while ((line = reader.readLine()) != null) {
                File f;
                Entry entry = new Entry(line);
                if (entry.getName() == null || (f = new File(directory, entry.getName())).isDirectory()) continue;
                fileSet.add(f);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return fileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStickyTagForDirectory(File directory) {
        String tag2;
        BufferedReader reader = null;
        File tagFile = new File(directory, "CVS/Tag");
        reader = new BufferedReader(new FileReader(tagFile));
        String string = tag2 = reader.readLine();
        Object var7_7 = null;
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException ex2) {
            // empty catch block
        }
        return string;
        catch (IOException ex) {
            try {
                Object var7_8 = null;
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException ex2) {}
            return null;
        }
    }
}

