/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.add;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;

public class AddCommand
extends BuildableCommand {
    private static final String DIR_ADDED = " added to the repository";
    private static final String DIRECTORY = "Directory ";
    private List requests;
    private final List argumentRequests = new LinkedList();
    private final List newDirList = new LinkedList();
    private ClientServices clientServices;
    private File[] files;
    private String message;
    private KeywordSubstitutionOptions keywordSubst;

    public AddCommand() {
        this.resetCVSCommand();
    }

    public void setFiles(File[] files) {
        this.files = files;
        if (files == null) {
            return;
        }
        this.files = new File[files.length];
        int dirCount = 0;
        int fileCount = 0;
        int totalCount = files.length;
        for (int index = 0; index < totalCount; ++index) {
            File currentFile = files[index];
            if (currentFile.isDirectory()) {
                this.files[dirCount] = currentFile;
                ++dirCount;
                continue;
            }
            this.files[totalCount - (1 + fileCount)] = currentFile;
            ++fileCount;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File getFileEndingWith(String ending) {
        String locEnding = ending.replace('\\', '/');
        String localDir = this.getLocalDirectory().replace('\\', '/');
        int index = 0;
        for (index = 0; index < this.files.length; ++index) {
            String path = this.files[index].getAbsolutePath();
            String parentPath = this.files[index].getParentFile().getAbsolutePath().replace('\\', '/');
            if ((!(path = path.replace('\\', '/')).endsWith(locEnding) || locEnding.indexOf(47) < 0) && (!this.files[index].getName().equals(locEnding) || !parentPath.equals(localDir))) continue;
            return this.files[index];
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubst) {
        this.keywordSubst = keywordSubst;
    }

    protected void addRequests(File file) throws IOException, CommandException {
        if (file.isDirectory()) {
            this.addRequestsForDirectory(file, false);
        } else {
            this.addRequestsForFile(file);
        }
    }

    private void addRequestsForDirectory(File directory, boolean recursion) throws IOException {
        String tag2;
        String repository;
        String partPath;
        String dir;
        File parentDirectory = directory.getParentFile();
        String string = dir = recursion ? this.getRelativeToLocalPathInUnixStyle(directory) : this.getRelativeToLocalPathInUnixStyle(parentDirectory);
        if (dir.equals(".")) {
            partPath = directory.getName();
        } else {
            partPath = dir + "/" + directory.getName();
            this.addRequestsForDirectory(parentDirectory, true);
        }
        if (recursion) {
            partPath = dir;
        }
        if (recursion) {
            repository = this.clientServices.getRepositoryForDirectory(directory.getAbsolutePath());
            tag2 = this.clientServices.getStickyTagForDirectory(directory);
        } else {
            repository = this.clientServices.getRepositoryForDirectory(parentDirectory.getAbsolutePath());
            repository = repository.endsWith(".") ? repository.substring(0, repository.length() - 1) + directory.getName() : repository + "/" + directory.getName();
            tag2 = this.clientServices.getStickyTagForDirectory(parentDirectory);
        }
        this.requests.add(new DirectoryRequest(partPath, repository));
        if (tag2 != null) {
            this.requests.add(new StickyRequest(tag2));
        }
        if (!recursion) {
            this.argumentRequests.add(new ArgumentRequest(partPath));
            this.newDirList.add(new Paths(partPath, repository));
        }
    }

    protected void addRequestsForFile(File file) throws IOException {
        Entry entry;
        File directory = file.getParentFile();
        String dir = this.getRelativeToLocalPathInUnixStyle(directory);
        String repository = this.clientServices.getRepositoryForDirectory(directory.getAbsolutePath());
        this.requests.add(new DirectoryRequest(dir, repository));
        String tag2 = this.clientServices.getStickyTagForDirectory(directory);
        if (tag2 != null) {
            this.requests.add(new StickyRequest(tag2));
        }
        if ((entry = this.clientServices.getEntry(file)) != null) {
            this.requests.add(new EntryRequest(entry));
        } else {
            boolean isBinary = this.getKeywordSubst() == KeywordSubstitutionOptions.BINARY;
            this.requests.add(new ModifiedRequest(file, isBinary));
        }
        if (dir.equals(".")) {
            this.argumentRequests.add(new ArgumentRequest(file.getName()));
        } else {
            this.argumentRequests.add(new ArgumentRequest(dir + "/" + file.getName()));
        }
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        String message;
        if (this.files == null || this.files.length == 0) {
            throw new CommandException("No files have been specified for adding.", CommandException.getLocalMessage("AddCommand.noFilesSpecified", null));
        }
        client.ensureConnection();
        this.clientServices = client;
        this.setLocalDirectory(client.getLocalPath());
        this.newDirList.clear();
        super.execute(client, em);
        this.requests = new LinkedList();
        if (client.isFirstCommand()) {
            this.requests.add(new RootRequest(client.getRepository()));
        }
        if ((message = this.getMessage()) != null) {
            message = message.trim();
        }
        if (message != null && message.length() > 0) {
            this.addMessageRequest(message);
        }
        if (this.getKeywordSubst() != null && !this.getKeywordSubst().equals("")) {
            this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubst()));
        }
        try {
            for (int i = 0; i < this.files.length; ++i) {
                this.addRequests(this.files[i]);
            }
            this.requests.add(new DirectoryRequest(".", client.getRepositoryForDirectory(this.getLocalDirectory())));
            this.requests.addAll(this.argumentRequests);
            this.argumentRequests.clear();
            this.requests.add(CommandRequest.ADD);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    private void addMessageRequest(String message) {
        this.requests.add(new ArgumentRequest("-m"));
        StringTokenizer token = new StringTokenizer(message, "\n", false);
        boolean first = true;
        while (token.hasMoreTokens()) {
            if (first) {
                this.requests.add(new ArgumentRequest(token.nextToken()));
                first = false;
                continue;
            }
            this.requests.add(new ArgumentxRequest(token.nextToken()));
        }
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("add ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            for (int index = 0; index < files.length; ++index) {
                toReturn.append(files[index].getName());
                toReturn.append(' ');
            }
        }
        return toReturn.toString();
    }

    public Builder createBuilder(EventManager eventManager) {
        return new AddBuilder(eventManager, this);
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'm') {
            this.setMessage(optArg);
        } else if (opt == 'k') {
            KeywordSubstitutionOptions keywordSubst = KeywordSubstitutionOptions.findKeywordSubstOption(optArg);
            this.setKeywordSubst(keywordSubst);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "m:k:";
    }

    public void messageSent(MessageEvent e) {
        String str = e.getMessage();
        if (str.endsWith(DIR_ADDED)) {
            str = str.substring(DIRECTORY.length(), str.indexOf(DIR_ADDED)).trim();
            this.createCvsFiles(str);
        }
        super.messageSent(e);
    }

    private void createCvsFiles(String newDirInRepository) {
        String repository = newDirInRepository;
        String dirName = repository;
        if (dirName.lastIndexOf(47) >= 0) {
            dirName = dirName.substring(dirName.lastIndexOf(47) + 1, dirName.length());
        }
        if (this.newDirList.size() == 0) {
            System.err.println("JavaCVS: Bug in AddCommand|createCvsFiles");
            System.err.println("         newDirInRepository = " + newDirInRepository);
            return;
        }
        Paths paths = (Paths)this.newDirList.remove(0);
        String local = paths.getPartPath();
        String part = paths.getRepositoryPath();
        repository = paths.getRepositoryPath();
        String tempDirName = part;
        if (part.lastIndexOf(47) >= 0) {
            tempDirName = part.substring(part.lastIndexOf(47) + 1, part.length());
        }
        if (!tempDirName.equalsIgnoreCase(dirName)) {
            System.err.println("JavaCVS: Bug in AddCommand|createCvsFiles");
            System.err.println("         newDirInRepository = " + newDirInRepository);
            System.err.println("         tempDirName = " + tempDirName);
            System.err.println("         dirName = " + dirName);
            return;
        }
        try {
            if (repository.startsWith(".")) {
                repository = repository.substring(1);
            }
            this.clientServices.updateAdminData(local, repository, null);
            this.createCvsTagFile(local, repository);
        }
        catch (IOException ex) {
            System.err.println("TODO: couldn't create/update Cvs admin files");
        }
    }

    private void createCvsTagFile(String local, String repository) throws IOException {
        File current = new File(this.getLocalDirectory(), local);
        File parent = current.getParentFile();
        String tag2 = this.clientServices.getStickyTagForDirectory(parent);
        if (tag2 != null) {
            File tagFile = new File(current, "CVS/Tag");
            tagFile.createNewFile();
            PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(tagFile)));
            w.println(tag2);
            w.close();
        }
    }

    public void resetCVSCommand() {
        this.setMessage(null);
        this.setKeywordSubst(null);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer();
        if (this.getMessage() != null) {
            toReturn.append("-m \"");
            toReturn.append(this.getMessage());
            toReturn.append("\" ");
        }
        if (this.getKeywordSubst() != null) {
            toReturn.append("-k");
            toReturn.append(this.getKeywordSubst().toString());
            toReturn.append(" ");
        }
        return toReturn.toString();
    }

    private static class Paths {
        private final String partPath;
        private final String repositoryPath;

        public Paths(String partPath, String repositoryPath) {
            this.partPath = partPath;
            this.repositoryPath = repositoryPath;
        }

        public String getPartPath() {
            return this.partPath;
        }

        public String getRepositoryPath() {
            return this.repositoryPath;
        }
    }
}

