/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.checkout;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.PipedFilesBuilder;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.command.checkout.ModuleListBuilder;
import org.netbeans.lib.cvsclient.command.update.UpdateBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;

public class CheckoutCommand
extends BasicCommand
implements TemporaryFileCreator {
    private static final String UPDATING = ": Updating ";
    private final Set emptyDirectories = new HashSet();
    private final List modules = new LinkedList();
    private final List expandedModules = new LinkedList();
    private boolean showModules;
    private boolean showModulesWithStatus;
    private boolean pipeToOutput;
    private boolean pruneDirectories;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private boolean notShortenPaths;
    private String checkoutByDate;
    private String checkoutByRevision;
    private String checkoutDirectory;
    private KeywordSubstitutionOptions keywordSubst;
    private boolean notRunModuleProgram;

    public CheckoutCommand(boolean recursive, String[] modules) {
        this.resetCVSCommand();
        this.setRecursive(recursive);
        this.setModules(modules);
    }

    public CheckoutCommand(boolean recursive, String module) {
        this.resetCVSCommand();
        this.setRecursive(recursive);
        this.setModule(module);
    }

    public CheckoutCommand() {
        this.resetCVSCommand();
        this.setRecursive(true);
    }

    public void setModule(String module) {
        this.modules.add(module);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] modules) {
        this.clearModules();
        for (int i = 0; i < modules.length; ++i) {
            String module = modules[i];
            this.modules.add(module);
        }
    }

    public String[] getModules() {
        String[] mods = new String[this.modules.size()];
        mods = this.modules.toArray(mods);
        return mods;
    }

    private void processExistingModules(String localPath) {
        if (this.expandedModules.size() == 0) {
            return;
        }
        ArrayList<File> list = new ArrayList<File>(this.expandedModules.size());
        Iterator it = this.expandedModules.iterator();
        while (it.hasNext()) {
            String moduleName = (String)it.next();
            if (moduleName.equals(".")) {
                list.add(new File(localPath));
                break;
            }
            File moduleDir = null;
            File moduleFile = new File(localPath, moduleName);
            moduleDir = moduleFile.isFile() ? moduleFile.getParentFile() : moduleFile;
            File moduleCVSDir = new File(moduleDir, "CVS/Repository");
            if (!moduleCVSDir.exists()) continue;
            list.add(moduleFile);
        }
        File[] directories = new File[list.size()];
        directories = list.toArray(directories);
        this.setFiles(directories);
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.requests = new LinkedList();
        if (client.isFirstCommand()) {
            this.requests.add(new RootRequest(client.getRepository()));
        }
        if (this.showModules || this.showModulesWithStatus) {
            if (this.builder == null && !this.isBuilderSet()) {
                this.builder = this.createBuilder(em);
            }
            if (this.showModules) {
                this.requests.add(new ArgumentRequest("-c"));
            }
            if (this.showModulesWithStatus) {
                this.requests.add(new ArgumentRequest("-s"));
            }
            this.requests.add(CommandRequest.CHECKOUT);
            try {
                client.processRequests(this.requests);
                this.requests.clear();
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (EOFException ex) {
                throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
            return;
        }
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.expandedModules.clear();
        this.requests.add(new ExpandModulesRequest());
        try {
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(client, em);
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return false;
    }

    public void moduleExpanded(ModuleExpansionEvent e) {
        this.expandedModules.add(e.getModule());
    }

    private void postExpansionExecute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        this.processExistingModules(client.getLocalPath());
        super.execute(client, em);
        boolean FIRST_INDEX = false;
        boolean SECOND_INDEX = true;
        if (!this.isRecursive()) {
            this.requests.add(0, new ArgumentRequest("-l"));
        }
        if (this.pipeToOutput) {
            this.requests.add(0, new ArgumentRequest("-p"));
        }
        if (this.resetStickyOnes) {
            this.requests.add(0, new ArgumentRequest("-A"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(0, new ArgumentRequest("-f"));
        }
        if (this.notShortenPaths) {
            this.requests.add(0, new ArgumentRequest("-N"));
        }
        if (this.notRunModuleProgram) {
            this.requests.add(0, new ArgumentRequest("-n"));
        }
        if (this.checkoutByDate != null && this.checkoutByDate.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-D"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutByDate()));
        }
        if (this.checkoutByRevision != null && this.checkoutByRevision.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-r"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutByRevision()));
        }
        if (this.checkoutDirectory != null && !this.checkoutDirectory.equals("")) {
            this.requests.add(0, new ArgumentRequest("-d"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutDirectory()));
        }
        if (this.getKeywordSubst() != null) {
            this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubst()));
        }
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.requests.add(new DirectoryRequest(".", client.getRepository()));
        this.requests.add(CommandRequest.CHECKOUT);
        try {
            client.processRequests(this.requests);
            if (this.pruneDirectories) {
                this.pruneEmptyDirectories();
            }
            this.requests.clear();
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
    }

    public boolean isShowModules() {
        return this.showModules;
    }

    public void setShowModules(boolean showModules) {
        this.showModules = showModules;
    }

    public boolean isShowModulesWithStatus() {
        return this.showModulesWithStatus;
    }

    public void setShowModulesWithStatus(boolean showModulesWithStatus) {
        this.showModulesWithStatus = showModulesWithStatus;
    }

    public void setPruneDirectories(boolean pruneDirectories) {
        this.pruneDirectories = pruneDirectories;
    }

    public boolean getPruneDirectories() {
        return this.pruneDirectories;
    }

    public boolean isPipeToOutput() {
        return this.pipeToOutput;
    }

    public void setPipeToOutput(boolean pipeToOutput) {
        this.pipeToOutput = pipeToOutput;
    }

    public boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    public void setResetStickyOnes(boolean resetStickyOnes) {
        this.resetStickyOnes = resetStickyOnes;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    public boolean isNotShortenPaths() {
        return this.notShortenPaths;
    }

    public void setNotShortenPaths(boolean notShortenPaths) {
        this.notShortenPaths = notShortenPaths;
    }

    public boolean isNotRunModuleProgram() {
        return this.notRunModuleProgram;
    }

    public void setNotRunModuleProgram(boolean notRunModuleProgram) {
        this.notRunModuleProgram = notRunModuleProgram;
    }

    public String getCheckoutByDate() {
        return this.checkoutByDate;
    }

    public void setCheckoutByDate(String checkoutByDate) {
        this.checkoutByDate = checkoutByDate;
    }

    public String getCheckoutByRevision() {
        return this.checkoutByRevision;
    }

    public void setCheckoutByRevision(String checkoutByRevision) {
        this.checkoutByRevision = checkoutByRevision;
    }

    public String getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public void setCheckoutDirectory(String checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubst) {
        this.keywordSubst = keywordSubst;
    }

    public Builder createBuilder(EventManager eventMan) {
        if (this.isShowModules() || this.isShowModulesWithStatus()) {
            return new ModuleListBuilder(eventMan, this);
        }
        if (this.isPipeToOutput()) {
            return new PipedFilesBuilder(eventMan, this, this);
        }
        return new UpdateBuilder(eventMan, this.getLocalDirectory());
    }

    public File createTempFile(String filename) throws IOException {
        File temp = File.createTempFile("cvs", ".dff", this.getGlobalOptions().getTempDir());
        return temp;
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("checkout ");
        toReturn.append(this.getCVSArguments());
        if (!this.isShowModules() && !this.isShowModulesWithStatus()) {
            Iterator it = this.modules.iterator();
            while (it.hasNext()) {
                String module = (String)it.next();
                toReturn.append(module);
                toReturn.append(' ');
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'c') {
            this.setShowModules(true);
        } else if (opt == 's') {
            this.setShowModulesWithStatus(true);
        } else if (opt == 'p') {
            this.setPipeToOutput(true);
        } else if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'A') {
            this.setResetStickyOnes(true);
        } else if (opt == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (opt == 'P') {
            this.setPruneDirectories(true);
        } else if (opt == 'D') {
            this.setCheckoutByDate(optArg.trim());
        } else if (opt == 'r') {
            this.setCheckoutByRevision(optArg.trim());
        } else if (opt == 'd') {
            this.setCheckoutDirectory(optArg);
        } else if (opt == 'N') {
            this.setNotShortenPaths(true);
        } else if (opt == 'n') {
            this.setNotRunModuleProgram(true);
        } else if (opt == 'k') {
            KeywordSubstitutionOptions keywordSubst = KeywordSubstitutionOptions.findKeywordSubstOption(optArg);
            this.setKeywordSubst(keywordSubst);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "cnpslNPRAD:r:fk:d:";
    }

    public void resetCVSCommand() {
        this.setShowModules(false);
        this.setShowModulesWithStatus(false);
        this.setPipeToOutput(false);
        this.setRecursive(true);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setCheckoutByDate(null);
        this.setCheckoutByRevision(null);
        this.setKeywordSubst(null);
        this.setPruneDirectories(false);
        this.setNotShortenPaths(false);
        this.setNotRunModuleProgram(false);
        this.setCheckoutDirectory(null);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isShowModules()) {
            toReturn.append("-c ");
        }
        if (this.isShowModulesWithStatus()) {
            toReturn.append("-s ");
        }
        if (this.isPipeToOutput()) {
            toReturn.append("-p ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isResetStickyOnes()) {
            toReturn.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            toReturn.append("-f ");
        }
        if (this.getPruneDirectories()) {
            toReturn.append("-P ");
        }
        if (this.isNotShortenPaths()) {
            toReturn.append("-N ");
        }
        if (this.isNotRunModuleProgram()) {
            toReturn.append("-n ");
        }
        if (this.getKeywordSubst() != null) {
            toReturn.append("-k");
            toReturn.append(this.getKeywordSubst());
            toReturn.append(' ');
        }
        if (this.getCheckoutByRevision() != null && this.getCheckoutByRevision().length() > 0) {
            toReturn.append("-r ");
            toReturn.append(this.getCheckoutByRevision());
            toReturn.append(' ');
        }
        if (this.getCheckoutByDate() != null && this.getCheckoutByDate().length() > 0) {
            toReturn.append("-D ");
            toReturn.append(this.getCheckoutByDate());
            toReturn.append(' ');
        }
        if (this.getCheckoutDirectory() != null) {
            toReturn.append("-d ");
            toReturn.append(this.getCheckoutDirectory());
            toReturn.append(" ");
        }
        return toReturn.toString();
    }

    public void messageSent(MessageEvent e) {
        super.messageSent(e);
        if (this.pruneDirectories && e.getMessage().indexOf(UPDATING) > 0) {
            File file = new File(this.getLocalDirectory(), e.getMessage().substring(e.getMessage().indexOf(UPDATING) + UPDATING.length()));
            this.emptyDirectories.add(file);
        }
    }

    private boolean pruneEmptyDirectory(File directory) throws IOException {
        boolean empty = true;
        File[] contents = directory.listFiles();
        if (contents != null) {
            File entriesFile;
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    empty = false;
                } else if (!contents[i].getName().equals("CVS")) {
                    empty = this.pruneEmptyDirectory(contents[i]);
                }
                if (!empty) break;
            }
            if (empty && (entriesFile = new File(directory, "CVS/Entries")).exists()) {
                File adminDir = new File(directory, "CVS");
                File[] adminFiles = adminDir.listFiles();
                for (int i = 0; i < adminFiles.length; ++i) {
                    adminFiles[i].delete();
                }
                adminDir.delete();
                directory.delete();
            }
        }
        return empty;
    }

    private void pruneEmptyDirectories() throws IOException {
        Iterator it = this.emptyDirectories.iterator();
        while (it.hasNext()) {
            File dir = (File)it.next();
            if (!dir.exists()) continue;
            this.pruneEmptyDirectory(dir);
        }
        this.emptyDirectories.clear();
    }
}

