/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.checkout;

import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.checkout.ModuleListInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class ModuleListBuilder
implements Builder {
    private ModuleListInformation moduleInformation;
    private final EventManager eventManager;
    private final CheckoutCommand checkoutCommand;

    public ModuleListBuilder(EventManager eventMan, CheckoutCommand comm) {
        this.eventManager = eventMan;
        this.checkoutCommand = comm;
    }

    public void outputDone() {
        if (this.moduleInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.moduleInformation));
            this.moduleInformation = null;
        }
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (!(line = line.replace('\t', ' ')).startsWith(" ")) {
            this.processModule(line, true);
        } else {
            this.processModule(line, false);
        }
    }

    protected void processModule(String line, boolean firstLine) {
        StringTokenizer tok = new StringTokenizer(line, " ", false);
        if (firstLine) {
            this.outputDone();
            this.moduleInformation = new ModuleListInformation();
            String modName = tok.nextToken();
            this.moduleInformation.setModuleName(modName);
            if (this.checkoutCommand.isShowModulesWithStatus()) {
                String stat = tok.nextToken();
                this.moduleInformation.setModuleStatus(stat);
            }
        }
        while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            if (nextTok.startsWith("-")) {
                this.moduleInformation.setType(nextTok);
                continue;
            }
            this.moduleInformation.addPath(nextTok);
        }
    }

    public void parseEnhancedMessage(String key, Object value) {
    }
}

