/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.LogBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class LogCommand
extends BasicCommand {
    protected EventManager eventManager;
    private boolean defaultBranch;
    private String dateFilter;
    private boolean headerOnly;
    private boolean noTags;
    private String revisionFilter;
    private String stateFilter;
    private String userFilter;
    private boolean headerAndDescOnly;

    public LogCommand() {
        this.resetCVSCommand();
    }

    public Builder createBuilder(EventManager eventMan) {
        return new LogBuilder(eventMan, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.eventManager = em;
        super.execute(client, em);
        try {
            try {
                if (this.defaultBranch) {
                    this.requests.add(1, new ArgumentRequest("-b"));
                }
                if (this.headerAndDescOnly) {
                    this.requests.add(1, new ArgumentRequest("-t"));
                }
                if (this.headerOnly) {
                    this.requests.add(1, new ArgumentRequest("-h"));
                }
                if (this.noTags) {
                    this.requests.add(1, new ArgumentRequest("-N"));
                }
                if (this.userFilter != null) {
                    this.requests.add(1, new ArgumentRequest("-w" + this.userFilter));
                }
                if (this.revisionFilter != null) {
                    this.requests.add(1, new ArgumentRequest("-r" + this.revisionFilter));
                }
                if (this.stateFilter != null) {
                    this.requests.add(1, new ArgumentRequest("-s" + this.stateFilter));
                }
                if (this.dateFilter != null) {
                    this.requests.add(1, new ArgumentRequest("-d" + this.dateFilter));
                }
                this.addRequestForWorkingDirectory(client);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.LOG);
                client.processRequests(this.requests);
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
            Object var5_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.requests.clear();
            if (this.isBuilderSet()) throw throwable;
            this.builder = null;
            throw throwable;
        }
        if (this.isBuilderSet()) return;
        this.builder = null;
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean isDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(boolean defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public String getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    public boolean isNoTags() {
        return this.noTags;
    }

    public void setNoTags(boolean noTags) {
        this.noTags = noTags;
    }

    public String getRevisionFilter() {
        return this.revisionFilter;
    }

    public void setRevisionFilter(String revisionFilter) {
        this.revisionFilter = revisionFilter;
    }

    public String getStateFilter() {
        return this.stateFilter;
    }

    public void setStateFilter(String stateFilter) {
        this.stateFilter = stateFilter;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public boolean isHeaderAndDescOnly() {
        return this.headerAndDescOnly;
    }

    public void setHeaderAndDescOnly(boolean headerAndDescOnly) {
        this.headerAndDescOnly = headerAndDescOnly;
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("log ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            for (int index = 0; index < files.length; ++index) {
                toReturn.append(files[index].getName());
                toReturn.append(' ');
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'b') {
            this.setDefaultBranch(true);
        } else if (opt == 'h') {
            this.setHeaderOnly(true);
        } else if (opt == 't') {
            this.setHeaderAndDescOnly(true);
        } else if (opt == 'N') {
            this.setNoTags(true);
        } else if (opt == 'd') {
            this.setDateFilter(optArg);
        } else if (opt == 'r') {
            this.setRevisionFilter(optArg == null ? "" : optArg);
        } else if (opt == 's') {
            this.setStateFilter(optArg);
        } else if (opt == 'w') {
            this.setUserFilter(optArg == null ? "" : optArg);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setDefaultBranch(false);
        this.setHeaderOnly(false);
        this.setHeaderAndDescOnly(false);
        this.setNoTags(false);
        this.setDateFilter(null);
        this.setRevisionFilter(null);
        this.setStateFilter(null);
        this.setUserFilter(null);
    }

    public String getOptString() {
        return "RlbhtNd:r:s:w:";
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isDefaultBranch()) {
            toReturn.append("-b ");
        }
        if (this.isHeaderAndDescOnly()) {
            toReturn.append("-t ");
        }
        if (this.isHeaderOnly()) {
            toReturn.append("-h ");
        }
        if (this.isNoTags()) {
            toReturn.append("-N ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.userFilter != null) {
            toReturn.append("-w");
            toReturn.append(this.userFilter);
            toReturn.append(' ');
        }
        if (this.revisionFilter != null) {
            toReturn.append("-r");
            toReturn.append(this.revisionFilter);
            toReturn.append(' ');
        }
        if (this.stateFilter != null) {
            toReturn.append("-s");
            toReturn.append(this.stateFilter);
            toReturn.append(' ');
        }
        if (this.dateFilter != null) {
            toReturn.append("-d");
            toReturn.append(this.dateFilter);
            toReturn.append(' ');
        }
        return toReturn.toString();
    }
}

