/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class UpdateBuilder
implements Builder {
    public static final String UNKNOWN = ": nothing known about";
    public static final String EXAM_DIR = ": Updating";
    public static final String TO_ADD = ": use `cvs add' to create an entry for";
    public static final String STATES = "U P A R M C ? ";
    public static final String WARNING = ": warning: ";
    public static final String SERVER = "server: ";
    public static final String PERTINENT = "is not (any longer) pertinent";
    public static final String MERGING = "Merging differences between ";
    public static final String CONFLICTS = "rcsmerge: warning: conflicts during merge";
    public static final String NOT_IN_REPOSITORY = "is no longer in the repository";
    private DefaultFileInfoContainer fileInfoContainer;
    private EventManager eventManager;
    private String localPath;

    public UpdateBuilder(EventManager eventManager, String localPath) {
        this.eventManager = eventManager;
        this.localPath = localPath;
    }

    public void outputDone() {
        if (this.fileInfoContainer != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.fileInfoContainer));
            this.fileInfoContainer = null;
        }
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (line.indexOf(UNKNOWN) >= 0) {
            this.processUnknownFile(line, line.indexOf(UNKNOWN) + UNKNOWN.length());
        } else if (line.indexOf(TO_ADD) >= 0) {
            this.processUnknownFile(line, line.indexOf(TO_ADD) + TO_ADD.length());
        } else {
            if (line.indexOf(EXAM_DIR) >= 0) {
                return;
            }
            if (line.startsWith(MERGING)) {
                this.outputDone();
                if (this.fileInfoContainer == null) {
                    this.fileInfoContainer = new DefaultFileInfoContainer();
                }
                this.fileInfoContainer.setType("G");
            } else if (line.startsWith(CONFLICTS)) {
                if (this.fileInfoContainer != null) {
                    this.fileInfoContainer.setType("C");
                }
            } else {
                String firstChar;
                if (line.indexOf(WARNING) >= 0) {
                    if (line.indexOf(PERTINENT) > 0) {
                        String filename = line.substring(line.indexOf(WARNING) + WARNING.length(), line.indexOf(PERTINENT)).trim();
                        this.processNotPertinent(filename);
                    }
                    return;
                }
                if (line.indexOf(NOT_IN_REPOSITORY) > 0) {
                    String filename = line.substring(line.indexOf(SERVER) + SERVER.length(), line.indexOf(NOT_IN_REPOSITORY)).trim();
                    this.processNotPertinent(filename);
                    return;
                }
                if (line.length() > 2 && STATES.indexOf(firstChar = line.substring(0, 2)) >= 0) {
                    this.processFile(line);
                    return;
                }
            }
        }
    }

    private File createFile(String fileName) {
        return new File(this.localPath, fileName);
    }

    private void ensureExistingFileInfoContainer() {
        if (this.fileInfoContainer != null) {
            return;
        }
        this.fileInfoContainer = new DefaultFileInfoContainer();
    }

    private void processUnknownFile(String line, int index) {
        this.outputDone();
        this.fileInfoContainer = new DefaultFileInfoContainer();
        this.fileInfoContainer.setType("?");
        String fileName = line.substring(index).trim();
        this.fileInfoContainer.setFile(this.createFile(fileName));
    }

    private void processFile(String line) {
        String fileName = line.substring(2).trim();
        if (fileName.startsWith("no file")) {
            fileName = fileName.substring(8);
        }
        if (fileName.startsWith("./")) {
            fileName = fileName.substring(2);
        }
        File file = this.createFile(fileName);
        if (this.fileInfoContainer != null) {
            if (this.fileInfoContainer.getFile() == null) {
                this.fileInfoContainer.setFile(file);
            }
            if (file.equals(this.fileInfoContainer.getFile())) {
                this.outputDone();
                return;
            }
        }
        this.outputDone();
        this.ensureExistingFileInfoContainer();
        this.fileInfoContainer.setType(line.substring(0, 1));
        this.fileInfoContainer.setFile(file);
    }

    private void processLog(String line) {
        this.ensureExistingFileInfoContainer();
    }

    private void processNotPertinent(String fileName) {
        this.outputDone();
        File fileToDelete = this.createFile(fileName);
        this.ensureExistingFileInfoContainer();
        this.fileInfoContainer.setType("Y");
        this.fileInfoContainer.setFile(fileToDelete);
    }

    public void parseEnhancedMessage(String key, Object value) {
        if (key.equals("Merged_Response_File_Path") && this.fileInfoContainer != null) {
            String path = value.toString();
            File newFile = new File(path);
            this.fileInfoContainer.setFile(newFile);
        }
    }
}

