/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import org.apache.commons.codec.binary.Base64;

public class ModUniqueIdDissector
extends Dissector {
    private static final String INPUT_TYPE = "MOD_UNIQUE_ID";
    private boolean wantTime = false;
    private boolean wantIp = false;
    private boolean wantProcessId = false;
    private boolean wantCounter = false;
    private boolean wantThreadIndex = false;

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TIME.EPOCH:epoch");
        result.add("IP:ip");
        result.add("PROCESSID:processid");
        result.add("COUNTER:counter");
        result.add("THREAD_INDEX:threadindex");
        return result;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name = outputname.substring(inputname.length() + 1);
        if ("epoch".equals(name)) {
            this.wantTime = true;
            return Casts.STRING_OR_LONG;
        }
        if ("ip".equals(name)) {
            this.wantIp = true;
            return Casts.STRING_OR_LONG;
        }
        if ("processid".equals(name)) {
            this.wantProcessId = true;
            return Casts.STRING_OR_LONG;
        }
        if ("counter".equals(name)) {
            this.wantCounter = true;
            return Casts.STRING_OR_LONG;
        }
        if ("threadindex".equals(name)) {
            this.wantThreadIndex = true;
            return Casts.STRING_OR_LONG;
        }
        return null;
    }

    public void prepareForRun() {
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        unique_id_rec record = this.decode(fieldValue);
        if (record == null) {
            return;
        }
        if (this.wantTime) {
            parsable.addDissection(inputname, "TIME.EPOCH", "epoch", Long.toString(record.timestamp));
        }
        if (this.wantIp) {
            parsable.addDissection(inputname, "IP", "ip", record.ipaddrStr);
        }
        if (this.wantProcessId) {
            parsable.addDissection(inputname, "PROCESSID", "processid", Long.toString(record.pid));
        }
        if (this.wantCounter) {
            parsable.addDissection(inputname, "COUNTER", "counter", Long.toString(record.counter));
        }
        if (this.wantThreadIndex) {
            parsable.addDissection(inputname, "THREAD_INDEX", "threadindex", Long.toString(record.thread_index));
        }
    }

    private byte[] decodeToBytes(String modUniqueIdString) {
        if (modUniqueIdString.length() != 24) {
            return null;
        }
        byte[] modUniqueIdBytes = modUniqueIdString.getBytes();
        byte[] modUniqueIdBase64Bytes = new byte[modUniqueIdBytes.length];
        block4: for (int i = 0; i < modUniqueIdBytes.length; ++i) {
            byte nextByte = modUniqueIdBytes[i];
            switch (nextByte) {
                case 43: {
                    modUniqueIdBase64Bytes[i] = 64;
                    continue block4;
                }
                case 47: {
                    modUniqueIdBase64Bytes[i] = 64;
                    continue block4;
                }
                default: {
                    modUniqueIdBase64Bytes[i] = nextByte;
                }
            }
        }
        return Base64.decodeBase64((byte[])modUniqueIdBase64Bytes);
    }

    private unique_id_rec decode(String modUniqueIdString) {
        byte[] bytes = this.decodeToBytes(modUniqueIdString);
        if (bytes == null) {
            return null;
        }
        unique_id_rec result = new unique_id_rec();
        boolean i = false;
        result.timestamp = bytes[0] & 0xFF;
        result.timestamp = result.timestamp * 256L + (long)(bytes[1] & 0xFF);
        result.timestamp = result.timestamp * 256L + (long)(bytes[2] & 0xFF);
        result.timestamp = result.timestamp * 256L + (long)(bytes[3] & 0xFF);
        result.timestamp *= 1000L;
        result.ipaddr = bytes[4] & 0xFF;
        result.ipaddr = result.ipaddr * 256L + (long)(bytes[5] & 0xFF);
        result.ipaddr = result.ipaddr * 256L + (long)(bytes[6] & 0xFF);
        result.ipaddr = result.ipaddr * 256L + (long)(bytes[7] & 0xFF);
        result.ipaddrStr = "" + (bytes[4] & 0xFF) + '.' + (bytes[5] & 0xFF) + '.' + (bytes[6] & 0xFF) + '.' + (bytes[7] & 0xFF);
        result.pid = bytes[8] & 0xFF;
        result.pid = result.pid * 256L + (long)(bytes[9] & 0xFF);
        result.pid = result.pid * 256L + (long)(bytes[10] & 0xFF);
        result.pid = result.pid * 256L + (long)(bytes[11] & 0xFF);
        result.counter = bytes[12] & 0xFF;
        result.counter = result.counter * 256L + (long)(bytes[13] & 0xFF);
        result.thread_index = bytes[14] & 0xFF;
        result.thread_index = result.thread_index * 256L + (long)(bytes[15] & 0xFF);
        result.thread_index = result.thread_index * 256L + (long)(bytes[16] & 0xFF);
        result.thread_index = result.thread_index * 256L + (long)(bytes[17] & 0xFF);
        return result;
    }

    private class unique_id_rec {
        long timestamp;
        long ipaddr;
        String ipaddrStr;
        long pid;
        long counter;
        long thread_index;

        private unique_id_rec() {
        }
    }
}

