/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.stats.FormatCounter;
import net.sourceforge.plantuml.stats.HistoricalData;
import net.sourceforge.plantuml.stats.HtmlConverter;
import net.sourceforge.plantuml.stats.ParsedGenerated;
import net.sourceforge.plantuml.stats.StatsImpl;
import net.sourceforge.plantuml.stats.TextConverter;
import net.sourceforge.plantuml.stats.XmlConverter;
import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.utils.Log;

public class StatsUtils {
    static final Preferences prefs = Preferences.userNodeForPackage(StatsUtils.class);
    static ParsedGenerated fullEver;
    static ConcurrentMap<String, ParsedGenerated> byTypeEver;
    static ConcurrentMap<String, ParsedGenerated> byTypeCurrent;
    static FormatCounter formatCounterCurrent;
    static FormatCounter formatCounterEver;
    static HistoricalData historicalData;
    static boolean xmlStats;
    static boolean htmlStats;
    static boolean realTimeStats;
    private static final int VERSION = 14;

    public static Stats getStats() {
        return new StatsImpl(byTypeEver, byTypeCurrent, formatCounterCurrent, formatCounterEver, historicalData, fullEver);
    }

    private static void restoreNow() {
        try {
            prefs.sync();
            fullEver = ParsedGenerated.loadDated(prefs, "full");
            historicalData = new HistoricalData(prefs);
            StatsUtils.reload();
            formatCounterEver.reload("format.", prefs);
        }
        catch (BackingStoreException e) {
            Log.error("Error reloading stats " + e);
            byTypeEver.clear();
        }
    }

    private static void reload() throws BackingStoreException {
        for (String key : prefs.keys()) {
            String name;
            ParsedGenerated p;
            if (!key.startsWith("type.") || !key.endsWith(".p.saved") || (p = ParsedGenerated.loadDated(prefs, name = StatsUtils.removeDotPSaved(key))) == null) continue;
            byTypeEver.put(name.substring("type.".length()), p);
        }
    }

    static String removeDotPSaved(String key) {
        return key.substring(0, key.length() - ".p.saved".length());
    }

    private static void endingHook() {
        try {
            Stats stats = StatsUtils.getStatsLazzy();
            if (xmlStats) {
                StatsUtils.xmlOutput(stats);
            }
            if (htmlStats) {
                StatsUtils.htmlOutput(stats);
            }
        }
        catch (Exception e) {
            Logme.error(e);
        }
    }

    static Stats getStatsLazzy() {
        if (xmlStats || htmlStats) {
            return StatsUtils.getStats();
        }
        return null;
    }

    static void htmlOutput(Stats stats) throws FileNotFoundException {
        try (PrintWriter pw = SecurityUtils.createPrintWriter("plantuml-stats.html");){
            pw.print(new HtmlConverter(stats).toHtml());
        }
    }

    static void xmlOutput(Stats stats) throws TransformerException, ParserConfigurationException, IOException {
        try (FileOutputStream os = SecurityUtils.createFileOutputStream("plantuml-stats.xml");){
            new XmlConverter(stats).createXml(os);
        }
    }

    public static void setXmlStats(boolean value) {
        xmlStats = value;
    }

    public static void setHtmlStats(boolean value) {
        htmlStats = value;
    }

    public static void setRealTimeStats(boolean value) {
        realTimeStats = value;
    }

    public static void outHtml() throws FileNotFoundException {
        StatsUtils.htmlOutput(StatsUtils.getStats());
    }

    public static void dumpStats() {
        new TextConverter(StatsUtils.getStats()).printMe(System.out);
    }

    public static void loopStats() throws InterruptedException {
        int linesUsed = 0;
        while (true) {
            StatsUtils.restoreNow();
            StatsUtils.clearScreen(System.out, linesUsed);
            TextConverter textConverter = new TextConverter(StatsUtils.getStats());
            textConverter.printMe(System.out);
            linesUsed = textConverter.getLinesUsed();
            Thread.sleep(3000L);
        }
    }

    private static void clearScreen(PrintStream ps, int linesUsed) {
        if (linesUsed == 0) {
            return;
        }
        if (SFile.separatorChar == '/') {
            System.out.println(String.format("\u001b[%dA", linesUsed + 1));
        } else {
            for (int i = 0; i < 20; ++i) {
                ps.println();
            }
        }
    }

    static {
        byTypeEver = new ConcurrentHashMap<String, ParsedGenerated>();
        byTypeCurrent = new ConcurrentHashMap<String, ParsedGenerated>();
        formatCounterCurrent = new FormatCounter("currentformat.");
        formatCounterEver = new FormatCounter("format.");
        xmlStats = false;
        htmlStats = false;
        realTimeStats = false;
        try {
            Logger.getLogger("java.util.prefs").setFilter(new Filter(){

                @Override
                public boolean isLoggable(LogRecord record) {
                    String message = record.getMessage();
                    System.err.println("SPECIAL TRACE FOR PLANTUML: " + message);
                    return false;
                }
            });
        }
        catch (Exception e) {
            Logme.error(e);
        }
        if (prefs.getInt("VERSION", 0) != 14) {
            try {
                prefs.clear();
            }
            catch (BackingStoreException e1) {
                Logme.error(e1);
            }
            prefs.putInt("VERSION", 14);
        }
        StatsUtils.restoreNow();
        if (historicalData != null) {
            historicalData.reset();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StatsUtils.endingHook();
            }
        });
    }
}

