/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jms;

import java.util.Hashtable;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;

import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestSetup;
import org.objectweb.jtests.jms.conform.connection.ConnectionTest;
import org.objectweb.jtests.jms.conform.connection.TopicConnectionTest;
import org.objectweb.jtests.jms.conform.message.MessageBodyTest;
import org.objectweb.jtests.jms.conform.message.MessageDefaultTest;
import org.objectweb.jtests.jms.conform.message.MessageTypeTest;
import org.objectweb.jtests.jms.conform.message.headers.MessageHeaderTest;
import org.objectweb.jtests.jms.conform.message.properties.JMSXPropertyTest;
import org.objectweb.jtests.jms.conform.message.properties.MessagePropertyConversionTest;
import org.objectweb.jtests.jms.conform.message.properties.MessagePropertyTest;
import org.objectweb.jtests.jms.conform.queue.QueueBrowserTest;
import org.objectweb.jtests.jms.conform.queue.TemporaryQueueTest;
import org.objectweb.jtests.jms.conform.selector.SelectorSyntaxTest;
import org.objectweb.jtests.jms.conform.selector.SelectorTest;
import org.objectweb.jtests.jms.conform.session.QueueSessionTest;
import org.objectweb.jtests.jms.conform.session.SessionTest;
import org.objectweb.jtests.jms.conform.session.TopicSessionTest;
import org.objectweb.jtests.jms.conform.session.UnifiedSessionTest;
import org.objectweb.jtests.jms.conform.topic.TemporaryTopicTest;

/**
 * JoramUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.2 $
 */
public class JoramUnitTestCase extends AbstractTestCaseWithSetup
{
   public JoramUnitTestCase(String name)
   {
      super(name);
   }

   
   
   /** Used to similuate tests while renaming its names. */
   private static class DummyTestCase extends TestCase
   {
       DummyTestCase(String name)
       {
           super (name);
       }
   }
   
   public static JoramTestDelegate getDelegate(Class clazz, String adminName) throws Exception
   {
      return new JoramTestDelegate(clazz, adminName);
   }
   

   /**
    * One of the goals of this class also is to keep original classNames into testNames. So, you will realize several proxies existent here to
    * keep these class names while executing method names.
    */
   static class TestProxy extends TestCase
   {
       Hashtable hashTests = new Hashtable();



       public TestProxy(Test testcase, String name)
       {
           super(name);
           this.testcase = testcase;
       }

       public int countTestCases()
       {
           return testcase.countTestCases();
       }

       /**
        * Create a dummy test renaming its content
        * @param test
        * @return
        */
       private Test createDummyTest(Test test)
       {
           Test dummyTest = (Test)hashTests.get(test);
           if (dummyTest==null)
           {
               if (test instanceof TestCase)
               {
                   dummyTest = new DummyTestCase(this.getName() + ":"+ ((TestCase)test).getName());
               } else
               if (test instanceof TestSuite)
               {
                   dummyTest = new DummyTestCase(this.getName() + ":"+ ((TestCase)test).getName());
               }
               else
               {
                   dummyTest = new DummyTestCase(test.getClass().getName());
               }

               hashTests.put(test,dummyTest);
           }

           return dummyTest;
       }

       public void run(final TestResult result)
       {
           TestResult subResult = new TestResult();
           subResult.addListener(new TestListener()
           {
               public void addError(Test subtest, Throwable throwable)
               {
                   Test dummyTest = createDummyTest(subtest);
                   result.addError(dummyTest, throwable);
               }

               public void addFailure(Test subtest, AssertionFailedError assertionFailedError)
               {
                   Test dummyTest = createDummyTest(subtest);
                   result.addFailure(dummyTest, assertionFailedError);
               }

               public void endTest(Test subtest)
               {
                   Test dummyTest = createDummyTest(subtest);
                   result.endTest(dummyTest);
               }

               public void startTest(Test subtest)
               {
                   Test dummyTest = createDummyTest(subtest);
                   result.startTest(dummyTest);
               }
           });
           testcase.run(subResult);
       }

       Test testcase;
   }

   

   

   public static junit.framework.Test getTestSuite(Class clazz) throws Exception
   {
      TestSuite suite = new TestSuite();

      suite.addTest(new TestProxy(TopicConnectionTest.suite(),TopicConnectionTest.class.getName()));
      suite.addTest(new TestProxy(ConnectionTest.suite(), ConnectionTest.class.getName()));
      suite.addTest(new TestProxy(MessageBodyTest.suite(), MessageBodyTest.class.getName()));
      suite.addTest(new TestProxy(MessageDefaultTest.suite(), MessageDefaultTest.class.getName()));
      suite.addTest(new TestProxy(MessageTypeTest.suite(), MessageTypeTest.class.getName()));
      suite.addTest(new TestProxy(MessageHeaderTest.suite(), MessageHeaderTest.class.getName()));
      suite.addTest(new TestProxy(JMSXPropertyTest.suite(), JMSXPropertyTest.class.getName()));
      suite.addTest(new TestProxy(MessagePropertyConversionTest.suite(), MessagePropertyConversionTest.class.getName()));
      suite.addTest(new TestProxy(MessagePropertyTest.suite(), MessagePropertyTest.class.getName()));
      suite.addTest(new TestProxy(QueueBrowserTest.suite(), QueueBrowserTest.class.getName()));
      suite.addTest(new TestProxy(TemporaryQueueTest.suite(), TemporaryQueueTest.class.getName()));
      suite.addTest(new TestProxy(SelectorSyntaxTest.suite(), SelectorSyntaxTest.class.getName()));
      suite.addTest(new TestProxy(SelectorTest.suite(), SelectorTest.class.getName()));
      suite.addTest(new TestProxy(QueueSessionTest.suite(), QueueSessionTest.class.getName()));
      suite.addTest(new TestProxy(SessionTest.suite(), SessionTest.class.getName()));
      suite.addTest(new TestProxy(TopicSessionTest.suite(), TopicSessionTest.class.getName()));
      suite.addTest(new TestProxy(UnifiedSessionTest.suite(), UnifiedSessionTest.class.getName()));
      suite.addTest(new TestProxy(TemporaryTopicTest.suite(), TemporaryTopicTest.class.getName()));
      

      return new AbstractTestSetup(clazz, suite);
   }
}
