/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLBuilder {
    private String scheme;
    private String username;
    private String password;
    private String host;
    private int port;
    private String path;
    private List<Pair<String, String>> queryParams;
    private String fragement;

    public URLBuilder() {
        this.queryParams = new ArrayList<Pair<String, String>>();
    }

    public URLBuilder(String baseURL) {
        try {
            URL url = new URL(baseURL);
            this.setScheme(url.getProtocol());
            String userInfo = url.getUserInfo();
            if (!DatatypeHelper.isEmpty((String)userInfo)) {
                if (userInfo.contains(":")) {
                    String[] userInfoComps = userInfo.split(":");
                    this.setUsername(URLDecoder.decode(userInfoComps[0], "UTF-8"));
                    this.setPassword(URLDecoder.decode(userInfoComps[1], "UTF-8"));
                } else {
                    this.setUsername(userInfo);
                }
            }
            this.setHost(url.getHost());
            this.setPort(url.getPort());
            this.setPath(url.getPath());
            this.queryParams = new ArrayList<Pair<String, String>>();
            String queryString = url.getQuery();
            if (!DatatypeHelper.isEmpty((String)queryString)) {
                String[] queryComps = queryString.split("&");
                int i = 0;
                while (i < queryComps.length) {
                    String paramName;
                    String queryComp = queryComps[i];
                    if (!queryComp.contains("=")) {
                        paramName = URLDecoder.decode(queryComp, "UTF-8");
                        this.queryParams.add((Pair<String, String>)new Pair((Object)paramName, null));
                    } else {
                        String[] paramComps = queryComp.split("=");
                        paramName = URLDecoder.decode(paramComps[0], "UTF-8");
                        String paramValue = URLDecoder.decode(paramComps[1], "UTF-8");
                        this.queryParams.add((Pair<String, String>)new Pair((Object)paramName, (Object)paramValue));
                    }
                    ++i;
                }
            }
            this.setFragment(url.getRef());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Given URL is not well formed", e);
        }
    }

    public String getFragment() {
        return this.fragement;
    }

    public void setFragment(String newFragment) {
        this.fragement = DatatypeHelper.safeTrimOrNullString((String)newFragment);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newHost) {
        this.host = DatatypeHelper.safeTrimOrNullString((String)newHost);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = DatatypeHelper.safeTrimOrNullString((String)newPassword);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newPath) {
        this.path = DatatypeHelper.safeTrimOrNullString((String)newPath);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    public List<Pair<String, String>> getQueryParams() {
        return this.queryParams;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String newScheme) {
        this.scheme = DatatypeHelper.safeTrimOrNullString((String)newScheme);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String newUsername) {
        this.username = DatatypeHelper.safeTrimOrNullString((String)newUsername);
    }

    public String buildURL() {
        String queryString;
        StringBuilder builder = new StringBuilder();
        if (!DatatypeHelper.isEmpty((String)this.scheme)) {
            builder.append(this.scheme);
            builder.append("://");
        }
        if (!DatatypeHelper.isEmpty((String)this.username)) {
            builder.append(this.username);
            if (!DatatypeHelper.isEmpty((String)this.password)) {
                builder.append(":");
                builder.append(this.password);
            }
            builder.append("@");
        }
        if (!DatatypeHelper.isEmpty((String)this.host)) {
            builder.append(this.host);
            if (this.port > 0) {
                builder.append(":");
                builder.append(Integer.toString(this.port));
            }
        }
        if (!DatatypeHelper.isEmpty((String)this.path)) {
            if (!this.path.startsWith("/")) {
                builder.append("/");
            }
            builder.append(this.path);
        }
        if (!DatatypeHelper.isEmpty((String)(queryString = this.buildQueryString()))) {
            builder.append("?");
            builder.append(queryString);
        }
        if (!DatatypeHelper.isEmpty((String)this.fragement)) {
            builder.append("#");
            builder.append(this.fragement);
        }
        return builder.toString();
    }

    public String buildQueryString() {
        StringBuilder builder = new StringBuilder();
        try {
            if (this.queryParams.size() > 0) {
                int i = 0;
                while (i < this.queryParams.size()) {
                    Pair<String, String> param = this.queryParams.get(i);
                    String name = DatatypeHelper.safeTrimOrNullString((String)((String)param.getFirst()));
                    if (name != null) {
                        builder.append(URLEncoder.encode(name, "UTF-8"));
                        String value = DatatypeHelper.safeTrimOrNullString((String)((String)param.getSecond()));
                        if (value != null) {
                            builder.append("=");
                            builder.append(URLEncoder.encode(value, "UTF-8"));
                        }
                        if (i < this.queryParams.size() - 1) {
                            builder.append("&");
                        }
                    }
                    ++i;
                }
                return builder.toString();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }
}

