/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.provider.BaseTrustEngineRule;
import org.opensaml.ws.security.provider.CertificateNameOptions;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCertAuthRule
extends BaseTrustEngineRule<X509Credential> {
    private final Logger log = LoggerFactory.getLogger(ClientCertAuthRule.class);
    private CertificateNameOptions certNameOptions;

    public ClientCertAuthRule(TrustEngine<X509Credential> engine, CertificateNameOptions nameOptions) {
        super(engine);
        this.certNameOptions = nameOptions;
    }

    @Override
    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        Credential peerCredential = messageContext.getInboundMessageTransport().getPeerCredential();
        if (peerCredential == null) {
            this.log.info("Inbound message transport did not contain a peer credential, skipping client certificate authentication");
            return;
        }
        if (!(peerCredential instanceof X509Credential)) {
            this.log.info("Inbound message transport did not contain an X509Credential, skipping client certificate authentication");
            return;
        }
        X509Credential requestCredential = (X509Credential)peerCredential;
        this.doEvaluate(requestCredential, messageContext);
    }

    protected CertificateNameOptions getCertificateNameOptions() {
        return this.certNameOptions;
    }

    protected void doEvaluate(X509Credential requestCredential, MessageContext messageContext) throws SecurityPolicyException {
        String contextIssuer = messageContext.getInboundMessageIssuer();
        if (contextIssuer != null) {
            this.log.debug("Attempting client certificate authentication using context issuer: {}", (Object)contextIssuer);
            if (!this.evaluate(requestCredential, contextIssuer, messageContext)) {
                this.log.error("Authentication via client certificate failed for context issuer entity ID {}", (Object)contextIssuer);
                throw new SecurityPolicyException("Client certificate authentication failed for context issuer entity ID");
            }
            this.log.info("Authentication via client certificate succeeded for context issuer entity ID: {}", (Object)contextIssuer);
            messageContext.getInboundMessageTransport().setAuthenticated(true);
            return;
        }
        String derivedIssuer = this.evaluateCertificateNameDerivedIssuers(requestCredential, messageContext);
        if (derivedIssuer != null) {
            this.log.info("Authentication via client certificate succeeded for certificate-derived issuer entity ID {}", (Object)derivedIssuer);
            messageContext.setInboundMessageIssuer(derivedIssuer);
            messageContext.getInboundMessageTransport().setAuthenticated(true);
            return;
        }
        derivedIssuer = this.evaluateDerivedIssuers(requestCredential, messageContext);
        if (derivedIssuer != null) {
            this.log.info("Authentication via client certificate succeeded for derived issuer entity ID {}", (Object)derivedIssuer);
            messageContext.setInboundMessageIssuer(derivedIssuer);
            messageContext.getInboundMessageTransport().setAuthenticated(true);
            return;
        }
    }

    @Override
    protected CriteriaSet buildCriteriaSet(String entityID, MessageContext messageContext) throws SecurityPolicyException {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!DatatypeHelper.isEmpty((String)entityID)) {
            criteriaSet.add((Object)new EntityIDCriteria(entityID));
        }
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        return criteriaSet;
    }

    protected String evaluateDerivedIssuers(X509Credential requestCredential, MessageContext messageContext) throws SecurityPolicyException {
        return null;
    }

    protected String evaluateCertificateNameDerivedIssuers(X509Credential requestCredential, MessageContext messageContext) throws SecurityPolicyException {
        String candidateIssuer = null;
        if (this.certNameOptions.evaluateSubjectDN() && (candidateIssuer = this.evaluateSubjectDN(requestCredential, messageContext)) != null) {
            return candidateIssuer;
        }
        if (!this.certNameOptions.getSubjectAltNames().isEmpty() && (candidateIssuer = this.evaluateSubjectAltNames(requestCredential, messageContext)) != null) {
            return candidateIssuer;
        }
        if (this.certNameOptions.evaluateSubjectCommonName() && (candidateIssuer = this.evaluateSubjectCommonName(requestCredential, messageContext)) != null) {
            return candidateIssuer;
        }
        return null;
    }

    protected String evaluateSubjectCommonName(X509Credential requestCredential, MessageContext messageContext) throws SecurityPolicyException {
        this.log.debug("Evaluating client cert by deriving issuer as cert CN");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        String candidateIssuer = this.getCommonName(certificate);
        if (candidateIssuer != null && this.evaluate(requestCredential, candidateIssuer, messageContext)) {
            this.log.info("Authentication succeeded for issuer derived from CN {}", (Object)candidateIssuer);
            return candidateIssuer;
        }
        return null;
    }

    protected String evaluateSubjectDN(X509Credential requestCredential, MessageContext messageContext) throws SecurityPolicyException {
        this.log.debug("Evaluating client cert by deriving issuer as cert subject DN");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        String candidateIssuer = this.getSubjectName(certificate);
        if (candidateIssuer != null && this.evaluate(requestCredential, candidateIssuer, messageContext)) {
            this.log.info("Authentication succeeded for issuer derived from subject DN {}", (Object)candidateIssuer);
            return candidateIssuer;
        }
        return null;
    }

    protected String evaluateSubjectAltNames(X509Credential requestCredential, MessageContext messageContext) throws SecurityPolicyException {
        this.log.debug("Evaluating client cert by deriving issuer from subject alt names");
        X509Certificate certificate = requestCredential.getEntityCertificate();
        for (Integer altNameType : this.certNameOptions.getSubjectAltNames()) {
            this.log.debug("Evaluating alt names of type: {}", (Object)altNameType.toString());
            List<String> altNames = this.getAltNames(certificate, altNameType);
            for (String altName : altNames) {
                if (!this.evaluate(requestCredential, altName, messageContext)) continue;
                this.log.info("Authentication succeeded for issuer derived from subject alt name {}", (Object)altName);
                return altName;
            }
        }
        return null;
    }

    protected String getCommonName(X509Certificate cert) {
        List names = X509Util.getCommonNames((X500Principal)cert.getSubjectX500Principal());
        if (names != null && !names.isEmpty()) {
            String name = (String)names.get(0);
            this.log.debug("Extracted common name from certificate: {}", (Object)name);
            return name;
        }
        return null;
    }

    protected String getSubjectName(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        String name = null;
        name = !DatatypeHelper.isEmpty((String)this.certNameOptions.getX500SubjectDNFormat()) ? this.certNameOptions.getX500DNHandler().getName(cert.getSubjectX500Principal(), this.certNameOptions.getX500SubjectDNFormat()) : this.certNameOptions.getX500DNHandler().getName(cert.getSubjectX500Principal());
        this.log.debug("Extracted subject name from certificate: {}", (Object)name);
        return name;
    }

    protected List<String> getAltNames(X509Certificate cert, Integer altNameType) {
        this.log.debug("Extracting alt names from certificate of type: {}", (Object)altNameType.toString());
        Integer[] nameTypes = new Integer[]{altNameType};
        List altNames = X509Util.getAltNames((X509Certificate)cert, (Integer[])nameTypes);
        ArrayList<String> names = new ArrayList<String>();
        for (Object altNameValue : altNames) {
            if (!(altNameValue instanceof String)) {
                this.log.debug("Skipping non-String certificate alt name value");
                continue;
            }
            names.add((String)altNameValue);
        }
        this.log.debug("Extracted alt names from certificate: {}", (Object)((Object)names).toString());
        return names;
    }
}

