/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.mapper;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.module.sitemesh.mapper.PathMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ConfigLoader {
    private Map decorators = null;
    private long configLastModified;
    private File configFile = null;
    private String configFileName = null;
    private PathMapper pathMapper = null;
    private Config config = null;

    public ConfigLoader(File configFile) throws ServletException {
        this.configFile = configFile;
        this.configFileName = configFile.getName();
        this.loadConfig();
    }

    public ConfigLoader(String configFileName, Config config) throws ServletException {
        this.config = config;
        this.configFileName = configFileName;
        if (config.getServletContext().getRealPath(configFileName) != null) {
            this.configFile = new File(config.getServletContext().getRealPath(configFileName));
        }
        this.loadConfig();
    }

    public Decorator getDecoratorByName(String name) throws ServletException {
        this.refresh();
        return (Decorator)this.decorators.get(name);
    }

    public String getMappedName(String path) throws ServletException {
        this.refresh();
        return this.pathMapper.get(path);
    }

    private synchronized void loadConfig() throws ServletException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = null;
            if (this.configFile != null && this.configFile.canRead()) {
                this.configLastModified = this.configFile.lastModified();
                document = builder.parse(this.configFile);
            } else {
                document = builder.parse(this.config.getServletContext().getResourceAsStream(this.configFileName));
            }
            this.parseConfig(document);
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("Could not get XML parser", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException("Could not read the config file: " + this.configFileName, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ServletException("Could not parse the config file: " + this.configFileName, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServletException("Could not find the config file: " + this.configFileName, (Throwable)e);
        }
    }

    private synchronized void parseConfig(Document document) {
        Element root = document.getDocumentElement();
        String defaultDir = ConfigLoader.getAttribute(root, "defaultdir");
        if (defaultDir == null) {
            defaultDir = ConfigLoader.getAttribute(root, "defaultDir");
        }
        this.pathMapper = new PathMapper();
        this.decorators = new HashMap();
        NodeList decoratorNodes = root.getElementsByTagName("decorator");
        Element decoratorElement = null;
        for (int i = 0; i < decoratorNodes.getLength(); ++i) {
            String name = null;
            String page = null;
            String uriPath = null;
            String role = null;
            decoratorElement = (Element)decoratorNodes.item(i);
            if (ConfigLoader.getAttribute(decoratorElement, "name") != null) {
                name = ConfigLoader.getAttribute(decoratorElement, "name");
                page = ConfigLoader.getAttribute(decoratorElement, "page");
                uriPath = ConfigLoader.getAttribute(decoratorElement, "webapp");
                role = ConfigLoader.getAttribute(decoratorElement, "role");
                if (defaultDir != null && page != null && page.length() > 0 && !page.startsWith("/")) {
                    page = page.charAt(0) == '/' ? defaultDir + page : defaultDir + '/' + page;
                }
                if (uriPath != null && uriPath.length() > 0 && uriPath.charAt(0) != '/') {
                    uriPath = '/' + uriPath;
                }
                this.populatePathMapper(decoratorElement.getElementsByTagName("pattern"), role, name);
                this.populatePathMapper(decoratorElement.getElementsByTagName("url-pattern"), role, name);
            } else {
                name = ConfigLoader.getContainedText(decoratorNodes.item(i), "decorator-name");
                page = ConfigLoader.getContainedText(decoratorNodes.item(i), "resource");
                if (page == null) {
                    page = ConfigLoader.getContainedText(decoratorNodes.item(i), "jsp-file");
                }
            }
            HashMap<String, String> params = new HashMap<String, String>();
            NodeList paramNodes = decoratorElement.getElementsByTagName("init-param");
            for (int ii = 0; ii < paramNodes.getLength(); ++ii) {
                String paramName = ConfigLoader.getContainedText(paramNodes.item(ii), "param-name");
                String paramValue = ConfigLoader.getContainedText(paramNodes.item(ii), "param-value");
                params.put(paramName, paramValue);
            }
            this.storeDecorator(new DefaultDecorator(name, page, uriPath, role, params));
        }
        NodeList mappingNodes = root.getElementsByTagName("decorator-mapping");
        for (int i = 0; i < mappingNodes.getLength(); ++i) {
            Element n = (Element)mappingNodes.item(i);
            String name = ConfigLoader.getContainedText(mappingNodes.item(i), "decorator-name");
            this.populatePathMapper(n.getElementsByTagName("url-pattern"), null, name);
        }
    }

    private void populatePathMapper(NodeList patternNodes, String role, String name) {
        for (int j = 0; j < patternNodes.getLength(); ++j) {
            String pattern;
            Element p = (Element)patternNodes.item(j);
            Text patternText = (Text)p.getFirstChild();
            if (patternText == null || (pattern = patternText.getData().trim()) == null) continue;
            if (role != null) {
                this.pathMapper.put(name + role, pattern);
                continue;
            }
            this.pathMapper.put(name, pattern);
        }
    }

    private static String getAttribute(Element element, String name) {
        if (element != null && element.getAttribute(name) != null && element.getAttribute(name).trim() != "") {
            return element.getAttribute(name).trim();
        }
        return null;
    }

    private static String getContainedText(Node parent, String childTagName) {
        try {
            Node tag = ((Element)parent).getElementsByTagName(childTagName).item(0);
            String text = ((Text)tag.getFirstChild()).getData();
            return text;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void storeDecorator(Decorator d) {
        if (d.getRole() != null) {
            this.decorators.put(d.getName() + d.getRole(), d);
        } else {
            this.decorators.put(d.getName(), d);
        }
    }

    private synchronized void refresh() throws ServletException {
        if (this.configFile != null && this.configLastModified != this.configFile.lastModified()) {
            this.loadConfig();
        }
    }
}

