/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.rememberme;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.acegisecurity.ui.rememberme.NullRememberMeServices;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public class RememberMeProcessingFilter
implements Filter,
InitializingBean,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilter == null ? (class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilter = RememberMeProcessingFilter.class$("org.acegisecurity.ui.rememberme.RememberMeProcessingFilter")) : class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilter));
    private ApplicationEventPublisher eventPublisher;
    private AuthenticationManager authenticationManager;
    private RememberMeServices rememberMeServices = new NullRememberMeServices();
    static /* synthetic */ Class class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
        Assert.notNull((Object)this.rememberMeServices);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            Authentication rememberMeAuth = this.rememberMeServices.autoLogin(httpRequest, httpResponse);
            if (rememberMeAuth != null) {
                try {
                    rememberMeAuth = this.authenticationManager.authenticate(rememberMeAuth);
                    SecurityContextHolder.getContext().setAuthentication(rememberMeAuth);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SecurityContextHolder populated with remember-me token: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
                    }
                    if (this.eventPublisher != null) {
                        this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(SecurityContextHolder.getContext().getAuthentication(), this.getClass()));
                    }
                }
                catch (AuthenticationException authenticationException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SecurityContextHolder not populated with remember-me token, as AuthenticationManager rejected Authentication returned by RememberMeServices: '" + rememberMeAuth + "'; invalidating remember-me token"), (Throwable)((Object)authenticationException));
                    }
                    this.rememberMeServices.loginFail(httpRequest, httpResponse);
                }
            }
            chain.doFilter(request, response);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SecurityContextHolder not populated with remember-me token, as it already contained: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
            }
            chain.doFilter(request, response);
        }
    }

    public RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

