/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.wrapper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.ui.savedrequest.Enumerator;
import org.acegisecurity.ui.savedrequest.FastHttpDateFormat;
import org.acegisecurity.ui.savedrequest.SavedRequest;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.wrapper.SecurityContextHolderAwareRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SavedRequestAwareWrapper
extends SecurityContextHolderAwareRequestWrapper {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$wrapper$SavedRequestAwareWrapper == null ? (class$org$acegisecurity$wrapper$SavedRequestAwareWrapper = SavedRequestAwareWrapper.class$("org.acegisecurity.wrapper.SavedRequestAwareWrapper")) : class$org$acegisecurity$wrapper$SavedRequestAwareWrapper));
    protected static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    protected static Locale defaultLocale = Locale.getDefault();
    protected SavedRequest savedRequest = null;
    protected SimpleDateFormat[] formats = new SimpleDateFormat[3];
    static /* synthetic */ Class class$org$acegisecurity$wrapper$SavedRequestAwareWrapper;

    public SavedRequestAwareWrapper(HttpServletRequest request, PortResolver portResolver) {
        super(request, portResolver);
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Wrapper not replaced; no session available for SavedRequest extraction");
            }
            return;
        }
        SavedRequest saved = (SavedRequest)session.getAttribute("ACEGI_SAVED_REQUEST_KEY");
        if (saved != null && saved.doesRequestMatch(request, portResolver)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Wrapper replaced; SavedRequest was: " + saved));
            }
            this.savedRequest = saved;
            session.removeAttribute("ACEGI_SAVED_REQUEST_KEY");
            this.formats[0] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.formats[1] = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            this.formats[2] = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
            this.formats[0].setTimeZone(GMT_ZONE);
            this.formats[1].setTimeZone(GMT_ZONE);
            this.formats[2].setTimeZone(GMT_ZONE);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Wrapper not replaced; SavedRequest was: " + saved));
        }
    }

    public Cookie[] getCookies() {
        if (this.savedRequest == null) {
            return super.getCookies();
        }
        List cookies = this.savedRequest.getCookies();
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public long getDateHeader(String name) {
        if (this.savedRequest == null) {
            return super.getDateHeader(name);
        }
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        if (this.savedRequest == null) {
            return super.getHeader(name);
        }
        String header = null;
        Iterator iterator = this.savedRequest.getHeaderValues(name);
        if (iterator.hasNext()) {
            header = (String)iterator.next();
        }
        return header;
    }

    public Enumeration getHeaderNames() {
        if (this.savedRequest == null) {
            return super.getHeaderNames();
        }
        return new Enumerator(this.savedRequest.getHeaderNames());
    }

    public Enumeration getHeaders(String name) {
        if (this.savedRequest == null) {
            return super.getHeaders(name);
        }
        return new Enumerator(this.savedRequest.getHeaderValues(name));
    }

    public int getIntHeader(String name) {
        if (this.savedRequest == null) {
            return super.getIntHeader(name);
        }
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public Locale getLocale() {
        if (this.savedRequest == null) {
            return super.getLocale();
        }
        Locale locale = null;
        Iterator iterator = this.savedRequest.getLocales();
        if (iterator.hasNext()) {
            locale = (Locale)iterator.next();
        }
        if (locale == null) {
            return defaultLocale;
        }
        return locale;
    }

    public Enumeration getLocales() {
        if (this.savedRequest == null) {
            return super.getLocales();
        }
        Iterator iterator = this.savedRequest.getLocales();
        if (iterator.hasNext()) {
            return new Enumerator(iterator);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator(results.iterator());
    }

    public String getMethod() {
        if (this.savedRequest == null) {
            return super.getMethod();
        }
        return this.savedRequest.getMethod();
    }

    public String getParameter(String name) {
        String value = null;
        String[] values = null;
        values = this.savedRequest == null ? super.getParameterValues(name) : this.savedRequest.getParameterValues(name);
        if (values == null) {
            return null;
        }
        int i = 0;
        if (i < values.length) {
            value = values[i];
        }
        return value;
    }

    public Map getParameterMap() {
        if (this.savedRequest == null) {
            return super.getParameterMap();
        }
        return this.savedRequest.getParameterMap();
    }

    public Enumeration getParameterNames() {
        if (this.savedRequest == null) {
            return super.getParameterNames();
        }
        return new Enumerator(this.savedRequest.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        if (this.savedRequest == null) {
            return super.getParameterValues(name);
        }
        return this.savedRequest.getParameterValues(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

