/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.ValuedDataObject;
import org.apache.commons.lang3.StringUtils;

public class SubProcess
extends Activity
implements FlowElementsContainer {
    protected List<FlowElement> flowElementList = new ArrayList<FlowElement>();
    protected List<Artifact> artifactList = new ArrayList<Artifact>();
    protected List<ValuedDataObject> dataObjects = new ArrayList<ValuedDataObject>();

    @Override
    public FlowElement getFlowElement(String id) {
        FlowElement foundElement = null;
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            for (FlowElement element : this.flowElementList) {
                if (!id.equals(element.getId())) continue;
                foundElement = element;
                break;
            }
        }
        return foundElement;
    }

    @Override
    public Collection<FlowElement> getFlowElements() {
        return this.flowElementList;
    }

    @Override
    public void addFlowElement(FlowElement element) {
        this.flowElementList.add(element);
    }

    @Override
    public void removeFlowElement(String elementId) {
        FlowElement element = this.getFlowElement(elementId);
        if (element != null) {
            this.flowElementList.remove(element);
        }
    }

    @Override
    public Artifact getArtifact(String id) {
        Artifact foundArtifact = null;
        for (Artifact artifact : this.artifactList) {
            if (!id.equals(artifact.getId())) continue;
            foundArtifact = artifact;
            break;
        }
        return foundArtifact;
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        return this.artifactList;
    }

    @Override
    public void addArtifact(Artifact artifact) {
        this.artifactList.add(artifact);
    }

    @Override
    public void removeArtifact(String artifactId) {
        Artifact artifact = this.getArtifact(artifactId);
        if (artifact != null) {
            this.artifactList.remove(artifact);
        }
    }

    @Override
    public SubProcess clone() {
        SubProcess clone = new SubProcess();
        clone.setValues(this);
        return clone;
    }

    public void setValues(SubProcess otherElement) {
        super.setValues(otherElement);
        for (ValuedDataObject thisObject : this.getDataObjects()) {
            boolean exists = false;
            for (ValuedDataObject otherObject : otherElement.getDataObjects()) {
                if (!thisObject.getId().equals(otherObject.getId())) continue;
                exists = true;
            }
            if (exists) continue;
            this.removeFlowElement(thisObject.getId());
        }
        this.dataObjects = new ArrayList<ValuedDataObject>();
        if (otherElement.getDataObjects() != null && !otherElement.getDataObjects().isEmpty()) {
            for (ValuedDataObject dataObject : otherElement.getDataObjects()) {
                ValuedDataObject clone = dataObject.clone();
                this.dataObjects.add(clone);
                this.removeFlowElement(clone.getId());
                this.addFlowElement(clone);
            }
        }
        this.flowElementList.clear();
        for (FlowElement flowElement : otherElement.getFlowElements()) {
            this.addFlowElement(flowElement);
        }
        this.artifactList.clear();
        for (Artifact artifact : otherElement.getArtifacts()) {
            this.addArtifact(artifact);
        }
    }

    public List<ValuedDataObject> getDataObjects() {
        return this.dataObjects;
    }

    public void setDataObjects(List<ValuedDataObject> dataObjects) {
        this.dataObjects = dataObjects;
    }
}

