/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;

public abstract class NeedsActiveProcessDefinitionCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public NeedsActiveProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinition = deploymentManager.findDeployedProcessDefinitionById(this.processDefinitionId);
        if (deploymentManager.isProcessDefinitionSuspended(this.processDefinitionId)) {
            throw new ActivitiException("Cannot execute operation because process definition '" + processDefinition.getName() + "' (id=" + processDefinition.getId() + ") is supended");
        }
        return this.execute(commandContext, processDefinition);
    }

    protected abstract T execute(CommandContext var1, ProcessDefinitionEntity var2);
}

