/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.Signal;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.EventSubscriptionQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.event.EventHandler;
import org.activiti.engine.impl.persistence.CountingExecutionEntity;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.EventSubscriptionDataManager;

public class EventSubscriptionEntityManagerImpl
extends AbstractEntityManager<EventSubscriptionEntity>
implements EventSubscriptionEntityManager {
    protected EventSubscriptionDataManager eventSubscriptionDataManager;

    public EventSubscriptionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, EventSubscriptionDataManager eventSubscriptionDataManager) {
        super(processEngineConfiguration);
        this.eventSubscriptionDataManager = eventSubscriptionDataManager;
    }

    @Override
    protected DataManager<EventSubscriptionEntity> getDataManager() {
        return this.eventSubscriptionDataManager;
    }

    @Override
    public CompensateEventSubscriptionEntity createCompensateEventSubscription() {
        return this.eventSubscriptionDataManager.createCompensateEventSubscription();
    }

    @Override
    public MessageEventSubscriptionEntity createMessageEventSubscription() {
        return this.eventSubscriptionDataManager.createMessageEventSubscription();
    }

    @Override
    public SignalEventSubscriptionEntity createSignalEventSubscription() {
        return this.eventSubscriptionDataManager.createSignalEventSubscription();
    }

    @Override
    public SignalEventSubscriptionEntity insertSignalEvent(String signalName, Signal signal, ExecutionEntity execution) {
        SignalEventSubscriptionEntity subscriptionEntity = this.createSignalEventSubscription();
        subscriptionEntity.setExecution(execution);
        if (signal != null) {
            subscriptionEntity.setEventName(signal.getName());
            if (signal.getScope() != null) {
                subscriptionEntity.setConfiguration(signal.getScope());
            }
        } else {
            subscriptionEntity.setEventName(signalName);
        }
        subscriptionEntity.setActivityId(execution.getCurrentActivityId());
        subscriptionEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        if (execution.getTenantId() != null) {
            subscriptionEntity.setTenantId(execution.getTenantId());
        }
        this.insert(subscriptionEntity);
        execution.getEventSubscriptions().add(subscriptionEntity);
        return subscriptionEntity;
    }

    @Override
    public MessageEventSubscriptionEntity insertMessageEvent(String messageName, ExecutionEntity execution) {
        MessageEventSubscriptionEntity subscriptionEntity = this.createMessageEventSubscription();
        subscriptionEntity.setExecution(execution);
        subscriptionEntity.setEventName(messageName);
        subscriptionEntity.setActivityId(execution.getCurrentActivityId());
        subscriptionEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        if (execution.getTenantId() != null) {
            subscriptionEntity.setTenantId(execution.getTenantId());
        }
        this.insert(subscriptionEntity);
        execution.getEventSubscriptions().add(subscriptionEntity);
        return subscriptionEntity;
    }

    @Override
    public CompensateEventSubscriptionEntity insertCompensationEvent(ExecutionEntity execution, String activityId) {
        CompensateEventSubscriptionEntity eventSubscription = this.createCompensateEventSubscription();
        eventSubscription.setExecution(execution);
        eventSubscription.setActivityId(activityId);
        if (execution.getTenantId() != null) {
            eventSubscription.setTenantId(execution.getTenantId());
        }
        this.insert(eventSubscription);
        return eventSubscription;
    }

    @Override
    public void insert(EventSubscriptionEntity entity, boolean fireCreateEvent) {
        CountingExecutionEntity executionEntity;
        super.insert(entity, fireCreateEvent);
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)((Object)entity.getExecution()))) {
            executionEntity.setEventSubscriptionCount(executionEntity.getEventSubscriptionCount() + 1);
        }
    }

    @Override
    public void delete(EventSubscriptionEntity entity, boolean fireDeleteEvent) {
        CountingExecutionEntity executionEntity;
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)((Object)entity.getExecution()))) {
            executionEntity.setEventSubscriptionCount(executionEntity.getEventSubscriptionCount() - 1);
        }
        super.delete(entity, fireDeleteEvent);
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionId(String executionId) {
        return this.findCompensateEventSubscriptionsByExecutionIdAndActivityId(executionId, null);
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionIdAndActivityId(String executionId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByExecutionAndType(executionId, "compensate");
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || activityId != null && !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(String processInstanceId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByProcessInstanceAndActivityId(processInstanceId, activityId, "compensate");
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    protected void addToExecution(EventSubscriptionEntity eventSubscriptionEntity) {
        ExecutionEntity execution = eventSubscriptionEntity.getExecution();
        if (execution != null) {
            execution.getEventSubscriptions().add(eventSubscriptionEntity);
        }
    }

    @Override
    public long findEventSubscriptionCountByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl) {
        return this.eventSubscriptionDataManager.findEventSubscriptionCountByQueryCriteria(eventSubscriptionQueryImpl);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl, Page page) {
        return this.eventSubscriptionDataManager.findEventSubscriptionsByQueryCriteria(eventSubscriptionQueryImpl, page);
    }

    @Override
    public List<MessageEventSubscriptionEntity> findMessageEventSubscriptionsByProcessInstanceAndEventName(String processInstanceId, String eventName) {
        return this.eventSubscriptionDataManager.findMessageEventSubscriptionsByProcessInstanceAndEventName(processInstanceId, eventName);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByEventName(String eventName, String tenantId) {
        return this.eventSubscriptionDataManager.findSignalEventSubscriptionsByEventName(eventName, tenantId);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByProcessInstanceAndEventName(String processInstanceId, String eventName) {
        return this.eventSubscriptionDataManager.findSignalEventSubscriptionsByProcessInstanceAndEventName(processInstanceId, eventName);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByNameAndExecution(String name, String executionId) {
        return this.eventSubscriptionDataManager.findSignalEventSubscriptionsByNameAndExecution(name, executionId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecutionAndType(String executionId, String type) {
        return this.eventSubscriptionDataManager.findEventSubscriptionsByExecutionAndType(executionId, type);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByProcessInstanceAndActivityId(String processInstanceId, String activityId, String type) {
        return this.eventSubscriptionDataManager.findEventSubscriptionsByProcessInstanceAndActivityId(processInstanceId, activityId, type);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecution(String executionId) {
        return this.eventSubscriptionDataManager.findEventSubscriptionsByExecution(executionId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByTypeAndProcessDefinitionId(String type, String processDefinitionId, String tenantId) {
        return this.eventSubscriptionDataManager.findEventSubscriptionsByTypeAndProcessDefinitionId(type, processDefinitionId, tenantId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByName(String type, String eventName, String tenantId) {
        return this.eventSubscriptionDataManager.findEventSubscriptionsByName(type, eventName, tenantId);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndExecution(String type, String eventName, String executionId) {
        return this.eventSubscriptionDataManager.findEventSubscriptionsByNameAndExecution(type, eventName, executionId);
    }

    @Override
    public MessageEventSubscriptionEntity findMessageStartEventSubscriptionByName(String messageName, String tenantId) {
        return this.eventSubscriptionDataManager.findMessageStartEventSubscriptionByName(messageName, tenantId);
    }

    @Override
    public void updateEventSubscriptionTenantId(String oldTenantId, String newTenantId) {
        this.eventSubscriptionDataManager.updateEventSubscriptionTenantId(oldTenantId, newTenantId);
    }

    @Override
    public void deleteEventSubscriptionsForProcessDefinition(String processDefinitionId) {
        this.eventSubscriptionDataManager.deleteEventSubscriptionsForProcessDefinition(processDefinitionId);
    }

    @Override
    public void eventReceived(EventSubscriptionEntity eventSubscriptionEntity, Object payload, boolean processASync) {
        if (processASync) {
            this.scheduleEventAsync(eventSubscriptionEntity, payload);
        } else {
            this.processEventSync(eventSubscriptionEntity, payload);
        }
    }

    protected void processEventSync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        EventHandler eventHandler;
        if (eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) {
            this.delete(eventSubscriptionEntity);
        }
        if ((eventHandler = this.getProcessEngineConfiguration().getEventHandler(eventSubscriptionEntity.getEventType())) == null) {
            throw new ActivitiException("Could not find eventhandler for event of type '" + eventSubscriptionEntity.getEventType() + "'.");
        }
        eventHandler.handleEvent(eventSubscriptionEntity, payload, this.getCommandContext());
    }

    protected void scheduleEventAsync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        JobEntity message = (JobEntity)this.getJobEntityManager().create();
        message.setJobType("message");
        message.setJobHandlerType("event");
        message.setJobHandlerConfiguration(eventSubscriptionEntity.getId());
        message.setTenantId(eventSubscriptionEntity.getTenantId());
        this.getJobManager().scheduleAsyncJob(message);
    }

    protected List<SignalEventSubscriptionEntity> toSignalEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<SignalEventSubscriptionEntity> signalEventSubscriptionEntities = new ArrayList<SignalEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            signalEventSubscriptionEntities.add((SignalEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return signalEventSubscriptionEntities;
    }

    protected List<MessageEventSubscriptionEntity> toMessageEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<MessageEventSubscriptionEntity> messageEventSubscriptionEntities = new ArrayList<MessageEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            messageEventSubscriptionEntities.add((MessageEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return messageEventSubscriptionEntities;
    }

    public EventSubscriptionDataManager getEventSubscriptionDataManager() {
        return this.eventSubscriptionDataManager;
    }

    public void setEventSubscriptionDataManager(EventSubscriptionDataManager eventSubscriptionDataManager) {
        this.eventSubscriptionDataManager = eventSubscriptionDataManager;
    }
}

