/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.mqtt.MQTTSubscription;
import org.apache.activemq.util.LRUCache;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.fusesource.mqtt.codec.PUBLISH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTPacketIdGenerator
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTPacketIdGenerator.class);
    private static final Object LOCK = new Object();
    Map<String, PacketIdMaps> clientIdMap = new ConcurrentHashMap<String, PacketIdMaps>();
    private final NonZeroSequenceGenerator messageIdGenerator = new NonZeroSequenceGenerator();

    private MQTTPacketIdGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        MQTTPacketIdGenerator mQTTPacketIdGenerator = this;
        synchronized (mQTTPacketIdGenerator) {
            this.clientIdMap = new ConcurrentHashMap<String, PacketIdMaps>();
        }
    }

    @Override
    protected void doStart() throws Exception {
    }

    public void startClientSession(String clientId) {
        if (!this.clientIdMap.containsKey(clientId)) {
            this.clientIdMap.put(clientId, new PacketIdMaps());
        }
    }

    public boolean stopClientSession(String clientId) {
        return this.clientIdMap.remove(clientId) != null;
    }

    public short setPacketId(String clientId, MQTTSubscription subscription, ActiveMQMessage message, PUBLISH publish) {
        PacketIdMaps idMaps = this.clientIdMap.get(clientId);
        if (idMaps == null) {
            short id = this.messageIdGenerator.getNextSequenceId();
            publish.messageId(id);
            return id;
        }
        return idMaps.setPacketId(subscription, message, publish);
    }

    public void ackPacketId(String clientId, short packetId) {
        PacketIdMaps idMaps = this.clientIdMap.get(clientId);
        if (idMaps != null) {
            idMaps.ackPacketId(packetId);
        }
    }

    public short getNextSequenceId(String clientId) {
        PacketIdMaps idMaps = this.clientIdMap.get(clientId);
        return idMaps != null ? idMaps.getNextSequenceId() : this.messageIdGenerator.getNextSequenceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQTTPacketIdGenerator getMQTTPacketIdGenerator(BrokerService broker) {
        MQTTPacketIdGenerator result = null;
        if (broker != null) {
            Object object = LOCK;
            synchronized (object) {
                Service[] services = broker.getServices();
                if (services != null) {
                    for (Service service : services) {
                        if (!(service instanceof MQTTPacketIdGenerator)) continue;
                        return (MQTTPacketIdGenerator)service;
                    }
                }
                result = new MQTTPacketIdGenerator();
                broker.addService(result);
                if (broker.isStarted()) {
                    try {
                        result.start();
                    }
                    catch (Exception e) {
                        LOG.warn("Couldn't start MQTTPacketIdGenerator");
                    }
                }
            }
        }
        return result;
    }

    private class NonZeroSequenceGenerator {
        private short lastSequenceId;

        private NonZeroSequenceGenerator() {
        }

        public synchronized short getNextSequenceId() {
            this.lastSequenceId = (short)(this.lastSequenceId + 1);
            short val = this.lastSequenceId;
            return val != 0 ? val : (this.lastSequenceId = (short)(this.lastSequenceId + 1));
        }
    }

    private class PacketIdMaps {
        private final NonZeroSequenceGenerator messageIdGenerator;
        final Map<String, Short> activemqToPacketIds;
        final Map<Short, String> packetIdsToActivemq;

        private PacketIdMaps() {
            this.messageIdGenerator = new NonZeroSequenceGenerator();
            this.activemqToPacketIds = new LRUCache<String, Short>(5000);
            this.packetIdsToActivemq = new LRUCache<Short, String>(5000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        short setPacketId(MQTTSubscription subscription, ActiveMQMessage message, PUBLISH publish) {
            Short packetId;
            StringBuilder subscriptionKey = new StringBuilder();
            subscriptionKey.append(subscription.getConsumerInfo().getDestination().getPhysicalName()).append(':').append(message.getJMSMessageID());
            String keyStr = subscriptionKey.toString();
            Map<String, Short> map = this.activemqToPacketIds;
            synchronized (map) {
                packetId = this.activemqToPacketIds.get(keyStr);
                if (packetId == null) {
                    packetId = this.getNextSequenceId();
                    this.activemqToPacketIds.put(keyStr, packetId);
                    this.packetIdsToActivemq.put(packetId, keyStr);
                } else {
                    publish.dup(true);
                }
            }
            publish.messageId(packetId.shortValue());
            return packetId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ackPacketId(short packetId) {
            Map<String, Short> map = this.activemqToPacketIds;
            synchronized (map) {
                String subscriptionKey = this.packetIdsToActivemq.remove(packetId);
                if (subscriptionKey != null) {
                    this.activemqToPacketIds.remove(subscriptionKey);
                }
            }
        }

        short getNextSequenceId() {
            return this.messageIdGenerator.getNextSequenceId();
        }
    }
}

