/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.IsSingleton;
import org.apache.camel.spi.Language;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;

public abstract class LanguageSupport
implements Language,
IsSingleton,
CamelContextAware {
    public static final String RESOURCE = "resource:";
    private CamelContext camelContext;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    protected String loadResource(String expression) throws ExpressionIllegalSyntaxException {
        if (this.camelContext != null && expression.startsWith(RESOURCE)) {
            String uri = expression.substring(RESOURCE.length());
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.camelContext.getClassResolver(), uri);
                expression = this.camelContext.getTypeConverter().mandatoryConvertTo(String.class, is);
            }
            catch (Exception e) {
                try {
                    throw new ExpressionIllegalSyntaxException(expression, e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
        }
        return expression;
    }
}

