/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.IsSingleton;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class EmptyConsumerCache
extends ConsumerCache {
    public EmptyConsumerCache(Object source, CamelContext camelContext) {
        super(source, camelContext, 0);
    }

    @Override
    public PollingConsumer acquirePollingConsumer(Endpoint endpoint) {
        PollingConsumer answer;
        try {
            answer = endpoint.createPollingConsumer();
            boolean singleton = true;
            if (answer instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)answer)).isSingleton();
            }
            if (this.getCamelContext().isStartingRoutes() && singleton) {
                this.getCamelContext().addService(answer);
            } else {
                ServiceHelper.startService(answer);
            }
        }
        catch (Exception e) {
            throw new FailedToCreateConsumerException(endpoint, (Throwable)e);
        }
        return answer;
    }

    @Override
    public void releasePollingConsumer(Endpoint endpoint, PollingConsumer pollingConsumer) {
        try {
            ServiceHelper.stopAndShutdownService(pollingConsumer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public String toString() {
        return "EmptyConsumerCache for source: " + this.getSource();
    }
}

