/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;

public class SerializationDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    @Override
    public String getDataFormatName() {
        return "serialization";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ObjectOutput out = ExchangeHelper.convertToMandatoryType(exchange, ObjectOutput.class, stream);
        try {
            out.writeObject(graph);
        }
        finally {
            out.flush();
            try {
                out.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        ObjectInput in = ExchangeHelper.convertToMandatoryType(exchange, ObjectInput.class, stream);
        try {
            Object object = in.readObject();
            return object;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

