/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Closeable;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQUuidGenerator
implements UuidGenerator {
    public static final String PROPERTY_IDGENERATOR_HOSTNAME = "activemq.idgenerator.hostname";
    public static final String PROPERTY_IDGENERATOR_LOCALPORT = "activemq.idgenerator.localport";
    public static final String PROPERTY_IDGENERATOR_PORT = "activemq.idgenerator.port";
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQUuidGenerator.class);
    private static final String UNIQUE_STUB;
    private static int instanceCount;
    private static String hostName;
    private String seed;
    private final AtomicLong sequence = new AtomicLong(1L);
    private final int length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQUuidGenerator(String prefix) {
        String string = UNIQUE_STUB;
        synchronized (string) {
            this.seed = prefix + UNIQUE_STUB + instanceCount++ + "-";
            this.seed = ActiveMQUuidGenerator.generateSanitizedId(this.seed);
            this.length = this.seed.length() + "9223372036854775807".length();
        }
    }

    public ActiveMQUuidGenerator() {
        this("ID-" + hostName);
    }

    public static String getHostName() {
        return hostName;
    }

    public static String sanitizeHostName(String hostName) {
        boolean changed2 = false;
        StringBuilder sb = new StringBuilder();
        for (char ch : hostName.toCharArray()) {
            if (ch < '\u007f') {
                sb.append(ch);
                continue;
            }
            changed2 = true;
        }
        if (changed2) {
            String newHost = sb.toString();
            LOG.info("Sanitized hostname from: {} to: {}", (Object)hostName, (Object)newHost);
            return newHost;
        }
        return hostName;
    }

    @Override
    public String generateUuid() {
        StringBuilder sb = new StringBuilder(this.length);
        sb.append(this.seed);
        sb.append(this.sequence.getAndIncrement());
        return sb.toString();
    }

    public String generateSanitizedId() {
        return ActiveMQUuidGenerator.generateSanitizedId(this.generateUuid());
    }

    public static String generateSanitizedId(String id) {
        id = id.replace(':', '-');
        id = id.replace('_', '-');
        id = id.replace('.', '-');
        id = id.replace('/', '-');
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String stub = "";
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            ServerSocket ss;
            block14: {
                hostName = System.getProperty(PROPERTY_IDGENERATOR_HOSTNAME);
                int localPort = Integer.parseInt(System.getProperty(PROPERTY_IDGENERATOR_LOCALPORT, "0"));
                int idGeneratorPort = 0;
                ss = null;
                try {
                    if (hostName == null) {
                        hostName = InetAddressUtil.getLocalHostName();
                    }
                    if (localPort == 0) {
                        idGeneratorPort = Integer.parseInt(System.getProperty(PROPERTY_IDGENERATOR_PORT, "0"));
                        LOG.trace("Using port {}", (Object)idGeneratorPort);
                        ss = new ServerSocket(idGeneratorPort);
                        localPort = ss.getLocalPort();
                        stub = "-" + localPort + "-" + System.currentTimeMillis() + "-";
                        Thread.sleep(100L);
                        break block14;
                    }
                    stub = "-" + localPort + "-" + System.currentTimeMillis() + "-";
                }
                catch (Exception e) {
                    block15: {
                        try {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Cannot generate unique stub by using DNS and binding to local port: " + idGeneratorPort, e);
                            } else {
                                LOG.warn("Cannot generate unique stub by using DNS and binding to local port: " + idGeneratorPort + " due " + e.getMessage());
                            }
                            if (!(e instanceof InterruptedException)) break block15;
                            Thread.currentThread().interrupt();
                        }
                        catch (Throwable throwable) {
                            IOHelper.close(ss);
                            throw throwable;
                        }
                    }
                    IOHelper.close((Closeable)ss);
                }
            }
            IOHelper.close((Closeable)ss);
        }
        if (hostName == null) {
            hostName = "localhost";
        }
        hostName = ActiveMQUuidGenerator.sanitizeHostName(hostName);
        if (ObjectHelper.isEmpty(stub)) {
            stub = "-1-" + System.currentTimeMillis() + "-";
        }
        UNIQUE_STUB = stub;
    }
}

