/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class CachedMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private static final Method setDeliveryDelayMethod = ClassUtils.getMethodIfAvailable(MessageProducer.class, "setDeliveryDelay", Long.TYPE);
    private static final Method getDeliveryDelayMethod = ClassUtils.getMethodIfAvailable(MessageProducer.class, "getDeliveryDelay", new Class[0]);
    private static Class<?> completionListenerClass;
    private static Method sendWithCompletionListenerMethod;
    private static Method sendWithDestinationAndCompletionListenerMethod;
    private final MessageProducer target;
    private Boolean originalDisableMessageID;
    private Boolean originalDisableMessageTimestamp;
    private Long originalDeliveryDelay;
    private int deliveryMode;
    private int priority;
    private long timeToLive;

    public CachedMessageProducer(MessageProducer target) throws JMSException {
        this.target = target;
        this.deliveryMode = target.getDeliveryMode();
        this.priority = target.getPriority();
        this.timeToLive = target.getTimeToLive();
    }

    @Override
    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        if (this.originalDisableMessageID == null) {
            this.originalDisableMessageID = this.target.getDisableMessageID();
        }
        this.target.setDisableMessageID(disableMessageID);
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        return this.target.getDisableMessageID();
    }

    @Override
    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        if (this.originalDisableMessageTimestamp == null) {
            this.originalDisableMessageTimestamp = this.target.getDisableMessageTimestamp();
        }
        this.target.setDisableMessageTimestamp(disableMessageTimestamp);
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.target.getDisableMessageTimestamp();
    }

    public void setDeliveryDelay(long deliveryDelay) {
        if (this.originalDeliveryDelay == null) {
            this.originalDeliveryDelay = (Long)ReflectionUtils.invokeMethod(getDeliveryDelayMethod, this.target);
        }
        ReflectionUtils.invokeMethod(setDeliveryDelayMethod, this.target, deliveryDelay);
    }

    public long getDeliveryDelay() {
        return (Long)ReflectionUtils.invokeMethod(getDeliveryDelayMethod, this.target);
    }

    @Override
    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Destination getDestination() throws JMSException {
        return this.target.getDestination();
    }

    @Override
    public Queue getQueue() throws JMSException {
        return (Queue)this.target.getDestination();
    }

    @Override
    public Topic getTopic() throws JMSException {
        return (Topic)this.target.getDestination();
    }

    @Override
    public void send(Message message) throws JMSException {
        this.target.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        this.target.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(destination, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Queue queue2, Message message) throws JMSException {
        this.target.send(queue2, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Queue queue2, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(queue2, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Message message) throws JMSException {
        this.target.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Topic topic, Message message) throws JMSException {
        this.target.send(topic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(topic, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void close() throws JMSException {
        if (this.originalDisableMessageID != null) {
            this.target.setDisableMessageID(this.originalDisableMessageID);
            this.originalDisableMessageID = null;
        }
        if (this.originalDisableMessageTimestamp != null) {
            this.target.setDisableMessageTimestamp(this.originalDisableMessageTimestamp);
            this.originalDisableMessageTimestamp = null;
        }
        if (this.originalDeliveryDelay != null) {
            ReflectionUtils.invokeMethod(setDeliveryDelayMethod, this.target, this.originalDeliveryDelay);
            this.originalDeliveryDelay = null;
        }
    }

    public String toString() {
        return "Cached JMS MessageProducer: " + this.target;
    }

    public MessageProducer getProxyIfNecessary() {
        if (completionListenerClass != null) {
            return (MessageProducer)Proxy.newProxyInstance(CachedMessageProducer.class.getClassLoader(), new Class[]{MessageProducer.class, QueueSender.class, TopicPublisher.class}, (InvocationHandler)new Jms2MessageProducerInvocationHandler());
        }
        return this;
    }

    static {
        try {
            completionListenerClass = ClassUtils.forName("javax.jms.CompletionListener", CachedMessageProducer.class.getClassLoader());
            sendWithCompletionListenerMethod = MessageProducer.class.getMethod("send", Message.class, Integer.TYPE, Integer.TYPE, Long.TYPE, completionListenerClass);
            sendWithDestinationAndCompletionListenerMethod = MessageProducer.class.getMethod("send", Destination.class, Message.class, Integer.TYPE, Integer.TYPE, Long.TYPE, completionListenerClass);
        }
        catch (Exception ex) {
            completionListenerClass = null;
        }
    }

    private class Jms2MessageProducerInvocationHandler
    implements InvocationHandler {
        private Jms2MessageProducerInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getName().equals("send") && args != null && completionListenerClass == method.getParameterTypes()[args.length - 1]) {
                    switch (args.length) {
                        case 2: {
                            return sendWithCompletionListenerMethod.invoke((Object)CachedMessageProducer.this.target, args[0], CachedMessageProducer.this.deliveryMode, CachedMessageProducer.this.priority, CachedMessageProducer.this.timeToLive, args[1]);
                        }
                        case 3: {
                            return sendWithDestinationAndCompletionListenerMethod.invoke((Object)CachedMessageProducer.this.target, args[0], args[1], CachedMessageProducer.this.deliveryMode, CachedMessageProducer.this.priority, CachedMessageProducer.this.timeToLive, args[2]);
                        }
                        case 5: {
                            return sendWithCompletionListenerMethod.invoke((Object)CachedMessageProducer.this.target, args);
                        }
                        case 6: {
                            return sendWithDestinationAndCompletionListenerMethod.invoke((Object)CachedMessageProducer.this.target, args);
                        }
                    }
                }
                return method.invoke((Object)CachedMessageProducer.this, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

