/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.util.ReflectionUtils;

public class AnnotationExceptionHandlerMethodResolver
extends AbstractExceptionHandlerMethodResolver {
    @Deprecated
    public static final ReflectionUtils.MethodFilter EXCEPTION_HANDLER_METHOD_FILTER = new ReflectionUtils.MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return AnnotationUtils.findAnnotation(method, MessageExceptionHandler.class) != null;
        }
    };

    public AnnotationExceptionHandlerMethodResolver(Class<?> handlerType) {
        super(AnnotationExceptionHandlerMethodResolver.initExceptionMappings(handlerType));
    }

    private static Map<Class<? extends Throwable>, Method> initExceptionMappings(Class<?> handlerType) {
        Map<Method, MessageExceptionHandler> methods = MethodIntrospector.selectMethods(handlerType, new MethodIntrospector.MetadataLookup<MessageExceptionHandler>(){

            @Override
            public MessageExceptionHandler inspect(Method method) {
                return AnnotationUtils.findAnnotation(method, MessageExceptionHandler.class);
            }
        });
        HashMap<Class<? extends Throwable>, Method> result = new HashMap<Class<? extends Throwable>, Method>();
        for (Map.Entry<Method, MessageExceptionHandler> entry : methods.entrySet()) {
            Method method = entry.getKey();
            ArrayList<Class<? extends Throwable>> exceptionTypes = new ArrayList<Class<? extends Throwable>>();
            exceptionTypes.addAll(Arrays.asList(entry.getValue().value()));
            if (exceptionTypes.isEmpty()) {
                exceptionTypes.addAll(AnnotationExceptionHandlerMethodResolver.getExceptionsFromMethodSignature(method));
            }
            for (Class clazz : exceptionTypes) {
                Method oldMethod = result.put(clazz, method);
                if (oldMethod == null || oldMethod.equals(method)) continue;
                throw new IllegalStateException("Ambiguous @ExceptionHandler method mapped for [" + clazz + "]: {" + oldMethod + ", " + method + "}");
            }
        }
        return result;
    }
}

