/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component.broker;

import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.camel.component.broker.BrokerEndpoint;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.impl.DefaultAsyncProducer;

public class BrokerProducer
extends DefaultAsyncProducer {
    private final BrokerEndpoint brokerEndpoint;

    public BrokerProducer(BrokerEndpoint endpoint) {
        super(endpoint);
        this.brokerEndpoint = endpoint;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.processInOnly(exchange, callback);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOnly(Exchange exchange, AsyncCallback callback) {
        try {
            ActiveMQMessage message = this.getMessage(exchange);
            if (message != null) {
                message.setDestination(this.brokerEndpoint.getDestination());
                ProducerBrokerExchange producerBrokerExchange = (ProducerBrokerExchange)exchange.getProperty("producerBrokerExchange");
                this.brokerEndpoint.inject(producerBrokerExchange, message);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    private ActiveMQMessage getMessage(Exchange exchange) throws IllegalStateException, JMSException {
        Message camelMessage = this.getMessageFromExchange(exchange);
        this.checkOriginalMessage(camelMessage);
        ActiveMQMessage result = (ActiveMQMessage)((JmsMessage)camelMessage).getJmsMessage();
        this.applyNewHeaders(result, camelMessage.getHeaders());
        return result;
    }

    private Message getMessageFromExchange(Exchange exchange) {
        if (exchange.hasOut()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    private void checkOriginalMessage(Message camelMessage) throws IllegalStateException {
        if (!(camelMessage instanceof JmsMessage)) {
            throw new IllegalStateException("Not the original message from the broker " + camelMessage);
        }
        javax.jms.Message message = ((JmsMessage)camelMessage).getJmsMessage();
        if (!(message instanceof ActiveMQMessage)) {
            throw new IllegalStateException("Not the original message from the broker " + message);
        }
    }

    private void applyNewHeaders(ActiveMQMessage message, Map<String, Object> headers) throws JMSException {
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            message.setObjectProperty(key, value.toString(), false);
        }
    }
}

