/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.listener.SubscriptionNameProvider;
import org.springframework.jms.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.jms.listener.adapter.ListenerExecutionFailedException;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;

public class MessageListenerAdapter
extends AbstractAdaptableMessageListener
implements SubscriptionNameProvider {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    private Object delegate;
    private String defaultListenerMethod = "handleMessage";

    public MessageListenerAdapter() {
        this.initDefaultStrategies();
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
    }

    @Deprecated
    protected void initDefaultStrategies() {
    }

    public void setDelegate(Object delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    @Override
    public void onMessage(Message message, Session session) throws JMSException {
        Object convertedMessage;
        String methodName;
        Object delegate = this.getDelegate();
        if (delegate != this) {
            if (delegate instanceof SessionAwareMessageListener) {
                if (session != null) {
                    ((SessionAwareMessageListener)delegate).onMessage(message, session);
                    return;
                }
                if (!(delegate instanceof MessageListener)) {
                    throw new IllegalStateException("MessageListenerAdapter cannot handle a SessionAwareMessageListener delegate if it hasn't been invoked with a Session itself");
                }
            }
            if (delegate instanceof MessageListener) {
                ((MessageListener)delegate).onMessage(message);
                return;
            }
        }
        if ((methodName = this.getListenerMethodName(message, convertedMessage = this.extractMessage(message))) == null) {
            throw new IllegalStateException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
        }
        Object[] listenerArguments = this.buildListenerArguments(convertedMessage);
        Object result = this.invokeListenerMethod(methodName, listenerArguments);
        if (result != null) {
            this.handleResult(result, message, session);
        } else {
            this.logger.trace("No result object given - no result to handle");
        }
    }

    @Override
    public String getSubscriptionName() {
        Object delegate = this.getDelegate();
        if (delegate != this && delegate instanceof SubscriptionNameProvider) {
            return ((SubscriptionNameProvider)delegate).getSubscriptionName();
        }
        return delegate.getClass().getName();
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) throws JMSException {
        return this.getDefaultListenerMethod();
    }

    protected Object[] buildListenerArguments(Object extractedMessage) {
        return new Object[]{extractedMessage};
    }

    protected Object invokeListenerMethod(String methodName, Object[] arguments) throws JMSException {
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(this.getDelegate());
            methodInvoker.setTargetMethod(methodName);
            methodInvoker.setArguments(arguments);
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof JMSException) {
                throw (JMSException)targetEx;
            }
            throw new ListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", targetEx);
        }
        catch (Throwable ex) {
            throw new ListenerExecutionFailedException("Failed to invoke target method '" + methodName + "' with arguments " + ObjectUtils.nullSafeToString(arguments), ex);
        }
    }
}

