/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.RecordableReader;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTokenExpressionIterator
extends ExpressionAdapter
implements NamespaceAware {
    protected final String path;
    protected char mode;
    protected int group;
    protected Map<String, String> nsmap;

    public XMLTokenExpressionIterator(String path, char mode) {
        this(path, mode, 1);
    }

    public XMLTokenExpressionIterator(String path, char mode, int group) {
        StringHelper.notEmpty(path, "path");
        this.path = path;
        this.mode = mode;
        this.group = group > 1 ? group : 1;
    }

    @Override
    public void setNamespaces(Map<String, String> nsmap) {
        this.nsmap = nsmap;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.nsmap;
    }

    public void setMode(char mode) {
        this.mode = mode;
    }

    public void setMode(String mode) {
        this.mode = mode != null ? mode.charAt(0) : (char)'\u0000';
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    protected Iterator<?> createIterator(InputStream in, String charset) throws XMLStreamException, UnsupportedEncodingException {
        return new XMLTokenIterator(this.path, this.nsmap, this.mode, this.group, in, charset);
    }

    protected Iterator<?> createIterator(Reader in) throws XMLStreamException {
        return new XMLTokenIterator(this.path, this.nsmap, this.mode, this.group, in);
    }

    @Override
    public boolean matches(Exchange exchange) {
        Object value = this.doEvaluate(exchange, true);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    @Override
    public Object evaluate(Exchange exchange) {
        return this.doEvaluate(exchange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doEvaluate(Exchange exchange, boolean closeStream) {
        InputStream in = null;
        try {
            in = exchange.getIn().getMandatoryBody(InputStream.class);
            String charset = IOHelper.getCharsetName(exchange);
            Iterator<?> iterator = this.createIterator(in, charset);
            return iterator;
        }
        catch (InvalidPayloadException e) {
            exchange.setException(e);
            IOHelper.close((Closeable)in);
            Object var5_9 = null;
            return var5_9;
        }
        catch (XMLStreamException e) {
            exchange.setException(e);
            IOHelper.close((Closeable)in);
            Object var5_10 = null;
            return var5_10;
        }
        catch (UnsupportedEncodingException e) {
            exchange.setException(e);
            IOHelper.close((Closeable)in);
            Object var5_11 = null;
            return var5_11;
        }
        finally {
            if (closeStream) {
                IOHelper.close((Closeable)in);
            }
        }
    }

    static class AttributedQName
    extends QName {
        private static final long serialVersionUID = 9878370226894144L;
        private Pattern lcpattern;
        private boolean nsany;

        AttributedQName(String localPart) {
            super(localPart);
            this.checkWildcard("", localPart);
        }

        AttributedQName(String namespaceURI, String localPart, String prefix) {
            super(namespaceURI, localPart, prefix);
            this.checkWildcard(namespaceURI, localPart);
        }

        AttributedQName(String namespaceURI, String localPart) {
            super(namespaceURI, localPart);
            this.checkWildcard(namespaceURI, localPart);
        }

        public boolean matches(QName qname) {
            return (this.nsany || this.getNamespaceURI().equals(qname.getNamespaceURI())) && (this.lcpattern != null ? this.lcpattern.matcher(qname.getLocalPart()).matches() : this.getLocalPart().equals(qname.getLocalPart()));
        }

        private void checkWildcard(String nsa, String lcp) {
            this.nsany = "*".equals(nsa);
            boolean wc = false;
            for (int i = 0; i < lcp.length(); ++i) {
                char c = lcp.charAt(i);
                if (c != '?' && c != '*') continue;
                wc = true;
                break;
            }
            if (wc) {
                StringBuilder sb = new StringBuilder();
                block6: for (int i = 0; i < lcp.length(); ++i) {
                    char c = lcp.charAt(i);
                    switch (c) {
                        case '.': {
                            sb.append("\\.");
                            continue block6;
                        }
                        case '*': {
                            sb.append(".*");
                            continue block6;
                        }
                        case '?': {
                            sb.append('.');
                            continue block6;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                this.lcpattern = Pattern.compile(sb.toString());
            }
        }
    }

    static class XMLTokenIterator
    implements Iterator<Object>,
    Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(XMLTokenIterator.class);
        private static final Pattern NAMESPACE_PATTERN = Pattern.compile("xmlns(:\\w+|)\\s*=\\s*('[^']*'|\"[^\"]*\")");
        private transient InputStream originalInputStream;
        private AttributedQName[] splitpath;
        private int index;
        private char mode;
        private int group;
        private RecordableReader in;
        private XMLStreamReader reader;
        private List<QName> path;
        private List<Map<String, String>> namespaces;
        private List<String> segments;
        private List<QName> segmentlog;
        private List<String> tokens;
        private int code;
        private int consumed;
        private boolean backtrack;
        private int trackdepth = -1;
        private int depth;
        private boolean compliant;
        private Object nextToken;

        XMLTokenIterator(String path, Map<String, String> nsmap, char mode, InputStream in, String charset) throws XMLStreamException, UnsupportedEncodingException {
            this(path, nsmap, mode, 1, new InputStreamReader(in, charset));
            this.originalInputStream = in;
        }

        XMLTokenIterator(String path, Map<String, String> nsmap, char mode, int group, InputStream in, String charset) throws XMLStreamException, UnsupportedEncodingException {
            this(path, nsmap, mode, group, new InputStreamReader(in, charset));
            this.originalInputStream = in;
        }

        XMLTokenIterator(String path, Map<String, String> nsmap, char mode, Reader in) throws XMLStreamException {
            this(path, nsmap, mode, 1, in);
        }

        XMLTokenIterator(String path, Map<String, String> nsmap, char mode, int group, Reader in) throws XMLStreamException {
            String[] sl = path.substring(1).split("/");
            this.splitpath = new AttributedQName[sl.length];
            for (int i = 0; i < sl.length; ++i) {
                String pfx;
                String s = sl[i];
                if (s.length() <= 0) continue;
                int d = s.indexOf(58);
                String string = pfx = d > 0 ? s.substring(0, d) : "";
                this.splitpath[i] = new AttributedQName("*".equals(pfx) ? "*" : (nsmap == null ? "" : nsmap.get(pfx)), d > 0 ? s.substring(d + 1) : s, pfx);
            }
            this.mode = (char)(mode != 0 ? mode : 105);
            this.group = group > 0 ? group : 1;
            this.in = new RecordableReader(in);
            this.reader = new StaxConverter().createXMLStreamReader(this.in);
            LOG.trace("reader.class: {}", (Object)this.reader.getClass());
            int coff = this.reader.getLocation().getCharacterOffset();
            if (coff != 0) {
                LOG.error("XMLStreamReader {} not supporting Location");
                throw new XMLStreamException("reader not supporting Location");
            }
            this.path = new ArrayList<QName>();
            if (this.mode == 'w') {
                this.segments = new ArrayList<String>();
                this.segmentlog = new ArrayList<QName>();
            } else if (this.mode == 'i') {
                this.namespaces = new ArrayList<Map<String, String>>();
            }
            if (this.group > 1) {
                this.tokens = new ArrayList<String>();
            }
            this.nextToken = this.getNextToken();
        }

        private boolean isDoS() {
            return this.splitpath[this.index] == null;
        }

        private AttributedQName current() {
            return this.splitpath[this.index + (this.isDoS() ? 1 : 0)];
        }

        private AttributedQName ancestor() {
            return this.index == 0 ? null : this.splitpath[this.index - 1];
        }

        private void down() {
            if (this.isDoS()) {
                ++this.index;
            }
            ++this.index;
        }

        private void up() {
            --this.index;
        }

        private boolean isBottom() {
            return this.index == this.splitpath.length - (this.isDoS() ? 2 : 1);
        }

        private boolean isTop() {
            return this.index == 0;
        }

        private int readNext() throws XMLStreamException {
            int c = this.code;
            if (c > 0) {
                this.code = 0;
            } else {
                c = this.reader.next();
            }
            return c;
        }

        private String getCurrentText() {
            int pos = this.reader.getLocation().getCharacterOffset();
            String txt = this.in.getText(pos - this.consumed);
            this.consumed = pos;
            this.in.record();
            return txt;
        }

        private void pushName(QName name) {
            this.path.add(name);
        }

        private QName popName() {
            return this.path.remove(this.path.size() - 1);
        }

        private void pushSegment(QName qname, String token) {
            this.segments.add(token);
            this.segmentlog.add(qname);
        }

        private String popSegment() {
            return this.segments.remove(this.segments.size() - 1);
        }

        private QName peekLog() {
            return this.segmentlog.get(this.segmentlog.size() - 1);
        }

        private QName popLog() {
            return this.segmentlog.remove(this.segmentlog.size() - 1);
        }

        private void pushNamespaces(XMLStreamReader reader) {
            HashMap<String, String> m = new HashMap<String, String>();
            if (this.namespaces.size() > 0) {
                m.putAll(this.namespaces.get(this.namespaces.size() - 1));
            }
            for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                m.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
            this.namespaces.add(m);
        }

        private void popNamespaces() {
            this.namespaces.remove(this.namespaces.size() - 1);
        }

        private Map<String, String> getCurrentNamespaceBindings() {
            return this.namespaces.get(this.namespaces.size() - 1);
        }

        private void readCurrent(boolean incl) throws XMLStreamException {
            int d = this.depth;
            while (d <= this.depth) {
                int code = this.reader.next();
                if (code == 1) {
                    ++this.depth;
                    continue;
                }
                if (code != 2) continue;
                --this.depth;
            }
            if (incl) {
                this.code = this.reader.next();
            } else {
                this.code = this.reader.getEventType();
                if (this.code == 2) {
                    ++this.depth;
                }
            }
        }

        private String getCurrentToken() throws XMLStreamException {
            this.readCurrent(true);
            this.popName();
            String token = this.createContextualToken(this.getCurrentText());
            if (this.mode == 'i') {
                this.popNamespaces();
            }
            return token;
        }

        private String createContextualToken(String token) {
            StringBuilder sb = new StringBuilder();
            if (this.mode == 'w' && this.group == 1) {
                int i;
                for (i = 0; i < this.segments.size(); ++i) {
                    sb.append(this.segments.get(i));
                }
                sb.append(token);
                for (i = this.path.size() - 1; i >= 0; --i) {
                    QName q = this.path.get(i);
                    sb.append("</").append(XMLTokenIterator.makeName(q)).append(">");
                }
            } else if (this.mode == 'i') {
                String stag = token.substring(0, token.indexOf(62) + 1);
                HashSet<String> skip = new HashSet<String>();
                Matcher matcher = NAMESPACE_PATTERN.matcher(stag);
                char quote = '\u0000';
                while (matcher.find()) {
                    String prefix = matcher.group(1);
                    if (prefix.length() > 0) {
                        prefix = prefix.substring(1);
                    }
                    skip.add(prefix);
                    if (quote != '\u0000') continue;
                    quote = matcher.group(2).charAt(0);
                }
                if (quote == '\u0000') {
                    quote = '\"';
                }
                boolean empty = stag.endsWith("/>");
                sb.append(token.substring(0, stag.length() - (empty ? 2 : 1)));
                for (Map.Entry<String, String> e : this.getCurrentNamespaceBindings().entrySet()) {
                    if (skip.contains(e.getKey())) continue;
                    sb.append(e.getKey().length() == 0 ? " xmlns" : " xmlns:").append(e.getKey()).append("=").append(quote).append(e.getValue()).append(quote);
                }
                sb.append(token.substring(stag.length() - (empty ? 2 : 1)));
            } else if (this.mode == 'u') {
                int bp = token.indexOf(">");
                int ep = token.lastIndexOf("</");
                if (bp > 0 && ep > 0) {
                    sb.append(token.substring(bp + 1, ep));
                }
            } else if (this.mode == 't') {
                int ep;
                int bp = 0;
                while ((bp = token.indexOf(60, ep = token.indexOf(62, bp))) >= 0) {
                    sb.append(token.substring(ep + 1, bp));
                }
            } else {
                return token;
            }
            return sb.toString();
        }

        private String getGroupedToken() {
            StringBuilder sb = new StringBuilder();
            if (this.mode == 'w') {
                for (int i = 0; i < this.segments.size(); ++i) {
                    sb.append(this.segments.get(i));
                }
                for (String s : this.tokens) {
                    sb.append(s);
                }
                for (int i = this.path.size() - 1; i >= 0; --i) {
                    QName q = this.path.get(i);
                    sb.append("</").append(XMLTokenIterator.makeName(q)).append(">");
                }
            } else {
                sb.append("<group>");
                for (String s : this.tokens) {
                    sb.append(s);
                }
                sb.append("</group>");
            }
            this.tokens.clear();
            return sb.toString();
        }

        private String getNextToken() throws XMLStreamException {
            int xcode = 0;
            block5: while (xcode != 8) {
                xcode = this.readNext();
                switch (xcode) {
                    case 1: {
                        ++this.depth;
                        QName name = this.reader.getName();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("se={}; depth={}; trackdepth={}", name, this.depth, this.trackdepth);
                        }
                        String token = this.getCurrentText();
                        if (!this.compliant) {
                            if (token != null && token.startsWith("<") && !token.startsWith("<?")) {
                                LOG.error("XMLStreamReader {} not supporting Location");
                                throw new XMLStreamException("reader not supporting Location");
                            }
                            this.compliant = true;
                        }
                        LOG.trace("token={}", (Object)token);
                        if (!this.backtrack && this.mode == 'w') {
                            this.pushSegment(name, token);
                        }
                        this.pushName(name);
                        if (this.mode == 'i') {
                            this.pushNamespaces(this.reader);
                        }
                        this.backtrack = false;
                        if (this.current().matches(name)) {
                            if (this.isBottom()) {
                                token = this.getCurrentToken();
                                this.backtrack = true;
                                this.trackdepth = this.depth;
                                if (this.group > 1) {
                                    this.tokens.add(token);
                                    if (this.group != this.tokens.size()) continue block5;
                                    return this.getGroupedToken();
                                }
                                return token;
                            }
                            this.down();
                            continue block5;
                        }
                        if (this.isDoS()) continue block5;
                        this.readCurrent(false);
                        continue block5;
                    }
                    case 2: {
                        if ((this.backtrack || this.trackdepth > 0 && this.depth == this.trackdepth) && this.mode == 'w' && this.group > 1 && this.tokens.size() > 0) {
                            this.code = 2;
                            return this.getGroupedToken();
                        }
                        --this.depth;
                        QName endname = this.reader.getName();
                        LOG.trace("ee={}", (Object)endname);
                        this.popName();
                        if (this.mode == 'i') {
                            this.popNamespaces();
                        }
                        int pc = 0;
                        if (this.backtrack || this.trackdepth > 0 && this.depth == this.trackdepth - 1) {
                            this.backtrack = true;
                            --this.trackdepth;
                            if (this.mode == 'w') {
                                while (!endname.equals(this.peekLog())) {
                                    ++pc;
                                    this.popLog();
                                }
                            }
                        }
                        if (!this.backtrack) continue block5;
                        if (this.mode == 'w') {
                            for (int i = 0; i < pc; ++i) {
                                this.popSegment();
                            }
                        }
                        if ((this.ancestor() != null || this.isTop()) && (this.ancestor() == null || !this.ancestor().matches(endname))) continue block5;
                        this.up();
                        continue block5;
                    }
                    case 8: {
                        LOG.trace("depth={}", (Object)this.depth);
                        if (this.group <= 1 || this.tokens.size() <= 0) continue block5;
                        this.code = 8;
                        return this.getGroupedToken();
                    }
                }
            }
            return null;
        }

        private static String makeName(QName qname) {
            String pfx = qname.getPrefix();
            return pfx.length() == 0 ? qname.getLocalPart() : qname.getPrefix() + ":" + qname.getLocalPart();
        }

        @Override
        public boolean hasNext() {
            return this.nextToken != null;
        }

        @Override
        public Object next() {
            Object o = this.nextToken;
            try {
                this.nextToken = this.getNextToken();
            }
            catch (XMLStreamException e) {
                this.nextToken = null;
                throw new RuntimeException(e);
            }
            return o;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() throws IOException {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.originalInputStream != null) {
                IOHelper.close((Closeable)this.originalInputStream);
            }
        }
    }
}

