/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTProtocolException;
import org.apache.activemq.transport.mqtt.MQTTSubscription;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.ResponseHandler;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LRUCache;
import org.apache.activemq.util.LongSequenceGenerator;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.CONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PINGRESP;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBACK;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MQTTProtocolConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTProtocolConverter.class);
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final MQTTFrame PING_RESP_FRAME = new PINGRESP().encode();
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final ConcurrentHashMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ConsumerId, MQTTSubscription> subscriptionsByConsumerId = new ConcurrentHashMap();
    private final ConcurrentHashMap<UTF8Buffer, MQTTSubscription> mqttSubscriptionByTopic = new ConcurrentHashMap();
    private final Map<UTF8Buffer, ActiveMQTopic> activeMQTopicMap = new LRUCache<UTF8Buffer, ActiveMQTopic>();
    private final Map<Destination, UTF8Buffer> mqttTopicMap = new LRUCache<Destination, UTF8Buffer>();
    private final Map<Short, MessageAck> consumerAcks = new LRUCache<Short, MessageAck>();
    private final Map<Short, PUBREC> publisherRecs = new LRUCache<Short, PUBREC>();
    private final MQTTTransport mqttTransport;
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private ConnectionInfo connectionInfo = new ConnectionInfo();
    private CONNECT connect;
    private String clientId;
    private final String QOS_PROPERTY_NAME = "QoSPropertyName";

    public MQTTProtocolConverter(MQTTTransport mqttTransport, BrokerContext brokerContext) {
        this.mqttTransport = mqttTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    void sendToActiveMQ(Command command, ResponseHandler handler) {
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.mqttTransport.sendToActiveMQ(command);
    }

    void sendToMQTT(MQTTFrame frame) {
        try {
            this.mqttTransport.sendToMQTT(frame);
        }
        catch (IOException e) {
            LOG.warn("Failed to send frame " + frame, e);
        }
    }

    public void onMQTTCommand(MQTTFrame frame) throws IOException, JMSException {
        switch (frame.messageType()) {
            case 12: {
                this.mqttTransport.sendToMQTT(PING_RESP_FRAME);
                LOG.debug("Sent Ping Response to " + this.getClientId());
                break;
            }
            case 1: {
                this.onMQTTConnect(new CONNECT().decode(frame));
                LOG.debug("MQTT Client " + this.getClientId() + " connected.");
                break;
            }
            case 14: {
                LOG.debug("MQTT Client " + this.getClientId() + " disconnecting");
                this.stopTransport();
                break;
            }
            case 8: {
                this.onSubscribe(new SUBSCRIBE().decode(frame));
                break;
            }
            case 10: {
                this.onUnSubscribe(new UNSUBSCRIBE().decode(frame));
                break;
            }
            case 3: {
                this.onMQTTPublish(new PUBLISH().decode(frame));
                break;
            }
            case 4: {
                this.onMQTTPubAck(new PUBACK().decode(frame));
                break;
            }
            case 5: {
                this.onMQTTPubRec(new PUBREC().decode(frame));
                break;
            }
            case 6: {
                this.onMQTTPubRel(new PUBREL().decode(frame));
                break;
            }
            case 7: {
                this.onMQTTPubComp(new PUBCOMP().decode(frame));
                break;
            }
            default: {
                this.handleException(new MQTTProtocolException("Unknown MQTTFrame type: " + frame.messageType(), true), frame);
            }
        }
    }

    void onMQTTConnect(CONNECT connect) throws MQTTProtocolException {
        if (this.connected.get()) {
            throw new MQTTProtocolException("All ready connected.");
        }
        this.connect = connect;
        String clientId = "";
        if (connect.clientId() != null) {
            clientId = connect.clientId().toString();
        }
        String userName = "";
        if (connect.userName() != null) {
            userName = connect.userName().toString();
        }
        String passswd = "";
        if (connect.password() != null) {
            passswd = connect.password().toString();
        }
        this.configureInactivityMonitor(connect.keepAlive());
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null && !clientId.isEmpty()) {
            this.connectionInfo.setClientId(clientId);
        } else {
            this.connectionInfo.setClientId("" + this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(userName);
        this.connectionInfo.setPassword(passswd);
        this.connectionInfo.setTransportContext(this.mqttTransport.getPeerCertificates());
        this.sendToActiveMQ(this.connectionInfo, new ResponseHandler(){

            @Override
            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    CONNACK ack = new CONNACK();
                    ack.code(CONNACK.Code.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
                    MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                    MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(MQTTProtocolConverter.this.sessionId);
                MQTTProtocolConverter.this.sendToActiveMQ(sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(MQTTProtocolConverter.this.producerId);
                MQTTProtocolConverter.this.sendToActiveMQ(producerInfo, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            CONNACK ack = new CONNACK();
                            ack.code(CONNACK.Code.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD);
                            MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                            MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                        }
                        CONNACK ack = new CONNACK();
                        ack.code(CONNACK.Code.CONNECTION_ACCEPTED);
                        MQTTProtocolConverter.this.connected.set(true);
                        MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                    }
                });
            }
        });
    }

    void onSubscribe(SUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        SUBACK result = new SUBACK();
        Topic[] topics = command.topics();
        if (topics != null) {
            byte[] qos = new byte[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                qos[i] = (byte)this.onSubscribe(command, topics[i]).ordinal();
            }
            SUBACK ack = new SUBACK();
            ack.messageId(command.messageId());
            ack.grantedQos(qos);
            try {
                this.getMQTTTransport().sendToMQTT(ack.encode());
            }
            catch (IOException e) {
                LOG.warn("Couldn't send SUBACK for " + command, e);
            }
        } else {
            LOG.warn("No topics defined for Subscription " + command);
        }
    }

    QoS onSubscribe(SUBSCRIBE command, Topic topic) throws MQTTProtocolException {
        ActiveMQTopic destination = new ActiveMQTopic(this.convertMQTTToActiveMQ(topic.name().toString()));
        if (destination == null) {
            throw new MQTTProtocolException("Invalid Destination.");
        }
        ConsumerId id = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
        ConsumerInfo consumerInfo = new ConsumerInfo(id);
        consumerInfo.setDestination(destination);
        consumerInfo.setPrefetchSize(1000);
        consumerInfo.setDispatchAsync(true);
        if (!this.connect.cleanSession() && this.connect.clientId() != null) {
            consumerInfo.setSubscriptionName(this.connect.clientId().toString());
        }
        MQTTSubscription mqttSubscription = new MQTTSubscription(this, topic.qos(), consumerInfo);
        this.subscriptionsByConsumerId.put(id, mqttSubscription);
        this.mqttSubscriptionByTopic.put(topic.name(), mqttSubscription);
        this.sendToActiveMQ(consumerInfo, null);
        return topic.qos();
    }

    void onUnSubscribe(UNSUBSCRIBE command) {
        UTF8Buffer[] topics = command.topics();
        if (topics != null) {
            for (int i = 0; i < topics.length; ++i) {
                this.onUnSubscribe(topics[i]);
            }
        }
        UNSUBACK ack = new UNSUBACK();
        ack.messageId(command.messageId());
        this.sendToMQTT(ack.encode());
    }

    void onUnSubscribe(UTF8Buffer topicName) {
        MQTTSubscription subs = this.mqttSubscriptionByTopic.remove(topicName);
        if (subs != null) {
            ConsumerInfo info = subs.getConsumerInfo();
            if (info != null) {
                this.subscriptionsByConsumerId.remove(info.getConsumerId());
            }
            RemoveInfo removeInfo = info.createRemoveCommand();
            this.sendToActiveMQ(removeInfo, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActiveMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            MQTTSubscription sub = this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (sub != null) {
                MessageAck ack = sub.createMessageAck(md);
                PUBLISH publish = sub.createPublish((ActiveMQMessage)md.getMessage());
                if (ack != null && sub.expectAck()) {
                    Map<Short, MessageAck> map = this.consumerAcks;
                    synchronized (map) {
                        this.consumerAcks.put(publish.messageId(), ack);
                    }
                }
                this.getMQTTTransport().sendToMQTT(publish.encode());
                if (ack != null && !sub.expectAck()) {
                    this.getMQTTTransport().sendToActiveMQ(ack);
                }
            }
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        } else if (!command.isBrokerInfo()) {
            LOG.debug("Do not know how to process ActiveMQ Command " + command);
        }
    }

    void onMQTTPublish(PUBLISH command) throws IOException, JMSException {
        this.checkConnected();
        ActiveMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        message.onSend();
        this.sendToActiveMQ(message, this.createResponseHandler(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubAck(PUBACK command) {
        MessageAck ack;
        short messageId = command.messageId();
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToActiveMQ(ack);
        }
    }

    void onMQTTPubRec(PUBREC commnand) {
        PUBREL pubrel = new PUBREL();
        pubrel.messageId(commnand.messageId());
        this.sendToMQTT(pubrel.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubRel(PUBREL command) {
        PUBREC ack;
        Map<Short, PUBREC> map = this.publisherRecs;
        synchronized (map) {
            ack = this.publisherRecs.remove(command.messageId());
        }
        if (ack == null) {
            LOG.warn("Unknown PUBREL: " + command.messageId() + " received");
        }
        PUBCOMP pubcomp = new PUBCOMP();
        pubcomp.messageId(command.messageId());
        this.sendToMQTT(pubcomp.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubComp(PUBCOMP command) {
        MessageAck ack;
        short messageId = command.messageId();
        Map<Short, MessageAck> map = this.consumerAcks;
        synchronized (map) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToActiveMQ(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActiveMQMessage convertMessage(PUBLISH command) throws JMSException {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        msg.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId());
        msg.setMessageId(id);
        msg.setTimestamp(System.currentTimeMillis());
        msg.setPriority((byte)4);
        msg.setPersistent(command.qos() != QoS.AT_MOST_ONCE);
        msg.setIntProperty("QoSPropertyName", command.qos().ordinal());
        ActiveMQTopic topic = null;
        Map<UTF8Buffer, ActiveMQTopic> map = this.activeMQTopicMap;
        synchronized (map) {
            topic = this.activeMQTopicMap.get(command.topicName());
            if (topic == null) {
                String topicName = command.topicName().toString().replaceAll("/", ".");
                topic = new ActiveMQTopic(topicName);
                this.activeMQTopicMap.put(command.topicName(), topic);
            }
        }
        msg.setJMSDestination(topic);
        msg.writeBytes(command.payload().data, command.payload().offset, command.payload().length);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PUBLISH convertMessage(ActiveMQMessage message) throws IOException, JMSException, DataFormatException {
        ActiveMQMessage msg;
        byte[] data;
        UTF8Buffer topicName;
        QoS qoS;
        PUBLISH result = new PUBLISH();
        short id = (short)message.getMessageId().getProducerSequenceId();
        result.messageId(id);
        if (message.propertyExists("QoSPropertyName")) {
            int ordinal = message.getIntProperty("QoSPropertyName");
            qoS = QoS.values()[ordinal];
        } else {
            qoS = message.isPersistent() ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE;
        }
        result.qos(qoS);
        Map<Destination, UTF8Buffer> map = this.mqttTopicMap;
        synchronized (map) {
            topicName = this.mqttTopicMap.get(message.getJMSDestination());
            if (topicName == null) {
                topicName = new UTF8Buffer(message.getDestination().getPhysicalName().replace('.', '/'));
                this.mqttTopicMap.put(message.getJMSDestination(), topicName);
            }
        }
        result.topicName(topicName);
        ByteSequence byteSequence = message.getContent();
        if (message.isCompressed()) {
            int read;
            Inflater inflater = new Inflater();
            inflater.setInput(byteSequence.data, byteSequence.offset, byteSequence.length);
            data = new byte[4096];
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            while ((read = inflater.inflate(data, 0, data.length)) != 0) {
                bytesOut.write(data, 0, read);
            }
            byteSequence = bytesOut.toByteSequence();
        }
        if (message.getDataStructureType() == 28) {
            if (byteSequence.getLength() > 4) {
                byte[] content = new byte[byteSequence.getLength() - 4];
                System.arraycopy(byteSequence.data, 4, content, 0, content.length);
                result.payload(new Buffer(content));
            } else {
                msg = (ActiveMQTextMessage)message.copy();
                String messageText = ((ActiveMQTextMessage)msg).getText();
                if (messageText != null) {
                    result.payload(new Buffer(((ActiveMQTextMessage)msg).getText().getBytes("UTF-8")));
                }
            }
        } else if (message.getDataStructureType() == 24) {
            msg = (ActiveMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            data = new byte[(int)((ActiveMQBytesMessage)msg).getBodyLength()];
            ((ActiveMQBytesMessage)msg).readBytes(data);
            result.payload(new Buffer(data));
        } else if (byteSequence != null && byteSequence.getLength() > 0) {
            result.payload(new Buffer(byteSequence.data, byteSequence.offset, byteSequence.length));
        }
        return result;
    }

    public MQTTTransport getMQTTTransport() {
        return this.mqttTransport;
    }

    public void onTransportError() {
        if (this.connect != null && this.connect.willTopic() != null && this.connect.willMessage() != null) {
            try {
                PUBLISH publish = new PUBLISH();
                publish.topicName(this.connect.willTopic());
                publish.qos(this.connect.willQos());
                publish.payload((Buffer)this.connect.willMessage());
                ActiveMQMessage message = this.convertMessage(publish);
                message.setProducerId(this.producerId);
                message.onSend();
                this.sendToActiveMQ(message, null);
            }
            catch (Exception e) {
                LOG.warn("Failed to publish Will Message " + this.connect.willMessage());
            }
        }
    }

    void configureInactivityMonitor(short heartBeat) {
        try {
            int heartBeatMS = heartBeat * 1000;
            MQTTInactivityMonitor monitor = this.getMQTTTransport().getInactivityMonitor();
            monitor.setProtocolConverter(this);
            monitor.setReadCheckTime(heartBeatMS);
            monitor.setInitialDelayTime(heartBeatMS);
            monitor.startMonitorThread();
        }
        catch (Exception ex) {
            LOG.warn("Failed to start MQTT InactivityMonitor ", ex);
        }
        LOG.debug(this.getClientId() + " MQTT Connection using heart beat of  " + heartBeat + " secs");
    }

    void handleException(Throwable exception, MQTTFrame command) {
        LOG.warn("Exception occurred processing: \n" + command + ": " + exception.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception detail", exception);
        }
        try {
            this.getMQTTTransport().stop();
        }
        catch (Throwable e) {
            LOG.error("Failed to stop MQTTT Transport ", e);
        }
    }

    void checkConnected() throws MQTTProtocolException {
        if (!this.connected.get()) {
            throw new MQTTProtocolException("Not connected.");
        }
    }

    private String getClientId() {
        if (this.clientId == null) {
            if (this.connect != null && this.connect.clientId() != null) {
                this.clientId = this.connect.clientId().toString();
            }
        } else {
            this.clientId = "";
        }
        return this.clientId;
    }

    private void stopTransport() {
        try {
            this.getMQTTTransport().stop();
        }
        catch (Throwable e) {
            LOG.debug("Failed to stop MQTT transport ", e);
        }
    }

    ResponseHandler createResponseHandler(final PUBLISH command) {
        if (command != null) {
            switch (command.qos()) {
                case AT_LEAST_ONCE: {
                    return new ResponseHandler(){

                        @Override
                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT Publish: ", command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBACK ack = new PUBACK();
                                ack.messageId(command.messageId());
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
                case EXACTLY_ONCE: {
                    return new ResponseHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT Publish: ", command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBREC ack = new PUBREC();
                                ack.messageId(command.messageId());
                                Map map = MQTTProtocolConverter.this.publisherRecs;
                                synchronized (map) {
                                    MQTTProtocolConverter.this.publisherRecs.put(command.messageId(), ack);
                                }
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
            }
        }
        return null;
    }

    private String convertMQTTToActiveMQ(String name) {
        String result = name.replace('>', '#');
        result = result.replace('*', '+');
        result = result.replace('.', '/');
        return result;
    }
}

