/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.console.command.store.ExportStreamManager;
import org.apache.activemq.console.command.store.proto.MessagePB;
import org.apache.activemq.console.command.store.proto.QueueEntryPB;
import org.apache.activemq.console.command.store.proto.QueuePB;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;

public class StoreExporter {
    static final int OPENWIRE_VERSION = 8;
    static final boolean TIGHT_ENCODING = false;
    URI config;
    File file;
    private final ObjectMapper mapper = new ObjectMapper();
    private final AsciiBuffer ds_kind = new AsciiBuffer("ds");
    private final AsciiBuffer ptp_kind = new AsciiBuffer("ptp");
    private final AsciiBuffer codec_id = new AsciiBuffer("openwire");
    private final OpenWireFormat wireformat = new OpenWireFormat();

    public StoreExporter() throws URISyntaxException {
        this.config = new URI("xbean:activemq.xml");
        this.wireformat.setCacheEnabled(false);
        this.wireformat.setTightEncodingEnabled(false);
        this.wireformat.setVersion(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        if (this.config == null) {
            throw new Exception("required --config option missing");
        }
        if (this.file == null) {
            throw new Exception("required --file option missing");
        }
        System.out.println("Loading: " + this.config);
        BrokerFactory.setStartDefault(false);
        BrokerService broker = BrokerFactory.createBroker(this.config);
        BrokerFactory.resetStartDefault();
        PersistenceAdapter store = broker.getPersistenceAdapter();
        System.out.println("Starting: " + store);
        store.start();
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.file));){
            this.export(store, fos);
        }
        finally {
            store.stop();
        }
    }

    void export(PersistenceAdapter store, BufferedOutputStream fos) throws Exception {
        final long[] messageKeyCounter = new long[]{0L};
        final long[] containerKeyCounter = new long[]{0L};
        final ExportStreamManager manager = new ExportStreamManager(fos, 1);
        final int[] preparedTxs = new int[]{0};
        store.createTransactionStore().recover(new TransactionRecoveryListener(){

            @Override
            public void recover(XATransactionId xid, Message[] addedMessages, MessageAck[] aks) {
                preparedTxs[0] = preparedTxs[0] + 1;
            }
        });
        if (preparedTxs[0] > 0) {
            throw new Exception("Cannot export a store with prepared XA transactions.  Please commit or rollback those transactions before attempting to export.");
        }
        for (ActiveMQDestination odest : store.getDestinations()) {
            ActiveMQDestination dest;
            containerKeyCounter[0] = containerKeyCounter[0] + 1L;
            if (odest instanceof ActiveMQQueue) {
                dest = (ActiveMQQueue)odest;
                MessageStore queue = store.createQueueMessageStore((ActiveMQQueue)dest);
                QueuePB.Bean destRecord = new QueuePB.Bean();
                destRecord.setKey(containerKeyCounter[0]);
                destRecord.setBindingKind(this.ptp_kind);
                final long[] seqKeyCounter = new long[]{0L};
                HashMap<String, String> jsonMap = new HashMap<String, String>();
                jsonMap.put("@class", "queue_destination");
                jsonMap.put("name", ((ActiveMQQueue)dest).getQueueName());
                String json = this.mapper.writeValueAsString(jsonMap);
                System.out.println(json);
                destRecord.setBindingData(new UTF8Buffer(json));
                manager.store_queue(destRecord);
                queue.recover(new MessageRecoveryListener(){

                    @Override
                    public boolean hasSpace() {
                        return true;
                    }

                    @Override
                    public boolean recoverMessageReference(MessageId ref) throws Exception {
                        return true;
                    }

                    @Override
                    public boolean isDuplicate(MessageId ref) {
                        return false;
                    }

                    @Override
                    public boolean recoverMessage(Message message) throws IOException {
                        messageKeyCounter[0] = messageKeyCounter[0] + 1L;
                        seqKeyCounter[0] = seqKeyCounter[0] + 1L;
                        MessagePB.Bean messageRecord = StoreExporter.this.createMessagePB(message, messageKeyCounter[0]);
                        manager.store_message(messageRecord);
                        QueueEntryPB.Bean entryRecord = StoreExporter.this.createQueueEntryPB(message, containerKeyCounter[0], seqKeyCounter[0], messageKeyCounter[0]);
                        manager.store_queue_entry(entryRecord);
                        return true;
                    }
                });
                continue;
            }
            if (!(odest instanceof ActiveMQTopic)) continue;
            dest = (ActiveMQTopic)odest;
            TopicMessageStore topic = store.createTopicMessageStore((ActiveMQTopic)dest);
            for (SubscriptionInfo sub : topic.getAllSubscriptions()) {
                QueuePB.Bean destRecord = new QueuePB.Bean();
                destRecord.setKey(containerKeyCounter[0]);
                destRecord.setBindingKind(this.ds_kind);
                HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                jsonMap.put("@class", "dsub_destination");
                jsonMap.put("name", sub.getClientId() + ":" + sub.getSubscriptionName());
                HashMap<String, String> jsonTopic = new HashMap<String, String>();
                jsonTopic.put("name", ((ActiveMQTopic)dest).getTopicName());
                jsonMap.put("topics", new Object[]{jsonTopic});
                if (sub.getSelector() != null) {
                    jsonMap.put("selector", sub.getSelector());
                }
                jsonMap.put("noLocal", sub.isNoLocal());
                String json = this.mapper.writeValueAsString(jsonMap);
                System.out.println(json);
                destRecord.setBindingData(new UTF8Buffer(json));
                manager.store_queue(destRecord);
                final long[] seqKeyCounter = new long[]{0L};
                topic.recoverSubscription(sub.getClientId(), sub.getSubscriptionName(), new MessageRecoveryListener(){

                    @Override
                    public boolean hasSpace() {
                        return true;
                    }

                    @Override
                    public boolean recoverMessageReference(MessageId ref) throws Exception {
                        return true;
                    }

                    @Override
                    public boolean isDuplicate(MessageId ref) {
                        return false;
                    }

                    @Override
                    public boolean recoverMessage(Message message) throws IOException {
                        messageKeyCounter[0] = messageKeyCounter[0] + 1L;
                        seqKeyCounter[0] = seqKeyCounter[0] + 1L;
                        MessagePB.Bean messageRecord = StoreExporter.this.createMessagePB(message, messageKeyCounter[0]);
                        manager.store_message(messageRecord);
                        QueueEntryPB.Bean entryRecord = StoreExporter.this.createQueueEntryPB(message, containerKeyCounter[0], seqKeyCounter[0], messageKeyCounter[0]);
                        manager.store_queue_entry(entryRecord);
                        return true;
                    }
                });
            }
        }
        manager.finish();
    }

    private QueueEntryPB.Bean createQueueEntryPB(Message message, long queueKey, long queueSeq, long messageKey) {
        QueueEntryPB.Bean entryRecord = new QueueEntryPB.Bean();
        entryRecord.setQueueKey(queueKey);
        entryRecord.setQueueSeq(queueSeq);
        entryRecord.setMessageKey(messageKey);
        entryRecord.setSize(message.getSize());
        if (message.getExpiration() != 0L) {
            entryRecord.setExpiration(message.getExpiration());
        }
        if (message.getRedeliveryCounter() != 0) {
            entryRecord.setRedeliveries(message.getRedeliveryCounter());
        }
        return entryRecord;
    }

    private MessagePB.Bean createMessagePB(Message message, long messageKey) throws IOException {
        DataByteArrayOutputStream mos = new DataByteArrayOutputStream();
        mos.writeBoolean(false);
        mos.writeVarInt(8);
        this.wireformat.marshal(message, mos);
        MessagePB.Bean messageRecord = new MessagePB.Bean();
        messageRecord.setCodec(this.codec_id);
        messageRecord.setMessageKey(messageKey);
        messageRecord.setSize(message.getSize());
        messageRecord.setValue(mos.toBuffer());
        return messageRecord;
    }

    public File getFilehandle() {
        return this.file;
    }

    public void setFile(String file) {
        this.setFilehandle(new File(file));
    }

    public void setFilehandle(File file) {
        this.file = file;
    }

    public URI getConfig() {
        return this.config;
    }

    public void setConfig(URI config) {
        this.config = config;
    }
}

