/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import jakarta.jms.Connection;
import jakarta.jms.InvalidClientIDException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkStealingTest {
    private static final Logger LOG = LoggerFactory.getLogger(LinkStealingTest.class);
    private BrokerService brokerService;
    private final AtomicReference<Throwable> removeException = new AtomicReference();
    private String stealableConnectionURI;
    private String unstealableConnectionURI;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
                LOG.info("Remove Connection called for connection [{}] with error: {}", (Object)info.getConnectionId(), (Object)error);
                LinkStealingTest.this.removeException.set(error);
                super.removeConnection(context, info, error);
            }
        }});
        this.stealableConnectionURI = this.brokerService.addConnector("tcp://0.0.0.0:0?allowLinkStealing=true").getPublishableConnectString();
        this.unstealableConnectionURI = this.brokerService.addConnector("tcp://0.0.0.0:0?allowLinkStealing=false").getPublishableConnectString();
        this.brokerService.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService = null;
        }
    }

    @Test(timeout=60000L)
    public void testStealLinkFails() throws Exception {
        String clientID = "ThisIsAClientId";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.unstealableConnectionURI);
        Connection connection1 = factory.createConnection();
        connection1.setClientID("ThisIsAClientId");
        connection1.start();
        try {
            Connection connection2 = factory.createConnection();
            connection2.setClientID("ThisIsAClientId");
            connection2.start();
            Assert.fail((String)"Should not have been able to steal the link.");
        }
        catch (InvalidClientIDException e) {
            LOG.info("Caught expected error on trying to steal link: {}", (Object)e.getMessage());
            LOG.trace("Error: ", (Throwable)e);
        }
    }

    @Test(timeout=60000L)
    public void testStealLinkSuccess() throws Exception {
        String clientID = "ThisIsAClientId";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.stealableConnectionURI);
        Connection connection1 = factory.createConnection();
        connection1.setClientID("ThisIsAClientId");
        connection1.start();
        try {
            Connection connection2 = factory.createConnection();
            connection2.setClientID("ThisIsAClientId");
            connection2.start();
        }
        catch (InvalidClientIDException e) {
            LOG.info("Should not have failed while stealing the link: {}", (Object)e.getMessage());
            LOG.info("Error details: ", (Throwable)e);
            Assert.fail((String)"Shouldn't have failed when stealing the link");
        }
        catch (Throwable error) {
            LOG.info("Unexpected exception ", error);
            Assert.fail((String)"Unexcpected exception causes test failure");
        }
        Assert.assertTrue((boolean)Wait.waitFor(new Wait.Condition(){

            @Override
            public boolean isSatisified() throws Exception {
                return LinkStealingTest.this.removeException.get() != null;
            }
        }, 5000L, 100L));
        LOG.info("removeException: {}", (Object)this.removeException.get().getMessage());
    }
}

