/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.Iterator;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.broker.region.cursors.OrderedPendingList;
import org.apache.activemq.broker.region.cursors.PendingList;
import org.apache.activemq.broker.region.cursors.PrioritizedPendingList;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStoreCursor
extends AbstractPendingMessageCursor
implements MessageRecoveryListener {
    private static final Log LOG = LogFactory.getLog(AbstractStoreCursor.class);
    protected final Destination regionDestination;
    private final PendingList batchList;
    private Iterator<MessageReference> iterator = null;
    private boolean cacheEnabled = false;
    protected boolean batchResetNeeded = true;
    protected boolean storeHasMessages = false;
    protected int size;
    private MessageId lastCachedId;

    protected AbstractStoreCursor(Destination destination) {
        super(destination != null ? destination.isPrioritizedMessages() : false);
        this.regionDestination = destination;
        this.batchList = this.prioritizedMessages ? new PrioritizedPendingList() : new OrderedPendingList();
    }

    public final synchronized void start() throws Exception {
        if (!this.isStarted()) {
            this.clear();
            super.start();
            this.resetBatch();
            this.size = this.getStoreSize();
            boolean bl = this.storeHasMessages = this.size > 0;
            if (!this.storeHasMessages && this.useCache) {
                this.cacheEnabled = true;
            }
        }
    }

    public final synchronized void stop() throws Exception {
        this.resetBatch();
        super.stop();
        this.gc();
    }

    public final boolean recoverMessage(Message message) throws Exception {
        return this.recoverMessage(message, false);
    }

    public synchronized boolean recoverMessage(Message message, boolean cached) throws Exception {
        boolean recovered = false;
        if (this.recordUniqueId(message.getMessageId())) {
            if (!cached) {
                message.setRegionDestination(this.regionDestination);
                if (message.getMemoryUsage() == null) {
                    message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                }
            }
            message.incrementReferenceCount();
            this.batchList.addMessageLast(message);
            this.clearIterator(true);
            recovered = true;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.regionDestination.getActiveMQDestination().getPhysicalName() + " cursor got duplicate: " + message));
            }
            this.storeHasMessages = true;
        }
        return recovered;
    }

    public final void reset() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.clearIterator(true);
        this.size();
    }

    public synchronized void release() {
        this.clearIterator(false);
    }

    private synchronized void clearIterator(boolean ensureIterator) {
        boolean haveIterator = this.iterator != null;
        this.iterator = null;
        this.last = null;
        if (haveIterator && ensureIterator) {
            this.ensureIterator();
        }
    }

    private synchronized void ensureIterator() {
        if (this.iterator == null) {
            this.iterator = this.batchList.iterator();
        }
    }

    public final void finished() {
    }

    public final synchronized boolean hasNext() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.ensureIterator();
        return this.iterator.hasNext();
    }

    public final synchronized MessageReference next() {
        MessageReference result = null;
        if (!this.batchList.isEmpty() && this.iterator.hasNext()) {
            result = this.iterator.next();
        }
        this.last = result;
        if (result != null) {
            result.incrementReferenceCount();
        }
        return result;
    }

    public final synchronized void addMessageLast(MessageReference node) throws Exception {
        if (this.cacheEnabled && this.hasSpace()) {
            this.recoverMessage(node.getMessage(), true);
            this.lastCachedId = node.getMessageId();
        } else if (this.cacheEnabled) {
            this.cacheEnabled = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.regionDestination.getActiveMQDestination().getPhysicalName() + " disabling cache on size:" + this.size + ", lastCachedIdSeq: " + (this.lastCachedId == null ? -1L : this.lastCachedId.getBrokerSequenceId()) + " current node seqId: " + node.getMessageId().getBrokerSequenceId()));
            }
            if (this.lastCachedId != null) {
                this.setBatch(this.lastCachedId);
            }
        }
        ++this.size;
    }

    protected void setBatch(MessageId messageId) throws Exception {
    }

    public final synchronized void addMessageFirst(MessageReference node) throws Exception {
        this.cacheEnabled = false;
        ++this.size;
    }

    public final synchronized void remove() {
        --this.size;
        if (this.iterator != null) {
            this.iterator.remove();
        }
        if (this.last != null) {
            this.last.decrementReferenceCount();
        }
        if (this.size == 0 && this.isStarted() && this.useCache && this.hasSpace() && this.isStoreEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.regionDestination.getActiveMQDestination().getPhysicalName() + " enabling cache on last remove"));
            }
            this.cacheEnabled = true;
        }
    }

    public final synchronized void remove(MessageReference node) {
        --this.size;
        this.cacheEnabled = false;
        this.batchList.remove(node);
    }

    public final synchronized void clear() {
        this.gc();
    }

    public final synchronized void gc() {
        Iterator<MessageReference> i = this.batchList.iterator();
        while (i.hasNext()) {
            MessageReference msg = i.next();
            this.rollback(msg.getMessageId());
            msg.decrementReferenceCount();
        }
        this.batchList.clear();
        this.clearIterator(false);
        this.batchResetNeeded = true;
        this.cacheEnabled = false;
        this.size = this.isStarted() ? this.getStoreSize() : 0;
    }

    protected final synchronized void fillBatch() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fillBatch - batchResetNeeded=" + this.batchResetNeeded + ", hasMessages=" + this.storeHasMessages + ", size=" + this.size));
        }
        if (this.batchResetNeeded) {
            this.resetBatch();
            this.batchResetNeeded = false;
        }
        if (this.batchList.isEmpty() && (this.storeHasMessages || this.size > 0)) {
            this.storeHasMessages = false;
            try {
                this.doFillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
            if (!this.batchList.isEmpty()) {
                this.storeHasMessages = true;
            }
        }
    }

    public final synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public final synchronized boolean hasMessagesBufferedToDeliver() {
        return !this.batchList.isEmpty();
    }

    public final synchronized int size() {
        if (this.size < 0) {
            this.size = this.getStoreSize();
        }
        return this.size;
    }

    protected abstract void doFillBatch() throws Exception;

    protected abstract void resetBatch();

    protected abstract int getStoreSize();

    protected abstract boolean isStoreEmpty();
}

