/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb.replicated.groups;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.concurrent.ConcurrentUtils;
import org.linkedin.util.io.PathUtils;
import org.linkedin.zookeeper.client.AbstractZKClient;
import org.linkedin.zookeeper.client.ChrootedZKClient;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.IZooKeeper;
import org.linkedin.zookeeper.client.IZooKeeperFactory;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.client.ZooKeeperFactory;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKClient
extends AbstractZKClient
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZKClient.class.getName());
    private Map<String, String> acls;
    private String password;
    private static final String CHARSET = "UTF-8";
    private final Clock _clock = SystemClock.instance();
    private final List<LifecycleListener> _listeners = new CopyOnWriteArrayList<LifecycleListener>();
    protected final Object _lock = new Object();
    protected volatile State _state = State.NONE;
    private final StateChangeDispatcher _stateChangeDispatcher = new StateChangeDispatcher();
    protected IZooKeeperFactory _factory;
    protected IZooKeeper _zk;
    protected Timespan _reconnectTimeout = Timespan.parse((String)"20s");
    protected Timespan sessionTimeout = new Timespan(30L, Timespan.TimeUnit.SECOND);
    private ExpiredSessionRecovery _expiredSessionRecovery = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            this._stateChangeDispatcher.setDaemon(true);
            this._stateChangeDispatcher.start();
            this.doStart();
        }
    }

    public void setACLs(Map<String, String> acls) {
        this.acls = acls;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected void doStart() throws InvalidSyntaxException, ConfigurationException, UnsupportedEncodingException {
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._stateChangeDispatcher != null) {
            this._stateChangeDispatcher.end();
            try {
                this._stateChangeDispatcher.join(1000L);
            }
            catch (Exception e) {
                LOG.debug("ignored exception", (Throwable)e);
            }
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._zk != null) {
                try {
                    this.changeState(State.NONE);
                    this._zk.close();
                    Thread th = this.getSendThread();
                    if (th != null) {
                        th.join(1000L);
                    }
                    this._zk = null;
                }
                catch (Exception e) {
                    LOG.debug("ignored exception", (Throwable)e);
                }
            }
        }
    }

    protected Thread getSendThread() {
        try {
            return (Thread)this.getField((Object)this._zk, "_zk", "cnxn", "sendThread");
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected Object getField(Object obj, String ... names) throws Exception {
        for (String name : names) {
            obj = this.getField(obj, name);
        }
        return obj;
    }

    protected Object getField(Object obj, String name) throws Exception {
        Class<?> clazz = obj.getClass();
        while (clazz != null) {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getName().equals(name)) continue;
                f.setAccessible(true);
                return f.get(obj);
            }
        }
        throw new NoSuchFieldError(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(State newState) {
        Object object = this._lock;
        synchronized (object) {
            State oldState = this._state;
            if (oldState != newState) {
                this._stateChangeDispatcher.addEvent(oldState, newState);
                this._state = newState;
                this._lock.notifyAll();
            }
        }
    }

    public void testGenerateConnectionLoss() throws Exception {
        this.waitForConnected();
        Object clientCnxnSocket = this.getField((Object)this._zk, "_zk", "cnxn", "sendThread", "clientCnxnSocket");
        this.callMethod(clientCnxnSocket, "testableCloseSocket", new Object[0]);
    }

    protected Object callMethod(Object obj, String name, Object ... args) throws Exception {
        Class<?> clazz = obj.getClass();
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(name)) continue;
                m.setAccessible(true);
                return m.invoke(obj, args);
            }
        }
        throw new NoSuchMethodError(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryConnect() {
        Object object = this._lock;
        synchronized (object) {
            block5: {
                try {
                    this.connect();
                }
                catch (Throwable e) {
                    LOG.warn("Error while restarting:", e);
                    if (this._expiredSessionRecovery != null) break block5;
                    this._expiredSessionRecovery = new ExpiredSessionRecovery();
                    this._expiredSessionRecovery.setDaemon(true);
                    this._expiredSessionRecovery.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws UnsupportedEncodingException {
        Object object = this._lock;
        synchronized (object) {
            this.changeState(State.CONNECTING);
            this._zk = this._factory.createZooKeeper((Watcher)this);
            if (this.password != null) {
                this._zk.addAuthInfo("digest", ("fabric:" + this.password).getBytes(CHARSET));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        if (event.getState() != null) {
            LOG.debug("event: {}", (Object)event.getState());
            Object object = this._lock;
            synchronized (object) {
                switch (event.getState()) {
                    case SyncConnected: {
                        this.changeState(State.CONNECTED);
                        break;
                    }
                    case Disconnected: {
                        if (this._state == State.NONE) break;
                        this.changeState(State.RECONNECTING);
                        break;
                    }
                    case Expired: {
                        this._zk = null;
                        LOG.warn("Expiration detected: trying to restart...");
                        this.tryConnect();
                        break;
                    }
                    default: {
                        LOG.warn("unprocessed event state: {}", (Object)event.getState());
                    }
                }
            }
        }
    }

    protected IZooKeeper getZk() {
        IZooKeeper zk;
        State state = this._state;
        if (state == State.NONE) {
            throw new IllegalStateException("ZooKeeper client has not been configured yet. You need to either create an ensemble or join one.");
        }
        if (state != State.CONNECTED) {
            try {
                this.waitForConnected();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error waiting for ZooKeeper connection", e);
            }
        }
        if ((zk = this._zk) == null) {
            throw new IllegalStateException("No ZooKeeper connection available");
        }
        return zk;
    }

    public void waitForConnected(Timespan timeout) throws InterruptedException, TimeoutException {
        this.waitForState(State.CONNECTED, timeout);
    }

    public void waitForConnected() throws InterruptedException, TimeoutException {
        this.waitForConnected(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(State state, Timespan timeout) throws TimeoutException, InterruptedException {
        long endTime = (timeout == null ? this.sessionTimeout : timeout).futureTimeMillis(this._clock);
        if (this._state != state) {
            Object object = this._lock;
            synchronized (object) {
                while (this._state != state) {
                    ConcurrentUtils.awaitUntil((Clock)this._clock, (Object)this._lock, (long)endTime);
                }
            }
        }
    }

    public void registerListener(LifecycleListener listener) {
        if (listener == null) {
            throw new IllegalStateException("listener is null");
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
        if (this._state == State.CONNECTED) {
            listener.onConnected();
        }
    }

    public void removeListener(LifecycleListener listener) {
        if (listener == null) {
            throw new IllegalStateException("listener is null");
        }
        this._listeners.remove(listener);
    }

    public IZKClient chroot(String path) {
        return new ChrootedZKClient((IZKClient)this, this.adjustPath(path));
    }

    public boolean isConnected() {
        return this._state == State.CONNECTED;
    }

    public boolean isConfigured() {
        return this._state != State.NONE;
    }

    public String getConnectString() {
        return this._factory.getConnectString();
    }

    protected Map<Object, Boolean> callListeners(Map<Object, Boolean> history, Boolean connectedEvent) {
        IdentityHashMap<Object, Boolean> newHistory = new IdentityHashMap<Object, Boolean>();
        for (LifecycleListener listener : this._listeners) {
            Boolean previousEvent = history.get(listener);
            if (previousEvent == null || previousEvent != connectedEvent) {
                try {
                    if (connectedEvent.booleanValue()) {
                        listener.onConnected();
                    } else {
                        listener.onDisconnected();
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Exception while executing listener (ignored)", e);
                }
            }
            newHistory.put(listener, connectedEvent);
        }
        return newHistory;
    }

    public ZKClient(String connectString, Timespan sessionTimeout, Watcher watcher) {
        this((IZooKeeperFactory)new ZooKeeperFactory(connectString, sessionTimeout, watcher));
    }

    public ZKClient(IZooKeeperFactory factory) {
        this(factory, null);
    }

    public ZKClient(IZooKeeperFactory factory, String chroot) {
        super(chroot);
        this._factory = factory;
        HashMap<String, String> acls = new HashMap<String, String>();
        acls.put("/", "world:anyone:acdrw");
        this.setACLs(acls);
    }

    private static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    System.err.println("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }

    private static List<ACL> parseACLs(String aclString) {
        String[] acls = aclString.split(",");
        ArrayList<ACL> acl = new ArrayList<ACL>();
        for (String a : acls) {
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                System.err.println(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(ZKClient.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    public Stat createOrSetByteWithParents(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException {
        if (this.exists(path) != null) {
            return this.setByteData(path, data);
        }
        try {
            this.createBytesNodeWithParents(path, data, acl, createMode);
            return null;
        }
        catch (KeeperException.NodeExistsException e) {
            return this.setByteData(path, data);
        }
    }

    public String create(String path, CreateMode createMode) throws InterruptedException, KeeperException {
        return this.create(path, (byte[])null, createMode);
    }

    public String create(String path, String data, CreateMode createMode) throws InterruptedException, KeeperException {
        return this.create(path, this.toByteData(data), createMode);
    }

    public String create(String path, byte[] data, CreateMode createMode) throws InterruptedException, KeeperException {
        return this.getZk().create(this.adjustPath(path), data, this.getNodeACLs(path), createMode);
    }

    public String createWithParents(String path, CreateMode createMode) throws InterruptedException, KeeperException {
        return this.createWithParents(path, (byte[])null, createMode);
    }

    public String createWithParents(String path, String data, CreateMode createMode) throws InterruptedException, KeeperException {
        return this.createWithParents(path, this.toByteData(data), createMode);
    }

    public String createWithParents(String path, byte[] data, CreateMode createMode) throws InterruptedException, KeeperException {
        this.createParents(path);
        return this.create(path, data, createMode);
    }

    public Stat createOrSetWithParents(String path, String data, CreateMode createMode) throws InterruptedException, KeeperException {
        return this.createOrSetWithParents(path, this.toByteData(data), createMode);
    }

    public Stat createOrSetWithParents(String path, byte[] data, CreateMode createMode) throws InterruptedException, KeeperException {
        if (this.exists(path) != null) {
            return this.setByteData(path, data);
        }
        try {
            this.createWithParents(path, data, createMode);
            return null;
        }
        catch (KeeperException.NodeExistsException e) {
            return this.setByteData(path, data);
        }
    }

    public void fixACLs(String path, boolean recursive) throws InterruptedException, KeeperException {
        if (this.exists(path) != null) {
            this.doFixACLs(path, recursive);
        }
    }

    private void doFixACLs(String path, boolean recursive) throws KeeperException, InterruptedException {
        this.setACL(path, this.getNodeACLs(path), -1);
        if (recursive) {
            for (String child : this.getChildren(path)) {
                this.doFixACLs(path.equals("/") ? "/" + child : path + "/" + child, recursive);
            }
        }
    }

    private List<ACL> getNodeACLs(String path) {
        String acl = this.doGetNodeACLs(this.adjustPath(path));
        if (acl == null) {
            throw new IllegalStateException("Could not find matching ACLs for " + path);
        }
        return ZKClient.parseACLs(acl);
    }

    protected String doGetNodeACLs(String path) {
        String longestPath = "";
        for (String acl : this.acls.keySet()) {
            if (acl.length() <= longestPath.length() || !path.startsWith(acl)) continue;
            longestPath = acl;
        }
        return this.acls.get(longestPath);
    }

    private void createParents(String path) throws InterruptedException, KeeperException {
        path = PathUtils.getParentPath((String)this.adjustPath(path));
        path = PathUtils.removeTrailingSlash((String)path);
        ArrayList<String> paths = new ArrayList<String>();
        while (!path.equals("") && this.getZk().exists(path, false) == null) {
            paths.add(path);
            path = PathUtils.getParentPath((String)path);
            path = PathUtils.removeTrailingSlash((String)path);
        }
        Collections.reverse(paths);
        for (String p : paths) {
            try {
                this.getZk().create(p, null, this.getNodeACLs(p), CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("parent already exists " + p);
            }
        }
    }

    private byte[] toByteData(String data) {
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private class ExpiredSessionRecovery
    extends Thread {
        private ExpiredSessionRecovery() {
            super("ZooKeeper expired session recovery thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            LOG.info("Entering recovery mode");
            Object object = ZKClient.this._lock;
            synchronized (object) {
                try {
                    int count = 0;
                    while (ZKClient.this._state == State.NONE) {
                        try {
                            LOG.warn("Recovery mode: trying to reconnect to zookeeper [" + ++count + "]");
                            ZKClient.this.connect();
                        }
                        catch (Throwable e) {
                            LOG.warn("Recovery mode: reconnect attempt failed [" + count + "]... waiting for " + ZKClient.this._reconnectTimeout, e);
                            try {
                                ZKClient.this._lock.wait(ZKClient.this._reconnectTimeout.getDurationInMilliseconds());
                            }
                            catch (InterruptedException e1) {
                                throw new RuntimeException("Recovery mode: wait interrupted... bailing out", e1);
                            }
                        }
                    }
                    return;
                }
                finally {
                    ZKClient.this._expiredSessionRecovery = null;
                    LOG.info("Exiting recovery mode.");
                }
            }
        }
    }

    private class StateChangeDispatcher
    extends Thread {
        private final AtomicBoolean _running;
        private final BlockingQueue<Boolean> _events;

        private StateChangeDispatcher() {
            super("ZooKeeper state change dispatcher thread");
            this._running = new AtomicBoolean(true);
            this._events = new LinkedBlockingQueue<Boolean>();
        }

        @Override
        public void run() {
            Map<Object, Boolean> history = new IdentityHashMap<Object, Boolean>();
            LOG.info("Starting StateChangeDispatcher");
            while (this._running.get()) {
                Boolean isConnectedEvent;
                try {
                    isConnectedEvent = this._events.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (!this._running.get() || isConnectedEvent == null) continue;
                Map<Object, Boolean> newHistory = ZKClient.this.callListeners(history, isConnectedEvent);
                history = newHistory;
            }
            LOG.info("StateChangeDispatcher terminated.");
        }

        public void end() {
            this._running.set(false);
            this._events.add(false);
        }

        public void addEvent(State oldState, State newState) {
            LOG.debug("addEvent: {} => {}", (Object)oldState, (Object)newState);
            if (newState == State.CONNECTED) {
                this._events.add(true);
            } else if (oldState == State.CONNECTED) {
                this._events.add(false);
            }
        }
    }

    public static enum State {
        NONE,
        CONNECTING,
        CONNECTED,
        RECONNECTING;

    }
}

