/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.openwire.tool.CHeadersGenerator;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JAnnotationValue;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;

public class CSourcesGenerator
extends CHeadersGenerator {
    @Override
    public Object run() {
        this.filePostFix = ".c";
        if (this.destFile == null) {
            this.destFile = new File(this.targetDir + "/ow_commands_v" + this.getOpenwireVersion() + ".c");
        }
        return super.run();
    }

    @Override
    protected List<JClass> sort(List<JClass> source) {
        return source;
    }

    @Override
    protected void generateSetup(PrintWriter out) {
        this.generateLicence(out);
        out.println("");
        out.println("/*****************************************************************************************");
        out.println(" *  ");
        out.println(" * NOTE!: This file is auto generated - do not modify!");
        out.println(" *        if you need to make a change, please see the modify the groovy scripts in the");
        out.println(" *        under src/gram/script and then use maven openwire:generate to regenerate ");
        out.println(" *        this file.");
        out.println(" *  ");
        out.println(" *****************************************************************************************/");
        out.println("");
        out.println("");
        out.println("#include \"ow_commands_v" + this.openwireVersion + ".h\"");
        out.println("");
        out.println("#define SUCCESS_CHECK( f ) { apr_status_t rc=f; if(rc!=APR_SUCCESS) return rc; }");
        out.println("");
    }

    @Override
    protected void generateFile(PrintWriter out) throws Exception {
        String propname;
        JAnnotation annotation;
        ArrayList<JProperty> properties = new ArrayList<JProperty>();
        this.jclass.getDeclaredProperties();
        for (int i = 0; i < this.jclass.getDeclaredProperties().length; ++i) {
            JProperty p = this.jclass.getDeclaredProperties()[i];
            if (!this.isValidProperty(p)) continue;
            properties.add(p);
        }
        String name = this.jclass.getSimpleName();
        Object type = ("ow_" + name).toUpperCase() + "_TYPE";
        String baseName = "DataStructure";
        JClass superclass = this.jclass.getSuperclass();
        while (superclass.getSuperclass() != null) {
            if (this.sortedClasses.contains(superclass)) {
                baseName = superclass.getSimpleName();
                break;
            }
            superclass = superclass.getSuperclass();
        }
        out.println("ow_boolean ow_is_a_" + name + "(ow_DataStructure *object) {");
        out.println("   if( object == 0 )");
        out.println("      return 0;");
        out.println("      ");
        out.println("   switch(object->structType) {");
        for (JClass sub : this.sortedClasses) {
            String subtype = "OW_" + sub.getSimpleName().toUpperCase() + "_TYPE";
            if (!this.jclass.isAssignableFrom(sub) || this.isAbstract(sub)) continue;
            out.println("");
            out.println("   case " + subtype + ":");
        }
        out.println("");
        out.println("      return 1;");
        out.println("   }");
        out.println("   return 0;");
        out.println("}");
        if (!this.isAbstract(this.jclass)) {
            out.println("");
            out.println("");
            out.println("ow_" + name + " *ow_" + name + "_create(apr_pool_t *pool) ");
            out.println("{");
            out.println("   ow_" + name + " *value = apr_pcalloc(pool,sizeof(ow_" + name + "));");
            out.println("   if( value!=0 ) {");
            out.println("      ((ow_DataStructure*)value)->structType = " + (String)type + ";");
            out.println("   }");
            out.println("   return value;");
            out.println("}");
        }
        out.println("");
        out.println("");
        out.println("apr_status_t ow_marshal1_" + name + "(ow_bit_buffer *buffer, ow_" + name + " *object)");
        out.println("{");
        out.println("   ow_marshal1_" + baseName + "(buffer, (ow_" + baseName + "*)object);");
        for (JProperty property : properties) {
            String propname2 = this.toPropertyCase(property.getSimpleName());
            boolean cached = this.isCachedProperty(property);
            JAnnotation annotation2 = property.getGetter().getAnnotation("openwire:property");
            JAnnotationValue size = annotation2.getValue("size");
            type = property.getType().getQualifiedName();
            if (((String)type).equals("boolean")) {
                out.println("   ow_bit_buffer_append(buffer, object->" + propname2 + ");");
            } else if (!(((String)type).equals("byte") || ((String)type).equals("char") || ((String)type).equals("short") || ((String)type).equals("int"))) {
                if (((String)type).equals("long")) {
                    out.println("   ow_marshal1_long(buffer, object->" + propname2 + ");");
                } else if (((String)type).equals("byte[]")) {
                    if (size == null) {
                        out.println("   ow_bit_buffer_append(buffer,  object->" + propname2 + "!=0 );");
                    }
                } else if (((String)type).equals("org.apache.activeio.packet.ByteSequence")) {
                    if (size == null) {
                        out.println("   ow_bit_buffer_append(buffer,  object->" + propname2 + "!=0 );");
                    }
                } else if (((String)type).equals("java.lang.String")) {
                    out.println("   ow_marshal1_string(buffer, object->" + propname2 + ");");
                } else if (property.getType().isArrayType()) {
                    if (size != null) {
                        out.println("   SUCCESS_CHECK(ow_marshal1_DataStructure_array_const_size(buffer, object->" + propname2 + ", " + size.asInt() + "));");
                    } else {
                        out.println("   SUCCESS_CHECK(ow_marshal1_DataStructure_array(buffer, object->" + propname2 + "));");
                    }
                } else if (this.isThrowable(property.getType())) {
                    out.println("   SUCCESS_CHECK(ow_marshal1_throwable(buffer, object->" + propname2 + "));");
                } else if (cached) {
                    out.println("   SUCCESS_CHECK(ow_marshal1_cached_object(buffer, (ow_DataStructure*)object->" + propname2 + "));");
                } else {
                    out.println("   SUCCESS_CHECK(ow_marshal1_nested_object(buffer, (ow_DataStructure*)object->" + propname2 + "));");
                }
            }
            out.println("");
        }
        out.println("   ");
        out.println("   return APR_SUCCESS;");
        out.println("}");
        out.println("apr_status_t ow_marshal2_" + name + "(ow_byte_buffer *buffer, ow_bit_buffer *bitbuffer, ow_" + name + " *object)");
        out.println("{");
        out.println("   ow_marshal2_" + baseName + "(buffer, bitbuffer, (ow_" + baseName + "*)object);   ");
        for (JProperty property : properties) {
            annotation = property.getGetter().getAnnotation("openwire:property");
            JAnnotationValue size = annotation.getValue("size");
            propname = this.toPropertyCase(property.getSimpleName());
            boolean cached = this.isCachedProperty(property);
            type = property.getType().getQualifiedName();
            if (((String)type).equals("boolean")) {
                out.println("   ow_bit_buffer_read(bitbuffer);");
            } else if (((String)type).equals("byte")) {
                out.println("   SUCCESS_CHECK(ow_byte_buffer_append_" + (String)type + "(buffer, object->" + propname + "));");
            } else if (((String)type).equals("char")) {
                out.println("   SUCCESS_CHECK(ow_byte_buffer_append_" + (String)type + "(buffer, object->" + propname + "));");
            } else if (((String)type).equals("short")) {
                out.println("   SUCCESS_CHECK(ow_byte_buffer_append_" + (String)type + "(buffer, object->" + propname + "));");
            } else if (((String)type).equals("int")) {
                out.println("   SUCCESS_CHECK(ow_byte_buffer_append_" + (String)type + "(buffer, object->" + propname + "));");
            } else if (((String)type).equals("long")) {
                out.println("   SUCCESS_CHECK(ow_marshal2_long(buffer, bitbuffer, object->" + propname + "));");
            } else if (((String)type).equals("byte[]")) {
                if (size != null) {
                    out.println("   SUCCESS_CHECK(ow_marshal2_byte_array_const_size(buffer, object->" + propname + ", " + size.asInt() + "));");
                } else {
                    out.println("   SUCCESS_CHECK(ow_marshal2_byte_array(buffer, bitbuffer, object->" + propname + "));");
                }
            } else if (((String)type).equals("org.apache.activeio.packet.ByteSequence")) {
                if (size != null) {
                    out.println("   SUCCESS_CHECK(ow_marshal2_byte_array_const_size(buffer, object->" + propname + ", " + size.asInt() + "));");
                } else {
                    out.println("   SUCCESS_CHECK(ow_marshal2_byte_array(buffer, bitbuffer, object->" + propname + "));");
                }
            } else if (((String)type).equals("java.lang.String")) {
                out.println("   SUCCESS_CHECK(ow_marshal2_string(buffer, bitbuffer, object->" + propname + "));");
            } else if (property.getType().isArrayType()) {
                if (size != null) {
                    out.println("   SUCCESS_CHECK(ow_marshal2_DataStructure_array_const_size(buffer, bitbuffer, object->" + propname + ", " + size.asInt() + "));");
                } else {
                    out.println("   SUCCESS_CHECK(ow_marshal2_DataStructure_array(buffer, bitbuffer, object->" + propname + "));");
                }
            } else if (this.isThrowable(property.getType())) {
                out.println("   SUCCESS_CHECK(ow_marshal2_throwable(buffer, bitbuffer, object->" + propname + "));");
            } else if (cached) {
                out.println("   SUCCESS_CHECK(ow_marshal2_cached_object(buffer, bitbuffer, (ow_DataStructure*)object->" + propname + "));");
            } else {
                out.println("   SUCCESS_CHECK(ow_marshal2_nested_object(buffer, bitbuffer, (ow_DataStructure*)object->" + propname + "));");
            }
            out.println("");
        }
        out.println("   ");
        out.println("   return APR_SUCCESS;");
        out.println("}");
        out.println("");
        out.println("apr_status_t ow_unmarshal_" + name + "(ow_byte_array *buffer, ow_bit_buffer *bitbuffer, ow_" + name + " *object, apr_pool_t *pool)");
        out.println("{");
        out.println("   ow_unmarshal_" + baseName + "(buffer, bitbuffer, (ow_" + baseName + "*)object, pool);   ");
        for (JProperty property : properties) {
            annotation = property.getGetter().getAnnotation("openwire:property");
            JAnnotationValue size = annotation.getValue("size");
            propname = this.toPropertyCase(property.getSimpleName());
            boolean cached = this.isCachedProperty(property);
            type = property.getType().getQualifiedName();
            if (((String)type).equals("boolean")) {
                out.println("   object->" + propname + " = ow_bit_buffer_read(bitbuffer);");
            } else if (((String)type).equals("byte")) {
                out.println("   SUCCESS_CHECK(ow_byte_array_read_" + (String)type + "(buffer, &object->" + propname + "));");
            } else if (((String)type).equals("char")) {
                out.println("   SUCCESS_CHECK(ow_byte_array_read_" + (String)type + "(buffer, &object->" + propname + "));");
            } else if (((String)type).equals("short")) {
                out.println("   SUCCESS_CHECK(ow_byte_array_read_" + (String)type + "(buffer, &object->" + propname + "));");
            } else if (((String)type).equals("int")) {
                out.println("   SUCCESS_CHECK(ow_byte_array_read_" + (String)type + "(buffer, &object->" + propname + "));");
            } else if (((String)type).equals("long")) {
                out.println("   SUCCESS_CHECK(ow_unmarshal_long(buffer, bitbuffer, &object->" + propname + ", pool));");
            } else if (((String)type).equals("byte[]")) {
                if (size != null) {
                    out.println("   SUCCESS_CHECK(ow_unmarshal_byte_array_const_size(buffer, &object->" + propname + ", " + size.asInt() + ", pool));");
                } else {
                    out.println("   SUCCESS_CHECK(ow_unmarshal_byte_array(buffer, bitbuffer, &object->" + propname + ", pool));");
                }
            } else if (((String)type).equals("org.apache.activeio.packet.ByteSequence")) {
                if (size != null) {
                    out.println("   SUCCESS_CHECK(ow_unmarshal_byte_array_const_size(buffer, &object->" + propname + ", " + size.asInt() + ", pool));");
                } else {
                    out.println("   SUCCESS_CHECK(ow_unmarshal_byte_array(buffer, bitbuffer, &object->" + propname + ", pool));");
                }
            } else if (((String)type).equals("java.lang.String")) {
                out.println("   SUCCESS_CHECK(ow_unmarshal_string(buffer, bitbuffer, &object->" + propname + ", pool));");
            } else if (property.getType().isArrayType()) {
                if (size != null) {
                    out.println("   SUCCESS_CHECK(ow_unmarshal_DataStructure_array_const_size(buffer, bitbuffer, &object->" + propname + ", " + size.asInt() + ", pool));");
                } else {
                    out.println("   SUCCESS_CHECK(ow_unmarshal_DataStructure_array(buffer, bitbuffer, &object->" + propname + ", pool));");
                }
            } else if (this.isThrowable(property.getType())) {
                out.println("   SUCCESS_CHECK(ow_unmarshal_throwable(buffer, bitbuffer, &object->" + propname + ", pool));");
            } else if (cached) {
                out.println("   SUCCESS_CHECK(ow_unmarshal_cached_object(buffer, bitbuffer, (ow_DataStructure**)&object->" + propname + ", pool));");
            } else {
                out.println("   SUCCESS_CHECK(ow_unmarshal_nested_object(buffer, bitbuffer, (ow_DataStructure**)&object->" + propname + ", pool));");
            }
            out.println("");
        }
        out.println("   ");
        out.println("   return APR_SUCCESS;");
        out.println("}");
    }

    @Override
    protected void generateTearDown(PrintWriter out) {
        String type;
        String name;
        out.println("");
        out.println("ow_DataStructure *ow_create_object(ow_byte type, apr_pool_t *pool)");
        out.println("{");
        out.println("   switch( type ) {");
        for (JClass jclass : this.sortedClasses) {
            name = jclass.getSimpleName();
            type = ("ow_" + name).toUpperCase() + "_TYPE";
            if (this.isAbstract(jclass)) continue;
            out.println("      case " + type + ": return (ow_DataStructure *)ow_" + name + "_create(pool);");
        }
        out.println("");
        out.println("   }");
        out.println("   return 0;");
        out.println("}");
        out.println("");
        out.println("apr_status_t ow_marshal1_object(ow_bit_buffer *buffer, ow_DataStructure *object)");
        out.println("{");
        out.println("   switch( object->structType ) {");
        for (JClass jclass : this.sortedClasses) {
            name = jclass.getSimpleName();
            type = ("ow_" + name).toUpperCase() + "_TYPE";
            if (this.isAbstract(jclass)) continue;
            out.println("      case " + type + ": return ow_marshal1_" + name + "(buffer, (ow_" + name + "*)object);");
        }
        out.println("");
        out.println("   }");
        out.println("   return APR_EGENERAL;");
        out.println("}");
        out.println("");
        out.println("apr_status_t ow_marshal2_object(ow_byte_buffer *buffer, ow_bit_buffer *bitbuffer, ow_DataStructure *object)");
        out.println("{");
        out.println("   switch( object->structType ) {");
        for (JClass jclass : this.sortedClasses) {
            name = jclass.getSimpleName();
            type = ("ow_" + name).toUpperCase() + "_TYPE";
            if (this.isAbstract(jclass)) continue;
            out.println("      case " + type + ": return ow_marshal2_" + name + "(buffer, bitbuffer, (ow_" + name + "*)object);");
        }
        out.println("");
        out.println("   }");
        out.println("   return APR_EGENERAL;");
        out.println("}");
        out.println("");
        out.println("apr_status_t ow_unmarshal_object(ow_byte_array *buffer, ow_bit_buffer *bitbuffer, ow_DataStructure *object, apr_pool_t *pool)");
        out.println("{");
        out.println("   switch( object->structType ) {");
        for (JClass jclass : this.sortedClasses) {
            name = jclass.getSimpleName();
            type = ("ow_" + name).toUpperCase() + "_TYPE";
            if (this.isAbstract(jclass)) continue;
            out.println("      case " + type + ": return ow_unmarshal_" + name + "(buffer, bitbuffer, (ow_" + name + "*)object, pool);");
        }
        out.println("");
        out.println("   }");
        out.println("   return APR_EGENERAL;");
        out.println("}");
    }
}

