/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.xml;

import java.util.Map;
import org.linkedin.util.xml.AbstractXMLBuilder;
import org.linkedin.util.xml.XMLUtils;

public class XML
extends AbstractXMLBuilder {
    private final StringBuilder _xml = new StringBuilder();

    @Override
    public void addXMLDecl(String versionInfo) {
        XML.addXMLDecl(this._xml, versionInfo);
    }

    static void addXMLDecl(StringBuilder xml, String versionInfo) {
        xml.append("<?xml version=\"").append(versionInfo).append("\"?>\n");
    }

    @Override
    public void addXMLDecl(String versionInfo, String encoding, boolean standalone) {
        this._xml.append("<?xml version=\"").append(versionInfo);
        this._xml.append("\" encoding=\"");
        this._xml.append(encoding).append("\" standalone=\"");
        this._xml.append(standalone ? "yes" : "no");
        this._xml.append("\"?>\n");
    }

    @Override
    public void addOpeningTag(String tagName) {
        this._xml.append('<').append(tagName).append('>');
    }

    @Override
    public void addClosingTag(String tagName) {
        this._xml.append("</").append(tagName).append('>');
    }

    @Override
    public void addEmptyTag(String tagName) {
        this._xml.append('<').append(tagName).append(" />");
    }

    @Override
    public void addTag(String tagName, String tagValue) {
        if (tagValue == null) {
            this.addEmptyTag(tagName);
        } else {
            this.addOpeningTag(tagName);
            this._xml.append(XMLUtils.xmlEncode(tagValue));
            this.addClosingTag(tagName);
        }
    }

    @Override
    public void addXML(String xml) {
        this._xml.append(xml);
    }

    @Override
    public String getXML() {
        return this._xml.toString();
    }

    @Override
    public void reset() {
        this._xml.setLength(0);
    }

    @Override
    public void addEmptyTag(String tagName, Map attributes) {
        this._xml.append('<').append(tagName);
        this.addAttributes(attributes);
        this._xml.append(" />");
    }

    @Override
    public void addEmptyTag(String tagName, String attrName, String attrValue) {
        this._xml.append('<').append(tagName);
        this.addAttribute(attrName, attrValue);
        this._xml.append(" />");
    }

    @Override
    public void addOpeningTag(String tagName, Map attributes) {
        this._xml.append('<').append(tagName);
        this.addAttributes(attributes);
        this._xml.append('>');
    }

    @Override
    public void addOpeningTag(String tagName, String attrName, String attrValue) {
        this._xml.append('<').append(tagName);
        this.addAttribute(attrName, attrValue);
        this._xml.append('>');
    }

    @Override
    public void addTag(String tagName, String tagValue, Map attributes) {
        if (tagValue == null) {
            this.addEmptyTag(tagName, attributes);
        } else {
            this.addOpeningTag(tagName, attributes);
            this._xml.append(XMLUtils.xmlEncode(tagValue));
            this.addClosingTag(tagName);
        }
    }

    @Override
    public void addTag(String tagName, String tagValue, String attrName, String attrValue) {
        if (tagValue == null) {
            this.addEmptyTag(tagName, attrName, attrValue);
        } else {
            this.addOpeningTag(tagName, attrName, attrValue);
            this._xml.append(XMLUtils.xmlEncode(tagValue));
            this.addClosingTag(tagName);
        }
    }

    private void addAttribute(String attrName, String attrValue) {
        if (attrName == null) {
            return;
        }
        this._xml.append(' ');
        this._xml.append(attrName).append("=\"");
        this._xml.append(XMLUtils.xmlEncode(attrValue)).append('\"');
    }

    private void addAttributes(Map attributes) {
        if (attributes == null) {
            return;
        }
        for (String attrName : attributes.keySet()) {
            Object attrValue = attributes.get(attrName);
            if (attrValue == null) continue;
            this.addAttribute(attrName, attrValue.toString());
        }
    }
}

