/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.TestSupport;

public class JmsAutoAckTest
extends TestSupport {
    private Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    public void testAckedMessageAreConsumed() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("test");
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsAutoAckTest.assertNotNull((Object)msg);
        session.close();
        session = this.connection.createSession(false, 1);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        JmsAutoAckTest.assertNull((Object)msg);
        session.close();
    }
}

