/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import jakarta.jms.TemporaryTopic;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.advisory.ConsumerEvent;
import org.apache.activemq.advisory.ConsumerEventSource;
import org.apache.activemq.advisory.ConsumerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerListenerTest
extends EmbeddedBrokerTestSupport
implements ConsumerListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerListenerTest.class);
    protected Session consumerSession1;
    protected Session consumerSession2;
    protected int consumerCounter;
    protected ConsumerEventSource consumerEventSource;
    protected BlockingQueue<ConsumerEvent> eventQueue = new ArrayBlockingQueue<ConsumerEvent>(1000);
    private Connection connection;

    public void testConsumerEvents() throws Exception {
        this.consumerEventSource.start();
        this.consumerSession1 = this.createConsumer();
        this.assertConsumerEvent(1, true);
        this.consumerSession2 = this.createConsumer();
        this.assertConsumerEvent(2, true);
        this.consumerSession1.close();
        this.consumerSession1 = null;
        this.assertConsumerEvent(1, false);
        this.consumerSession2.close();
        this.consumerSession2 = null;
        this.assertConsumerEvent(0, false);
    }

    public void testListenWhileAlreadyConsumersActive() throws Exception {
        this.consumerSession1 = this.createConsumer();
        this.consumerSession2 = this.createConsumer();
        this.consumerEventSource.start();
        this.assertConsumerEvent(2, true);
        this.assertConsumerEvent(2, true);
        this.consumerSession1.close();
        this.consumerSession1 = null;
        this.assertConsumerEvent(1, false);
        this.consumerSession2.close();
        this.consumerSession2 = null;
        this.assertConsumerEvent(0, false);
    }

    public void testConsumerEventsOnTemporaryDestination() throws Exception {
        Session s = this.connection.createSession(true, 1);
        TemporaryTopic dest = this.useTopic ? s.createTemporaryTopic() : s.createTemporaryQueue();
        this.consumerEventSource = new ConsumerEventSource(this.connection, (Destination)dest);
        this.consumerEventSource.setConsumerListener((ConsumerListener)this);
        this.consumerEventSource.start();
        MessageConsumer consumer = s.createConsumer((Destination)dest);
        this.assertConsumerEvent(1, true);
        consumer.close();
        this.assertConsumerEvent(0, false);
    }

    public void onConsumerEvent(ConsumerEvent event) {
        this.eventQueue.add(event);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        this.consumerEventSource = new ConsumerEventSource(this.connection, (Destination)this.destination);
        this.consumerEventSource.setConsumerListener((ConsumerListener)this);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.consumerEventSource != null) {
            this.consumerEventSource.stop();
        }
        if (this.consumerSession2 != null) {
            this.consumerSession2.close();
        }
        if (this.consumerSession1 != null) {
            this.consumerSession1.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected void assertConsumerEvent(int count, boolean started) throws InterruptedException {
        ConsumerEvent event = this.waitForConsumerEvent();
        ConsumerListenerTest.assertEquals((String)"Consumer count", (int)count, (int)event.getConsumerCount());
        ConsumerListenerTest.assertEquals((String)"started", (boolean)started, (boolean)event.isStarted());
    }

    protected Session createConsumer() throws JMSException {
        final String consumerText = "Consumer: " + ++this.consumerCounter;
        LOG.info("Creating consumer: " + consumerText + " on destination: " + this.destination);
        Session answer = this.connection.createSession(false, 1);
        MessageConsumer consumer = answer.createConsumer((Destination)this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.info("Received message by: " + consumerText + " message: " + message);
            }
        });
        return answer;
    }

    protected ConsumerEvent waitForConsumerEvent() throws InterruptedException {
        ConsumerEvent answer = this.eventQueue.poll(100000L, TimeUnit.MILLISECONDS);
        ConsumerListenerTest.assertTrue((String)"Should have received a consumer event!", (answer != null ? 1 : 0) != 0);
        return answer;
    }
}

