/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.AbortSlowConsumer0Test;
import org.apache.activemq.broker.region.policy.AbortSlowAckConsumerStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SlowConsumerStrategy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AbortSlowAckConsumer0Test
extends AbortSlowConsumer0Test {
    protected long maxTimeSinceLastAck = 5000L;
    protected AbortSlowAckConsumerStrategy strategy;

    @Parameterized.Parameters(name="isTopic({0})")
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.TRUE}, {Boolean.FALSE});
    }

    public AbortSlowAckConsumer0Test(Boolean isTopic) {
        this.topic = isTopic;
    }

    protected AbortSlowAckConsumerStrategy createSlowConsumerStrategy() {
        AbortSlowAckConsumerStrategy strategy = new AbortSlowAckConsumerStrategy();
        strategy.setAbortConnection(this.abortConnection);
        strategy.setCheckPeriod(this.checkPeriod);
        strategy.setMaxSlowDuration(this.maxSlowDuration);
        strategy.setMaxTimeSinceLastAck(this.maxTimeSinceLastAck);
        return strategy;
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        this.strategy = this.createSlowConsumerStrategy();
        this.underTest = this.strategy;
        policy.setSlowConsumerStrategy((SlowConsumerStrategy)this.strategy);
        policy.setQueuePrefetch(10);
        policy.setTopicPrefetch(10);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        factory.getPrefetchPolicy().setAll(1);
        return factory;
    }

    @Override
    @Test
    public void testSlowConsumerIsAbortedViaJmx() throws Exception {
        this.strategy.setMaxTimeSinceLastAck(500L);
        super.testSlowConsumerIsAbortedViaJmx();
    }

    @Test
    public void testZeroPrefetchConsumerIsAborted() throws Exception {
        this.strategy.setMaxTimeSinceLastAck(2000L);
        ActiveMQConnection conn = (ActiveMQConnection)this.createConnectionFactory().createConnection();
        conn.setExceptionListener((ExceptionListener)this);
        this.connections.add(conn);
        Session sess = conn.createSession(false, 2);
        MessageConsumer consumer = sess.createConsumer(this.destination);
        Assert.assertNotNull((Object)consumer);
        conn.start();
        this.startProducers(this.destination, 20);
        Message message = consumer.receive(5000L);
        Assert.assertNotNull((Object)message);
        TimeUnit.SECONDS.sleep(15L);
        try {
            consumer.receive(5000L);
            Assert.fail((String)"Slow consumer not aborted.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIdleConsumerCanBeAbortedNoMessages() throws Exception {
        this.strategy.setIgnoreIdleConsumers(false);
        this.strategy.setMaxTimeSinceLastAck(2000L);
        ActiveMQConnection conn = (ActiveMQConnection)this.createConnectionFactory().createConnection();
        conn.setExceptionListener((ExceptionListener)this);
        this.connections.add(conn);
        Session sess = conn.createSession(false, 2);
        MessageConsumer consumer = sess.createConsumer(this.destination);
        Assert.assertNotNull((Object)consumer);
        conn.start();
        this.startProducers(this.destination, 1);
        Message message = consumer.receive(5000L);
        Assert.assertNotNull((Object)message);
        TimeUnit.SECONDS.sleep(15L);
        try {
            consumer.receive(5000L);
            Assert.fail((String)"Idle consumer not aborted.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIdleConsumerCanBeAborted() throws Exception {
        this.strategy.setIgnoreIdleConsumers(false);
        this.strategy.setMaxTimeSinceLastAck(2000L);
        ActiveMQConnection conn = (ActiveMQConnection)this.createConnectionFactory().createConnection();
        conn.setExceptionListener((ExceptionListener)this);
        this.connections.add(conn);
        Session sess = conn.createSession(false, 2);
        MessageConsumer consumer = sess.createConsumer(this.destination);
        Assert.assertNotNull((Object)consumer);
        conn.start();
        this.startProducers(this.destination, 1);
        Message message = consumer.receive(5000L);
        Assert.assertNotNull((Object)message);
        message.acknowledge();
        TimeUnit.SECONDS.sleep(15L);
        try {
            consumer.receive(5000L);
            Assert.fail((String)"Idle consumer not aborted.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

