/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.policy.DeadLetterTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadLetterTest
extends DeadLetterTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DeadLetterTest.class);
    protected int rollbackCount;

    @Override
    protected void doTest() throws Exception {
        int i;
        this.connection.start();
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.connection;
        this.rollbackCount = amqConnection.getRedeliveryPolicy().getMaximumRedeliveries() + 1;
        LOG.info("Will redeliver messages: " + this.rollbackCount + " times");
        this.makeConsumer();
        this.makeDlqConsumer();
        this.sendMessages();
        for (i = 0; i < this.messageCount; ++i) {
            this.consumeAndRollback(i);
        }
        this.verifyIsDlq((Queue)this.dlqDestination);
        for (i = 0; i < this.messageCount; ++i) {
            Message msg = this.dlqConsumer.receive(1000L);
            this.assertMessage(msg, i);
            DeadLetterTest.assertNotNull((String)("Should be a DLQ message for loop: " + i), (Object)msg);
        }
        this.session.commit();
    }

    protected void consumeAndRollback(int messageCounter) throws Exception {
        for (int i = 0; i < this.rollbackCount; ++i) {
            Message message = this.consumer.receive(5000L);
            DeadLetterTest.assertNotNull((String)("No message received for message: " + messageCounter + " and rollback loop: " + i), (Object)message);
            this.assertMessage(message, messageCounter);
            this.session.rollback();
        }
        LOG.info("Rolled back: " + this.rollbackCount + " times");
    }

    @Override
    protected void setUp() throws Exception {
        this.transactedMode = true;
        super.setUp();
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = super.createConnectionFactory();
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setMaximumRedeliveries(3);
        policy.setBackOffMultiplier(1.0);
        policy.setInitialRedeliveryDelay(10L);
        policy.setUseExponentialBackOff(false);
        answer.setRedeliveryPolicy(policy);
        return answer;
    }

    @Override
    protected Destination createDlqDestination() {
        return new ActiveMQQueue("ActiveMQ.DLQ");
    }
}

