/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.Session;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.DeadLetterTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.SimpleAuthorizationMap;
import org.apache.activemq.security.SimpleSecurityBrokerSystemTest;

public class SecureDLQTest
extends DeadLetterTestSupport {
    Connection dlqConnection;
    Session dlqSession;

    public static AuthorizationMap createAuthorizationMap() {
        DefaultAuthorizationMap readAccess = new DefaultAuthorizationMap();
        readAccess.put((ActiveMQDestination)new ActiveMQQueue("TEST"), (Object)SimpleSecurityBrokerSystemTest.ADMINS);
        readAccess.put((ActiveMQDestination)new ActiveMQQueue("TEST"), (Object)SimpleSecurityBrokerSystemTest.USERS);
        readAccess.put((ActiveMQDestination)new ActiveMQQueue("ActiveMQ.DLQ"), (Object)SimpleSecurityBrokerSystemTest.ADMINS);
        DefaultAuthorizationMap writeAccess = new DefaultAuthorizationMap();
        writeAccess.put((ActiveMQDestination)new ActiveMQQueue("TEST"), (Object)SimpleSecurityBrokerSystemTest.ADMINS);
        writeAccess.put((ActiveMQDestination)new ActiveMQQueue("TEST"), (Object)SimpleSecurityBrokerSystemTest.USERS);
        writeAccess.put((ActiveMQDestination)new ActiveMQQueue("ActiveMQ.DLQ"), (Object)SimpleSecurityBrokerSystemTest.ADMINS);
        readAccess.put((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.>"), (Object)SimpleSecurityBrokerSystemTest.WILDCARD);
        writeAccess.put((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.>"), (Object)SimpleSecurityBrokerSystemTest.WILDCARD);
        DefaultAuthorizationMap adminAccess = new DefaultAuthorizationMap();
        adminAccess.put((ActiveMQDestination)new ActiveMQQueue("TEST"), (Object)SimpleSecurityBrokerSystemTest.ADMINS);
        adminAccess.put((ActiveMQDestination)new ActiveMQQueue("TEST"), (Object)SimpleSecurityBrokerSystemTest.USERS);
        adminAccess.put((ActiveMQDestination)new ActiveMQQueue("ActiveMQ.DLQ"), (Object)SimpleSecurityBrokerSystemTest.ADMINS);
        adminAccess.put((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.>"), (Object)SimpleSecurityBrokerSystemTest.WILDCARD);
        return new SimpleAuthorizationMap((DestinationMap)writeAccess, (DestinationMap)readAccess, (DestinationMap)adminAccess);
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        AuthorizationPlugin authorizationPlugin = new AuthorizationPlugin(SecureDLQTest.createAuthorizationMap());
        broker.setPlugins(new BrokerPlugin[]{authorizationPlugin, new SimpleSecurityBrokerSystemTest.SimpleAuthenticationFactory()});
        return broker;
    }

    @Override
    public void testTransientTopicMessage() throws Exception {
    }

    @Override
    public void testDurableTopicMessage() throws Exception {
    }

    @Override
    protected void doTest() throws Exception {
        this.timeToLive = 1000L;
        this.acknowledgeMode = 2;
        this.makeConsumer();
        this.sendMessages();
        Thread.sleep(1000L);
        this.consumer.close();
        Thread.sleep(1000L);
        this.makeConsumer();
        this.makeDlqConsumer();
        for (int i = 0; i < this.messageCount; ++i) {
            Message msg = this.dlqConsumer.receive(1000L);
            this.assertMessage(msg, i);
            SecureDLQTest.assertNotNull((String)("Should be a DLQ message for loop: " + i), (Object)msg);
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.dlqConnection != null) {
            this.dlqConnection.close();
        }
        super.tearDown();
    }

    @Override
    protected Connection createConnection() throws Exception {
        return this.getConnectionFactory().createConnection("user", "password");
    }

    @Override
    protected void makeDlqConsumer() throws Exception {
        this.dlqDestination = this.createDlqDestination();
        this.dlqConnection = this.getConnectionFactory().createConnection("system", "manager");
        this.dlqConnection.start();
        this.dlqSession = this.dlqConnection.createSession(false, 1);
        this.dlqConsumer = this.dlqSession.createConsumer(this.dlqDestination);
    }

    @Override
    protected Destination createDlqDestination() {
        return new ActiveMQQueue("ActiveMQ.DLQ");
    }

    @Override
    protected String getDestinationString() {
        return "TEST";
    }
}

