/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.util.List;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SendDuplicateFromStoreToDLQTest {
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    MessageProducer producer;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        File testDataDir = new File("target/activemq-data/AMQ-8397");
        this.broker.setDataDirectoryFile(testDataDir);
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x4000000L);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File(testDataDir, "kahadb"));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    @After
    public void tearDown() throws Exception {
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.deleteAllMessages();
        this.broker.stop();
    }

    @Test
    public void testSendDuplicateFromStoreToDLQTrue() throws Exception {
        this.applySendDuplicateFromStoreToDLQPolicy(true);
        this.doProcessSendDuplicateFromStoreToDLQ(true);
    }

    @Test
    public void testSendDuplicateFromStoreToDLQFalse() throws Exception {
        this.applySendDuplicateFromStoreToDLQPolicy(false);
        this.doProcessSendDuplicateFromStoreToDLQ(false);
    }

    @Test
    public void testSendDuplicateFromStoreToDLQDefaultValue() throws Exception {
        PolicyMap policyMap = this.applySendDuplicateFromStoreToDLQPolicy(null);
        Assert.assertFalse((boolean)policyMap.getDefaultEntry().isSendDuplicateFromStoreToDLQ());
        Queue queue = (Queue)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue("AMQ.8440"));
        Assert.assertFalse((boolean)queue.isSendDuplicateFromStoreToDLQ());
    }

    protected void doProcessSendDuplicateFromStoreToDLQ(boolean enabled) throws Exception {
        this.createQueue("AMQ.8397");
        Queue queue = (Queue)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue("AMQ.8397"));
        Assert.assertEquals((Object)0L, (Object)queue.getDestinationStatistics().getMessages().getCount());
        Assert.assertEquals((Object)0L, (Object)queue.getDestinationStatistics().getDuplicateFromStore().getCount());
        MessageConsumer messageConsumer = this.session.createConsumer((Destination)this.session.createQueue("AMQ.8397"));
        this.producer.send((Message)this.session.createTextMessage("Hello world!"));
        int loopCount = 0;
        int maxLoops = 50;
        boolean found = false;
        Message recvMessage = null;
        do {
            if ((recvMessage = messageConsumer.receive(200L)) == null) continue;
            found = true;
        } while (!found && ++loopCount < maxLoops);
        Assert.assertNotNull((Object)recvMessage);
        List queueSubscriptions = queue.getConsumers();
        Assert.assertNotNull((Object)queueSubscriptions);
        Assert.assertEquals((Object)1, (Object)queueSubscriptions.size());
        queue.duplicateFromStore((org.apache.activemq.command.Message)recvMessage, (Subscription)queueSubscriptions.get(0));
        Queue dlq = (Queue)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue("ActiveMQ.DLQ.Queue.AMQ.8397"));
        if (enabled) {
            Assert.assertEquals((Object)0L, (Object)queue.getDestinationStatistics().getMessages().getCount());
            Assert.assertEquals((Object)1L, (Object)queue.getDestinationStatistics().getDuplicateFromStore().getCount());
            Assert.assertEquals((Object)1L, (Object)dlq.getDestinationStatistics().getMessages().getCount());
            Assert.assertEquals((Object)0L, (Object)dlq.getDestinationStatistics().getDuplicateFromStore().getCount());
        } else {
            Assert.assertEquals((Object)0L, (Object)queue.getDestinationStatistics().getMessages().getCount());
            Assert.assertEquals((Object)1L, (Object)queue.getDestinationStatistics().getDuplicateFromStore().getCount());
            Assert.assertEquals((Object)0L, (Object)dlq.getDestinationStatistics().getMessages().getCount());
            Assert.assertEquals((Object)0L, (Object)dlq.getDestinationStatistics().getDuplicateFromStore().getCount());
        }
    }

    private PolicyMap applySendDuplicateFromStoreToDLQPolicy(Boolean enabled) {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        if (enabled != null) {
            defaultEntry.setSendDuplicateFromStoreToDLQ(enabled.booleanValue());
        }
        defaultEntry.setDeadLetterStrategy((DeadLetterStrategy)new IndividualDeadLetterStrategy());
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        return policyMap;
    }

    private void createQueue(String queueName) throws Exception {
        jakarta.jms.Queue queue = this.session.createQueue(queueName);
        this.producer = this.session.createProducer((Destination)queue);
    }
}

