/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.cursors.QueueStorePrefetch;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.AbstractMessageStore;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.usage.SystemUsage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreQueueCursorOrderTest {
    private static final Logger LOG = LoggerFactory.getLogger(StoreQueueCursorOrderTest.class);
    ActiveMQQueue destination = new ActiveMQQueue("queue-" + StoreQueueCursorOrderTest.class.getSimpleName());
    BrokerService brokerService;
    static final String mesageIdRoot = "11111:22222:0:";
    final int messageBytesSize = 1024;
    final String text = new String(new byte[1024]);

    @Before
    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.setUseJmx(false);
        this.brokerService.deleteAllMessages();
        this.brokerService.start();
    }

    protected BrokerService createBroker() throws Exception {
        return new BrokerService();
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
    }

    @Test
    public void tesBlockedFuture() throws Exception {
        int count = 2;
        Message[] messages = new Message[2];
        TestMessageStore queueMessageStore = new TestMessageStore(messages, (ActiveMQDestination)this.destination);
        ConsumerInfo consumerInfo = new ConsumerInfo();
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        consumerInfo.setExclusive(true);
        Queue queue = new Queue(this.brokerService, (ActiveMQDestination)this.destination, (MessageStore)queueMessageStore, destinationStatistics, null);
        queueMessageStore.start();
        queueMessageStore.registerIndexListener(null);
        QueueStorePrefetch underTest = new QueueStorePrefetch(queue, this.brokerService.getBroker());
        SystemUsage systemUsage = new SystemUsage();
        systemUsage.getMemoryUsage().setLimit(1024L);
        underTest.setSystemUsage(systemUsage);
        underTest.setEnableAudit(false);
        underTest.start();
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        ActiveMQTextMessage msg = this.getMessage(0);
        messages[1] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.setRecievedByDFBridge(true);
        FutureTask<Long> future = new FutureTask<Long>(new Runnable(){

            @Override
            public void run() {
            }
        }, Long.valueOf(2L)){};
        msg.getMessageId().setFutureOrSequenceLong((Object)future);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        msg = this.getMessage(1);
        messages[0] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)1L);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache is disabled as limit reached", (!underTest.isCacheEnabled() ? 1 : 0) != 0);
        Assert.assertEquals((String)"setBatch unset", (long)0L, (long)queueMessageStore.batch.get());
        int dequeueCount = 0;
        underTest.setMaxBatchSize(2);
        underTest.reset();
        while (underTest.hasNext() && dequeueCount < 2) {
            MessageReference ref = underTest.next();
            ref.decrementReferenceCount();
            underTest.remove();
            LOG.info("Received message: {} with body: {}", (Object)ref.getMessageId(), (Object)((ActiveMQTextMessage)ref.getMessage()).getText());
            Assert.assertEquals((long)dequeueCount++, (long)ref.getMessageId().getProducerSequenceId());
        }
        underTest.release();
        Assert.assertEquals((long)2L, (long)dequeueCount);
    }

    @Test
    public void testNoSetBatchWithUnOrderedFutureCurrentSync() throws Exception {
        int count = 2;
        Message[] messages = new Message[2];
        TestMessageStore queueMessageStore = new TestMessageStore(messages, (ActiveMQDestination)this.destination);
        ConsumerInfo consumerInfo = new ConsumerInfo();
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        consumerInfo.setExclusive(true);
        Queue queue = new Queue(this.brokerService, (ActiveMQDestination)this.destination, (MessageStore)queueMessageStore, destinationStatistics, null);
        queueMessageStore.start();
        queueMessageStore.registerIndexListener(null);
        QueueStorePrefetch underTest = new QueueStorePrefetch(queue, this.brokerService.getBroker());
        SystemUsage systemUsage = new SystemUsage();
        systemUsage.getMemoryUsage().setLimit(1024L);
        underTest.setSystemUsage(systemUsage);
        underTest.setEnableAudit(false);
        underTest.start();
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        ActiveMQTextMessage msg = this.getMessage(0);
        messages[1] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.setRecievedByDFBridge(true);
        final ActiveMQTextMessage msgRef = msg;
        FutureTask<Long> future = new FutureTask<Long>(new Runnable(){

            @Override
            public void run() {
                msgRef.getMessageId().setFutureOrSequenceLong((Object)1L);
            }
        }, Long.valueOf(1L)){};
        msg.getMessageId().setFutureOrSequenceLong((Object)future);
        Executors.newSingleThreadExecutor().submit(future);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        msg = this.getMessage(1);
        messages[0] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)0L);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache is disabled as limit reached", (!underTest.isCacheEnabled() ? 1 : 0) != 0);
        Assert.assertEquals((String)"setBatch unset", (long)0L, (long)queueMessageStore.batch.get());
        int dequeueCount = 0;
        underTest.setMaxBatchSize(2);
        underTest.reset();
        while (underTest.hasNext() && dequeueCount < 2) {
            MessageReference ref = underTest.next();
            ref.decrementReferenceCount();
            underTest.remove();
            LOG.info("Received message: {} with body: {}", (Object)ref.getMessageId(), (Object)((ActiveMQTextMessage)ref.getMessage()).getText());
            Assert.assertEquals((long)dequeueCount++, (long)ref.getMessageId().getProducerSequenceId());
        }
        underTest.release();
        Assert.assertEquals((long)2L, (long)dequeueCount);
    }

    @Test
    public void testSetBatchWithOrderedFutureCurrentFuture() throws Exception {
        int count = 2;
        Message[] messages = new Message[2];
        TestMessageStore queueMessageStore = new TestMessageStore(messages, (ActiveMQDestination)this.destination);
        ConsumerInfo consumerInfo = new ConsumerInfo();
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        consumerInfo.setExclusive(true);
        Queue queue = new Queue(this.brokerService, (ActiveMQDestination)this.destination, (MessageStore)queueMessageStore, destinationStatistics, null);
        queueMessageStore.start();
        queueMessageStore.registerIndexListener(null);
        QueueStorePrefetch underTest = new QueueStorePrefetch(queue, this.brokerService.getBroker());
        SystemUsage systemUsage = new SystemUsage();
        systemUsage.getMemoryUsage().setLimit(1024L);
        underTest.setSystemUsage(systemUsage);
        underTest.setEnableAudit(false);
        underTest.start();
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        ActiveMQTextMessage msg = this.getMessage(0);
        messages[0] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.setRecievedByDFBridge(true);
        final ActiveMQTextMessage msgRef = msg;
        FutureTask<Long> future = new FutureTask<Long>(new Runnable(){

            @Override
            public void run() {
                msgRef.getMessageId().setFutureOrSequenceLong((Object)0L);
            }
        }, Long.valueOf(0L)){};
        msg.getMessageId().setFutureOrSequenceLong((Object)future);
        Executors.newSingleThreadExecutor().submit(future);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        msg = this.getMessage(1);
        messages[1] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.setRecievedByDFBridge(true);
        final ActiveMQTextMessage msgRe2f = msg;
        FutureTask<Long> future2 = new FutureTask<Long>(new Runnable(){

            @Override
            public void run() {
                msgRe2f.getMessageId().setFutureOrSequenceLong((Object)1L);
            }
        }, Long.valueOf(1L)){};
        msg.getMessageId().setFutureOrSequenceLong((Object)future2);
        Executors.newSingleThreadExecutor().submit(future2);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache is disabled as limit reached", (!underTest.isCacheEnabled() ? 1 : 0) != 0);
        Assert.assertEquals((String)"setBatch set", (long)1L, (long)queueMessageStore.batch.get());
        int dequeueCount = 0;
        underTest.setMaxBatchSize(2);
        underTest.reset();
        while (underTest.hasNext() && dequeueCount < 2) {
            MessageReference ref = underTest.next();
            ref.decrementReferenceCount();
            underTest.remove();
            LOG.info("Received message: {} with body: {}", (Object)ref.getMessageId(), (Object)((ActiveMQTextMessage)ref.getMessage()).getText());
            Assert.assertEquals((long)dequeueCount++, (long)ref.getMessageId().getProducerSequenceId());
        }
        underTest.release();
        Assert.assertEquals((long)2L, (long)dequeueCount);
    }

    @Test
    public void testSetBatchWithFuture() throws Exception {
        int count = 4;
        Message[] messages = new Message[4];
        TestMessageStore queueMessageStore = new TestMessageStore(messages, (ActiveMQDestination)this.destination);
        ConsumerInfo consumerInfo = new ConsumerInfo();
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        consumerInfo.setExclusive(true);
        Queue queue = new Queue(this.brokerService, (ActiveMQDestination)this.destination, (MessageStore)queueMessageStore, destinationStatistics, null);
        queueMessageStore.start();
        queueMessageStore.registerIndexListener(null);
        QueueStorePrefetch underTest = new QueueStorePrefetch(queue, this.brokerService.getBroker());
        SystemUsage systemUsage = new SystemUsage();
        systemUsage.getMemoryUsage().setLimit(10240L);
        underTest.setSystemUsage(systemUsage);
        underTest.setEnableAudit(false);
        underTest.start();
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        ActiveMQTextMessage msg = this.getMessage(0);
        messages[0] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.setRecievedByDFBridge(true);
        final ActiveMQTextMessage msgRef = msg;
        FutureTask<Long> future0 = new FutureTask<Long>(new Runnable(){

            @Override
            public void run() {
                msgRef.getMessageId().setFutureOrSequenceLong((Object)0L);
            }
        }, Long.valueOf(0L)){};
        msg.getMessageId().setFutureOrSequenceLong((Object)future0);
        underTest.addMessageLast((MessageReference)msg);
        Executors.newSingleThreadExecutor().submit(future0);
        msg = this.getMessage(1);
        messages[3] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.setRecievedByDFBridge(true);
        final ActiveMQTextMessage msgRef1 = msg;
        FutureTask<Long> future1 = new FutureTask<Long>(new Runnable(){

            @Override
            public void run() {
                msgRef1.getMessageId().setFutureOrSequenceLong((Object)3L);
            }
        }, Long.valueOf(3L)){};
        msg.getMessageId().setFutureOrSequenceLong((Object)future1);
        underTest.addMessageLast((MessageReference)msg);
        msg = this.getMessage(2);
        messages[1] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)1L);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        Executors.newSingleThreadExecutor().submit(future1);
        msg = this.getMessage(3);
        messages[2] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)2L);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache is disabled as limit reached", (!underTest.isCacheEnabled() ? 1 : 0) != 0);
        Assert.assertEquals((String)"setBatch set", (long)2L, (long)queueMessageStore.batch.get());
        int dequeueCount = 0;
        underTest.setMaxBatchSize(4);
        underTest.reset();
        while (underTest.hasNext() && dequeueCount < 4) {
            MessageReference ref = underTest.next();
            ref.decrementReferenceCount();
            underTest.remove();
            LOG.info("Received message: {} with body: {}", (Object)ref.getMessageId(), (Object)((ActiveMQTextMessage)ref.getMessage()).getText());
            Assert.assertEquals((long)dequeueCount++, (long)ref.getMessageId().getProducerSequenceId());
        }
        underTest.release();
        Assert.assertEquals((long)4L, (long)dequeueCount);
        msg = this.getMessage(4);
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)4L);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache enabled on empty store", (boolean)underTest.isCacheEnabled());
    }

    @Test
    public void testSetBatch() throws Exception {
        int count = 3;
        Message[] messages = new Message[3];
        TestMessageStore queueMessageStore = new TestMessageStore(messages, (ActiveMQDestination)this.destination);
        ConsumerInfo consumerInfo = new ConsumerInfo();
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        consumerInfo.setExclusive(true);
        Queue queue = new Queue(this.brokerService, (ActiveMQDestination)this.destination, (MessageStore)queueMessageStore, destinationStatistics, null);
        queueMessageStore.start();
        queueMessageStore.registerIndexListener(null);
        QueueStorePrefetch underTest = new QueueStorePrefetch(queue, this.brokerService.getBroker());
        SystemUsage systemUsage = new SystemUsage();
        systemUsage.getMemoryUsage().setLimit(5120L);
        underTest.setSystemUsage(systemUsage);
        underTest.setEnableAudit(false);
        underTest.start();
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        ActiveMQTextMessage msg = this.getMessage(0);
        messages[0] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)0L);
        underTest.addMessageLast((MessageReference)msg);
        msg = this.getMessage(1);
        messages[1] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)1L);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache enabled", (underTest.isUseCache() && underTest.isCacheEnabled() ? 1 : 0) != 0);
        msg = this.getMessage(2);
        messages[2] = msg;
        msg.setMemoryUsage(systemUsage.getMemoryUsage());
        msg.getMessageId().setFutureOrSequenceLong((Object)2L);
        underTest.addMessageLast((MessageReference)msg);
        Assert.assertTrue((String)"cache is disabled as limit reached", (!underTest.isCacheEnabled() ? 1 : 0) != 0);
        Assert.assertEquals((String)"setBatch set", (long)2L, (long)queueMessageStore.batch.get());
        int dequeueCount = 0;
        underTest.setMaxBatchSize(2);
        underTest.reset();
        while (underTest.hasNext() && dequeueCount < 3) {
            MessageReference ref = underTest.next();
            ref.decrementReferenceCount();
            underTest.remove();
            LOG.info("Received message: {} with body: {}", (Object)ref.getMessageId(), (Object)((ActiveMQTextMessage)ref.getMessage()).getText());
            Assert.assertEquals((long)dequeueCount++, (long)ref.getMessageId().getProducerSequenceId());
        }
        underTest.release();
        Assert.assertEquals((long)3L, (long)dequeueCount);
    }

    private ActiveMQTextMessage getMessage(int i) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        MessageId id = new MessageId(mesageIdRoot + i);
        id.setBrokerSequenceId((long)i);
        id.setProducerSequenceId((long)i);
        message.setMessageId(id);
        message.setDestination((ActiveMQDestination)this.destination);
        message.setPersistent(true);
        message.setResponseRequired(true);
        message.setText("Msg:" + i + " " + this.text);
        Assert.assertEquals((long)message.getMessageId().getProducerSequenceId(), (long)i);
        return message;
    }

    class TestMessageStore
    extends AbstractMessageStore {
        final Message[] messages;
        public AtomicLong batch;

        public TestMessageStore(Message[] messages, ActiveMQDestination dest) {
            super(dest);
            this.batch = new AtomicLong();
            this.messages = messages;
        }

        public void addMessage(ConnectionContext context, Message message) throws IOException {
        }

        public Message getMessage(MessageId identity) throws IOException {
            return null;
        }

        public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        }

        public void removeAllMessages(ConnectionContext context) throws IOException {
        }

        public void recover(MessageRecoveryListener container) throws Exception {
        }

        public void resetBatching() {
        }

        public void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
            for (int i = this.batch.intValue(); i < this.messages.length; ++i) {
                LOG.info("recovered index:" + i);
                listener.recoverMessage(this.messages[i]);
            }
        }

        public void recoverNextMessages(int offset, int maxReturned, MessageRecoveryListener listener) throws Exception {
        }

        public void setBatch(MessageId message) {
            this.batch.set((Long)message.getFutureOrSequenceLong());
            this.batch.incrementAndGet();
        }

        public void recoverMessageStoreStatistics() throws IOException {
            this.getMessageStoreStatistics().reset();
        }
    }
}

