/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.net.URI;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.test.JmsTopicSendReceiveTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBrokerTest
extends JmsTopicSendReceiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(PluginBrokerTest.class);
    private BrokerService broker;

    @Override
    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/util/plugin-broker.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    @Override
    protected void assertMessageValid(int index, Message message) throws JMSException {
        PluginBrokerTest.assertEquals((String)"localhost", (String)message.getStringProperty("BrokerPath"));
        ActiveMQMessage amqMsg = (ActiveMQMessage)message;
        if (index == 7) {
            PluginBrokerTest.assertTrue((String)"expiration is in range, depends on two distinct calls to System.currentTimeMillis", (1500L < amqMsg.getExpiration() - amqMsg.getTimestamp() ? 1 : 0) != 0);
        } else if (index == 9) {
            PluginBrokerTest.assertTrue((String)"expiration ceeling is in range, depends on two distinct calls to System.currentTimeMillis", (59500L < amqMsg.getExpiration() - amqMsg.getTimestamp() ? 1 : 0) != 0);
        } else {
            PluginBrokerTest.assertEquals((long)1000L, (long)(amqMsg.getExpiration() - amqMsg.getTimestamp()));
        }
        super.assertMessageValid(index, message);
    }

    @Override
    protected void sendMessage(int index, Message message) throws Exception {
        if (index == 7) {
            this.producer.send(this.producerDestination, message, 2, 4, 2000L);
        } else if (index == 9) {
            this.producer.send(this.producerDestination, message, 2, 4, 200000L);
        } else {
            super.sendMessage(index, message);
        }
    }
}

