/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.MirroredQueue;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3157Test
extends EmbeddedBrokerTestSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ3157Test.class);
    private Connection connection;

    public void testInactiveMirroredQueueIsCleanedUp() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList = new ConsumerBean();
        messageList.setVerbose(true);
        ActiveMQDestination consumeDestination = this.createConsumeDestination();
        Session session = this.connection.createSession(false, 1);
        LOG.info("Consuming from: " + consumeDestination);
        MessageConsumer c1 = session.createConsumer((Destination)consumeDestination);
        c1.setMessageListener((MessageListener)messageList);
        ActiveMQQueue sendDestination = new ActiveMQQueue(this.getQueueName());
        LOG.info("Sending to: " + sendDestination);
        MessageProducer producer = session.createProducer((Destination)sendDestination);
        AMQ3157Test.assertNotNull((Object)producer);
        int total = 10;
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)session.createTextMessage("message: " + i));
        }
        messageList.assertMessagesArrived(10);
        LOG.info("Received: " + messageList);
        messageList.flushMessages();
        MessageConsumer c2 = session.createConsumer((Destination)sendDestination);
        c2.setMessageListener((MessageListener)messageList);
        messageList.assertMessagesArrived(10);
        LOG.info("Q Received: " + messageList);
        this.connection.close();
        List<ObjectName> topics = Arrays.asList(this.broker.getAdminView().getTopics());
        AMQ3157Test.assertTrue((boolean)topics.contains(this.createObjectName(consumeDestination)));
        List<ObjectName> queues = Arrays.asList(this.broker.getAdminView().getQueues());
        AMQ3157Test.assertTrue((boolean)queues.contains(this.createObjectName((ActiveMQDestination)sendDestination)));
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        topics = Arrays.asList(this.broker.getAdminView().getTopics());
        if (topics != null) {
            AMQ3157Test.assertFalse((String)"Virtual Topic Desination did not get cleaned up.", (boolean)topics.contains(this.createObjectName(consumeDestination)));
        }
        if ((queues = Arrays.asList(this.broker.getAdminView().getQueues())) != null) {
            AMQ3157Test.assertFalse((String)"Mirrored Queue Desination did not get cleaned up.", (boolean)queues.contains(this.createObjectName((ActiveMQDestination)sendDestination)));
        }
    }

    protected ActiveMQDestination createConsumeDestination() {
        return new ActiveMQTopic("VirtualTopic.Mirror." + this.getQueueName());
    }

    protected String getQueueName() {
        return "My.Queue";
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseMirroredQueues(true);
        answer.setPersistent(this.isPersistent());
        answer.setSchedulePeriodForDestinationPurge(1000);
        PolicyEntry entry = new PolicyEntry();
        entry.setGcInactiveDestinations(true);
        entry.setInactiveTimoutBeforeGC(5000L);
        entry.setProducerFlowControl(true);
        PolicyMap map = new PolicyMap();
        map.setDefaultEntry(entry);
        MirroredQueue mirrorQ = new MirroredQueue();
        mirrorQ.setCopyMessage(true);
        DestinationInterceptor[] destinationInterceptors = new DestinationInterceptor[]{mirrorQ};
        answer.setDestinationInterceptors(destinationInterceptors);
        answer.setDestinationPolicy(map);
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected DestinationViewMBean createView(ActiveMQDestination destination) throws Exception {
        String domain = "org.apache.activemq";
        ObjectName name = destination.isQueue() ? new ObjectName(domain + ":BrokerName=localhost,Type=Queue,Destination=" + destination.getPhysicalName()) : new ObjectName(domain + ":BrokerName=localhost,Type=Topic,Destination=" + destination.getPhysicalName());
        return (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
    }

    protected ObjectName createObjectName(ActiveMQDestination destination) throws Exception {
        String domain = "org.apache.activemq";
        ObjectName name = destination.isQueue() ? new ObjectName(domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + destination.getPhysicalName()) : new ObjectName(domain + ":type=Broker,brokerName=localhost,destinationType=Topic,destinationName=" + destination.getPhysicalName());
        return name;
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

