/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQTopicSubscriber;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3678Test
implements MessageListener {
    private static Logger LOG = LoggerFactory.getLogger(AMQ3678Test.class);
    private BrokerService broker;
    private String connectionURI;
    private final AtomicInteger messagesSent = new AtomicInteger(0);
    private final AtomicInteger messagesReceived = new AtomicInteger(0);
    private final ActiveMQTopic destination = new ActiveMQTopic("XYZ");
    private final CountDownLatch latch = new CountDownLatch(2);
    private final int deliveryMode = 1;

    @Test(timeout=60000L)
    public void countConsumers() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionURI);
        factory.setAlwaysSyncSend(true);
        factory.setDispatchAsync(false);
        Connection producerConnection = factory.createConnection();
        producerConnection.start();
        Connection consumerConnection = factory.createConnection();
        consumerConnection.setClientID("subscriber1");
        Session consumerMQSession = consumerConnection.createSession(false, 2);
        ActiveMQTopicSubscriber activeConsumer = (ActiveMQTopicSubscriber)consumerMQSession.createDurableSubscriber((Topic)this.destination, "myTopic?consumer.prefetchSize=1");
        activeConsumer.setMessageListener((MessageListener)this);
        consumerConnection.start();
        final Session producerSession = producerConnection.createSession(false, 1);
        final MessageProducer producer = producerSession.createProducer((Destination)this.destination);
        producer.setDeliveryMode(1);
        Thread t = new Thread(new Runnable(){
            private boolean done = false;

            @Override
            public void run() {
                while (!this.done) {
                    if (AMQ3678Test.this.messagesSent.get() == 50) {
                        try {
                            AMQ3678Test.this.broker.getAdminView().removeTopic(AMQ3678Test.this.destination.getTopicName());
                        }
                        catch (Exception e1) {
                            Assert.fail((String)("Unable to remove destination:" + AMQ3678Test.this.destination.getPhysicalName()));
                        }
                    }
                    try {
                        producer.send((Message)producerSession.createTextMessage());
                        int val = AMQ3678Test.this.messagesSent.incrementAndGet();
                        LOG.trace("sent message (" + val + ")");
                        if (val != 100) continue;
                        this.done = true;
                        AMQ3678Test.this.latch.countDown();
                        producer.close();
                        producerSession.close();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.start();
        try {
            if (!this.latch.await(10L, TimeUnit.SECONDS)) {
                Assert.fail((String)"did not receive all the messages");
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)"did not receive all the messages, exception waiting for latch");
        }
    }

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.getManagementContext().setCreateConnector(false);
        this.broker.setAdvisorySupport(false);
        TransportConnector connector = this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionURI = connector.getPublishableConnectString();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    public void onMessage(Message message) {
        try {
            message.acknowledge();
            int val = this.messagesReceived.incrementAndGet();
            LOG.trace("received message (" + val + ")");
            if (this.messagesReceived.get() == 100) {
                this.latch.countDown();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

