/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringSslContext;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.activemq.transport.stomp.StompFrame;
import org.fusesource.mqtt.client.MQTT;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AMQ4133Test {
    protected String java_security_auth_login_config = "java.security.auth.login.config";
    protected String xbean = "xbean:";
    protected String confBase = "src/test/resources/org/apache/activemq/bugs/amq4126";
    protected String certBase = "src/test/resources/org/apache/activemq/security";
    protected String activemqXml = "InconsistentConnectorPropertiesBehaviour.xml";
    protected BrokerService broker;
    protected String oldLoginConf = null;

    @Before
    public void before() throws Exception {
        if (System.getProperty(this.java_security_auth_login_config) != null) {
            this.oldLoginConf = System.getProperty(this.java_security_auth_login_config);
        }
        System.setProperty(this.java_security_auth_login_config, this.confBase + "/login.config");
        this.broker = BrokerFactory.createBroker((String)(this.xbean + this.confBase + "/" + this.activemqXml));
        this.broker.start();
        this.broker.waitUntilStarted();
        System.setProperty("javax.net.ssl.trustStore", this.certBase + "/broker1.ks");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStoreType", "jks");
        System.setProperty("javax.net.ssl.keyStore", this.certBase + "/client.ks");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.keyStoreType", "jks");
    }

    @After
    public void after() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void stompSSLTransportNeedClientAuthTrue() throws Exception {
        this.stompConnectTo("localhost", this.broker.getConnectorByName("stomp+ssl").getConnectUri().getPort());
    }

    @Test
    public void stompSSLNeedClientAuthTrue() throws Exception {
        this.stompConnectTo("localhost", this.broker.getConnectorByName("stomp+ssl+special").getConnectUri().getPort());
    }

    @Test
    public void stompNIOSSLTransportNeedClientAuthTrue() throws Exception {
        this.stompConnectTo("localhost", this.broker.getConnectorByName("stomp+nio+ssl").getConnectUri().getPort());
    }

    @Test
    public void stompNIOSSLNeedClientAuthTrue() throws Exception {
        this.stompConnectTo("localhost", this.broker.getConnectorByName("stomp+nio+ssl+special").getConnectUri().getPort());
    }

    @Test
    public void mqttSSLNeedClientAuthTrue() throws Exception {
        this.mqttConnectTo("localhost", this.broker.getConnectorByName("mqtt+ssl").getConnectUri().getPort());
    }

    @Test
    public void mqttNIOSSLNeedClientAuthTrue() throws Exception {
        this.mqttConnectTo("localhost", this.broker.getConnectorByName("mqtt+nio+ssl").getConnectUri().getPort());
    }

    public Socket createSocket(String host, int port) throws Exception {
        SocketFactory factory = SSLSocketFactory.getDefault();
        return factory.createSocket(host, port);
    }

    public void stompConnectTo(String host, int port) throws Exception {
        StompConnection stompConnection = new StompConnection();
        stompConnection.open(this.createSocket(host, port));
        stompConnection.sendFrame("CONNECT\n\n\u0000");
        StompFrame f = stompConnection.receive();
        TestCase.assertEquals((String)f.getBody(), (String)"CONNECTED", (String)f.getAction());
        stompConnection.close();
    }

    public void mqttConnectTo(String host, int port) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setConnectAttemptsMax(1L);
        mqtt.setReconnectAttemptsMax(0L);
        mqtt.setHost("tls://" + host + ":" + port);
        mqtt.setClientId("test");
        mqtt.setCleanSession(true);
        SpringSslContext context = new SpringSslContext();
        context.setKeyStore(this.certBase + "/client.ks");
        context.setKeyStorePassword("password");
        context.setTrustStore(this.certBase + "/broker1.ks");
        context.setTrustStorePassword("password");
        context.afterPropertiesSet();
        mqtt.setSslContext(SSLContext.getDefault());
        mqtt.blockingConnection().connect();
    }
}

