/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPerMessageTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionPerMessageTest.class);
    private static final int COUNT = 2000;
    protected String bindAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionPerMessage() throws Exception {
        String topicName = "test.topic";
        LOG.info("Initializing connection factory for JMS to URL: " + this.bindAddress);
        ActiveMQConnectionFactory normalFactory = new ActiveMQConnectionFactory();
        normalFactory.setBrokerURL(this.bindAddress);
        for (int i = 0; i < 2000; ++i) {
            if (i % 100 == 0) {
                LOG.info(Integer.toString(i));
            }
            Connection conn = null;
            try {
                conn = normalFactory.createConnection();
                Session session = conn.createSession(false, 1);
                Topic topic = session.createTopic("test.topic");
                MessageProducer producer = session.createProducer((Destination)topic);
                producer.setDeliveryMode(2);
                MapMessage m = session.createMapMessage();
                m.setInt("hey", i);
                producer.send((Message)m);
                continue;
            }
            catch (JMSException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (JMSException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setUseJmx(false);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

