/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RawRollbackSharedConsumerTests {
    private static ConnectionFactory connectionFactory;
    private static Destination queue;
    private static BrokerService broker;

    @BeforeClass
    public static void clean() throws Exception {
        broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setUseJmx(true);
        broker.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL("vm://localhost?async=false");
        RawRollbackSharedConsumerTests.connectionFactory = connectionFactory;
        queue = new ActiveMQQueue("queue");
    }

    @AfterClass
    public static void close() throws Exception {
        broker.stop();
    }

    @Before
    public void clearData() throws Exception {
        this.getMessages(false);
        this.convertAndSend("foo");
        this.convertAndSend("bar");
    }

    @After
    public void checkPostConditions() throws Exception {
        Thread.sleep(1000L);
        List<String> list = this.getMessages(false);
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testReceiveMessages() throws Exception {
        List<String> list = this.getMessages(true);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foo"));
    }

    private void convertAndSend(String msg) throws Exception {
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(true, 1);
        MessageProducer producer = session.createProducer(queue);
        producer.send((Message)session.createTextMessage(msg));
        producer.close();
        session.commit();
        session.close();
        connection.close();
    }

    private List<String> getMessages(boolean rollback) throws Exception {
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(true, 1);
        String next = "";
        ArrayList<String> msgs = new ArrayList<String>();
        MessageConsumer consumer = session.createConsumer(queue);
        while (next != null) {
            next = this.receiveAndConvert(consumer);
            if (next == null) continue;
            msgs.add(next);
        }
        consumer.close();
        if (rollback) {
            session.rollback();
        } else {
            session.commit();
        }
        session.close();
        connection.close();
        return msgs;
    }

    private String receiveAndConvert(MessageConsumer consumer) throws Exception {
        Message message = consumer.receive(100L);
        if (message == null) {
            return null;
        }
        return ((TextMessage)message).getText();
    }
}

